/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionStreamer;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsException;
import com.adobe.aem.commons.assetshare.content.renditions.download.impl.AssetRenditionDownloadRequest;
import com.adobe.aem.commons.assetshare.content.renditions.download.impl.AssetRenditionDownloadResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Cfg.class)
public class AssetRenditionStreamerImpl
implements AssetRenditionStreamer {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionStreamerImpl.class);
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;
    @Reference
    private AssetRenditionDispatchers assetRenditionDispatchers;
    private Cfg cfg;

    @Override
    public AssetRenditionStreamer.AssetRenditionStream getAssetRendition(SlingHttpServletRequest request, SlingHttpServletResponse response, AssetModel asset, String renditionName) throws AssetRenditionsException {
        try {
            AssetRenditionDownloadResponse assetRenditionDownloadResponse = this.sendDispatchForAssetRendition(request, response, asset, renditionName);
            if (assetRenditionDownloadResponse.getStatusCode() > 302) {
                throw new AssetRenditionsException(String.format("Response of [ %s ] from dispatched response is unacceptable. Unable to stream [ %s ].", assetRenditionDownloadResponse.getStatusCode(), asset.getPath()));
            }
            if (assetRenditionDownloadResponse.isRedirect()) {
                return this.fetchExternalRendition(assetRenditionDownloadResponse.getRedirect());
            }
            return new StreamImpl(assetRenditionDownloadResponse.getByteArrayOutputStream(), assetRenditionDownloadResponse.getContentType());
        }
        catch (ServletException e) {
            throw new AssetRenditionsException(String.format("Unable to fetch internal Asset Rendition output stream for [  %s @ %s ]", asset.getPath(), renditionName));
        }
        catch (IOException e) {
            throw new AssetRenditionsException(String.format("Unable to fetch external Asset Rendition output stream for [  %s @ %s ]", asset.getPath(), renditionName));
        }
    }

    protected AssetRenditionDownloadResponse sendDispatchForAssetRendition(SlingHttpServletRequest realRequest, SlingHttpServletResponse realResponse, AssetModel asset, String renditionName) throws IOException, ServletException {
        AssetRenditionDownloadRequest assetRenditionRequest = new AssetRenditionDownloadRequest(realRequest, "GET", asset.getResource(), ArrayUtils.EMPTY_STRING_ARRAY, "renditions", "/" + renditionName + "/" + "asset.rendition");
        AssetRenditionDownloadResponse assetRenditionResponse = new AssetRenditionDownloadResponse(realResponse, new StringWriter(), new ByteArrayOutputStream());
        for (AssetRenditionDispatcher assetRenditionDispatcher : this.assetRenditionDispatchers.getAssetRenditionDispatchers()) {
            if (!this.acceptedByAssetRenditionDispatcher(assetRenditionDispatcher, new AssetRenditionParameters((SlingHttpServletRequest)assetRenditionRequest))) continue;
            assetRenditionDispatcher.dispatch((SlingHttpServletRequest)assetRenditionRequest, (SlingHttpServletResponse)assetRenditionResponse);
            break;
        }
        return assetRenditionResponse;
    }

    protected boolean acceptedByAssetRenditionDispatcher(AssetRenditionDispatcher assetRenditionDispatcher, AssetRenditionParameters parameters) {
        if (assetRenditionDispatcher.getRenditionNames() == null || this.assetRenditionDispatchers == null || StringUtils.isBlank((CharSequence)parameters.getRenditionName())) {
            return false;
        }
        return assetRenditionDispatcher.getRenditionNames().contains(parameters.getRenditionName());
    }

    protected AssetRenditionStreamer.AssetRenditionStream fetchExternalRendition(String uri) throws IOException {
        HttpGet get = new HttpGet(uri);
        try (CloseableHttpClient httpClient = this.getHttpClient(this.cfg.http_fetch_timeout());){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)baos);
            response.close();
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            StreamImpl streamImpl = new StreamImpl(baos, contentTypeHeader.getValue());
            return streamImpl;
        }
    }

    protected CloseableHttpClient getHttpClient(int timeoutInMilliSeconds) {
        RequestConfig requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(timeoutInMilliSeconds).setConnectTimeout(timeoutInMilliSeconds).setConnectionRequestTimeout(timeoutInMilliSeconds).build();
        return this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(requestConfig).build();
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Rendition Streamer")
    public static @interface Cfg {
        @AttributeDefinition(name="HTTP (External) Fetch Timeout", description="HTTP Request timeout for external dispatching. Value is in milliseconds. Default is 600000 ms, or 10 minutes.")
        public int http_fetch_timeout() default 600000;
    }

    public class StreamImpl
    implements AssetRenditionStreamer.AssetRenditionStream {
        private final ByteArrayOutputStream outputStream;
        private final String contentType;

        public StreamImpl(ByteArrayOutputStream outputStream, String contentType) {
            this.outputStream = outputStream;
            this.contentType = contentType;
        }

        @Override
        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }
    }
}

