/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl;

import com.adobe.aem.commons.assetshare.search.FastProperties;
import com.adobe.aem.commons.assetshare.util.impl.OakIndexResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FastProperties.class})
@Designate(ocd=Cfg.class)
public class FastPropertiesImpl
implements FastProperties {
    private static final Logger log = LoggerFactory.getLogger(FastPropertiesImpl.class);
    private static final String PN_NAME = "name";
    private static final String SERVICE_NAME = "oak-index-definition-reader";
    protected static final String NN_OAK_INDEX = "/oak:index";
    protected static final String NN_DAM_ASSET_LUCENE_INDEX = "damAssetLucene";
    protected static final String INDEX_DEFINITION_RULES_SUB_PATH = "indexRules/dam:Asset/properties";
    protected static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "oak-index-definition-reader");
    protected String oakIndexName = "damAssetLucene";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public final List<String> getFastProperties() {
        return this.getFastProperties(Collections.EMPTY_LIST);
    }

    @Override
    public final List<String> getFastProperties(String indexConfigFlagPropertyName) {
        return this.getFastProperties(Arrays.asList(indexConfigFlagPropertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getFastProperties(List<String> indexConfigFlagPropertyNames) {
        TreeSet<String> fastProperties = new TreeSet<String>();
        try (ResourceResolver resourceResolver = null;){
            String[] indexDefinitionRulesPaths;
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
            String resolvedOakIndexName = (String)StringUtils.defaultIfBlank((CharSequence)OakIndexResolver.resolveRankingOakIndex(resourceResolver, this.oakIndexName), (CharSequence)this.oakIndexName);
            for (String indexDefinitionRulesPath : indexDefinitionRulesPaths = new String[]{"/oak:index/" + resolvedOakIndexName + "/" + INDEX_DEFINITION_RULES_SUB_PATH}) {
                Resource damAssetIndexRulesResource = resourceResolver.getResource(indexDefinitionRulesPath);
                if (damAssetIndexRulesResource == null) {
                    log.warn("Could not locate Oak Index Definition Index Rules for dam:Asset at [ {} ]", (Object)indexDefinitionRulesPath);
                    continue;
                }
                Iterator indexRules = damAssetIndexRulesResource.listChildren();
                while (indexRules.hasNext()) {
                    Resource indexRule = (Resource)indexRules.next();
                    ValueMap properties = indexRule.getValueMap();
                    String relPath = StringUtils.stripToNull((String)((String)properties.get(PN_NAME, String.class)));
                    if (relPath == null || indexConfigFlagPropertyNames != null && !indexConfigFlagPropertyNames.isEmpty() && !indexConfigFlagPropertyNames.stream().allMatch(propertyName -> (Boolean)properties.get(propertyName, (Object)false))) continue;
                    fastProperties.add(relPath);
                }
            }
        }
        return new ArrayList<String>(fastProperties);
    }

    @Override
    public List<String> getDeltaProperties(Collection<String> fastProperties, Collection<String> otherProperties) {
        ArrayList<String> delta = new ArrayList<String>();
        for (String fastProperty : fastProperties) {
            boolean found = false;
            for (String otherProperty : otherProperties) {
                if (!StringUtils.equals((CharSequence)StringUtils.removeStart((String)fastProperty, (String)"./"), (CharSequence)StringUtils.removeStart((String)otherProperty, (String)"./"))) continue;
                found = true;
                break;
            }
            if (found) continue;
            delta.add(fastProperty);
        }
        return delta;
    }

    @Override
    public String getFastLabel(String label) {
        return "\u26a1  " + label;
    }

    @Override
    public String getSlowLabel(String label) {
        return "\ud83d\udc22  " + label;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.oakIndexName = cfg.oakIndexName();
    }

    @ObjectClassDefinition(name="Asset Share Commons - Fast Properties")
    public static @interface Cfg {
        @AttributeDefinition(name="Oak Index Definition (Root) Name", description="The 'root' name of the index definitions rules paths to inspect to determine fast properties. These must be readable by the oak-index-definition-reader service user. Defaults to [ damAssetLucene ].")
        public String oakIndexName() default "damAssetLucene";
    }
}

