/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.aem.commons.assetshare.util.ModelCache;
import com.adobe.aem.commons.assetshare.util.impl.AbstractHTLMap;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ModelCache.class})
public class ModelCacheImpl
extends AbstractHTLMap
implements ModelCache {
    private static final Logger log = LoggerFactory.getLogger(ModelCacheImpl.class);
    private static String REQUEST_ATTRIBUTE_KEY_PREFIX = "asset-share-commons__request_models_cache__";
    @Self
    private SlingHttpServletRequest request;
    @OSGiService
    private ModelFactory modelFactory;
    @OSGiService
    private DynamicClassLoaderManager dynamicClassLoaderManager;

    @Override
    public final Object get(Object key) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("The argument must be a String object");
        }
        Class<?> clazz = null;
        try {
            clazz = this.dynamicClassLoaderManager.getDynamicClassLoader().loadClass((String)key);
            return this.get(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to derive a class from " + (String)key);
        }
    }

    @Override
    public final <T> T get(Class<T> clazz) {
        String requestAttributeKey = this.getRequestAttributeKey(clazz);
        Object cachedModel = this.request.getAttribute(requestAttributeKey);
        if (cachedModel == null) {
            Object model = this.request.adaptTo(clazz);
            if (model != null) {
                this.request.setAttribute(requestAttributeKey, model);
                if (log.isTraceEnabled()) {
                    log.trace("Initial caching of model [ {} ]", (Object)clazz.getName());
                }
                return (T)model;
            }
            if (log.isDebugEnabled()) {
                log.debug("Could not create a model to cache for [ {} ] from the SlingHttpServletRequest", (Object)clazz.getName());
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Served model for [ {} ] from cache", (Object)clazz.getName());
        }
        return (T)cachedModel;
    }

    private String getRequestAttributeKey(Class clazz) {
        return REQUEST_ATTRIBUTE_KEY_PREFIX + clazz.getName();
    }
}

