/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl.proxies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class RequestPathInfoWrapper
implements InvocationHandler {
    private final RequestPathInfo wrappedRequestPathInfo;
    private final ValueMap requestPathInfoOverrides;
    private final Resource resource;

    private RequestPathInfoWrapper(RequestPathInfo requestPathInfo, ValueMap requestPathInfoOverrides, Resource resource) {
        this.wrappedRequestPathInfo = requestPathInfo;
        this.requestPathInfoOverrides = requestPathInfoOverrides;
        this.resource = resource;
    }

    public static RequestPathInfoWrapper createRequestPathInfoWrapper(RequestPathInfo requestPathInfo, ValueMap overrides, Resource resource) {
        return new RequestPathInfoWrapper(requestPathInfo, overrides, resource);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getResourcePath": {
                return this.getResourcePath();
            }
            case "getExtension": {
                return this.getExtension();
            }
            case "getSelectorString": {
                return this.getSelectorString();
            }
            case "getSelectors": {
                return this.getSelectors();
            }
            case "getSuffix": {
                return this.getSuffix();
            }
            case "getSuffixResource": {
                return this.getSuffixResource();
            }
        }
        throw new UnsupportedOperationException("REQUESTPATHINFOWRAPPER >> NO IMPLEMENTATION FOR " + methodName);
    }

    public String getResourcePath() {
        return this.resource.getPath();
    }

    public String getExtension() {
        if (this.requestPathInfoOverrides.containsKey((Object)"extension")) {
            return (String)this.requestPathInfoOverrides.get("extension", String.class);
        }
        return this.wrappedRequestPathInfo.getExtension();
    }

    public String getSelectorString() {
        if (this.requestPathInfoOverrides.containsKey((Object)"selectors")) {
            return StringUtils.join((Object[])this.getSelectors(), (String)".");
        }
        return this.wrappedRequestPathInfo.getSelectorString();
    }

    public String[] getSelectors() {
        if (this.requestPathInfoOverrides.containsKey((Object)"selectors")) {
            return (String[])this.requestPathInfoOverrides.get("selectors", String[].class);
        }
        return this.wrappedRequestPathInfo.getSelectors();
    }

    public String getSuffix() {
        if (this.requestPathInfoOverrides.containsKey((Object)"suffix")) {
            return (String)this.requestPathInfoOverrides.get("suffix", String.class);
        }
        return this.wrappedRequestPathInfo.getSuffix();
    }

    public Resource getSuffixResource() {
        if (this.requestPathInfoOverrides.containsKey((Object)"suffix")) {
            return this.resource.getResourceResolver().getResource(this.getSuffix());
        }
        return this.wrappedRequestPathInfo.getSuffixResource();
    }
}

