/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.downloads.impl;

import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadEntry;
import com.adobe.cq.dam.download.api.DownloadProgress;
import com.day.cq.dam.commons.util.UIHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import org.apache.sling.api.SlingHttpServletRequest;

public class PlaceholderDownloadEntry
implements DownloadEntry {
    private final SlingHttpServletRequest request;
    private final String id;
    private final int numSuccesses;
    private final int numFailures;
    private DownloadProgress.Status status;

    public PlaceholderDownloadEntry(SlingHttpServletRequest request, String id, DownloadProgress.Status status, int totalFiles) {
        this.id = id;
        this.status = status;
        this.request = request;
        if (DownloadProgress.Status.SUCCESSFUL.equals((Object)status)) {
            this.numSuccesses = totalFiles;
            this.numFailures = 0;
        } else if (DownloadProgress.Status.FAILED.equals((Object)status)) {
            this.numSuccesses = 0;
            this.numFailures = totalFiles;
        } else if (DownloadProgress.Status.PARTIALLY_SUCCESSFUL.equals((Object)status)) {
            this.numSuccesses = totalFiles / 2;
            this.numFailures = totalFiles - this.numSuccesses;
        } else if (DownloadProgress.Status.PROCESSING.equals((Object)status)) {
            this.numSuccesses = 0;
            this.numFailures = 0;
        } else {
            this.numSuccesses = 0;
            this.numFailures = 0;
        }
    }

    @Override
    public String getId() {
        return "0000-0000-0000-" + String.valueOf(this.id);
    }

    @Override
    public DownloadProgress.Status getStatus() {
        return this.status;
    }

    @Override
    public int getTotalCount() {
        return this.getSuccessCount() + this.getFailureCount();
    }

    @Override
    public long getTotalSize() {
        if (DownloadProgress.Status.SUCCESSFUL.equals((Object)this.status) || DownloadProgress.Status.PARTIALLY_SUCCESSFUL.equals((Object)this.status)) {
            return 314159265L;
        }
        return 0L;
    }

    @Override
    public String getFormattedTotalSize() {
        return UIHelper.getSizeLabel((double)this.getTotalSize(), (SlingHttpServletRequest)this.request);
    }

    @Override
    public int getProcessedCount() {
        return this.getSuccessCount() + this.getFailureCount();
    }

    @Override
    public int getProgress() {
        if (DownloadProgress.Status.PROCESSING.equals((Object)this.status)) {
            return 83;
        }
        return 100;
    }

    @Override
    public String getName() {
        return "Placeholder download " + this.id + ".zip";
    }

    @Override
    public int getFailureCount() {
        return this.getFailures().size();
    }

    @Override
    public int getSuccessCount() {
        return this.getSuccesses().size();
    }

    @Override
    public boolean isComplete() {
        return !DownloadProgress.Status.PROCESSING.equals((Object)this.status);
    }

    @Override
    public Calendar getStarted() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        return calendar;
    }

    @Override
    public Calendar getFinished() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -1);
        return calendar;
    }

    @Override
    public String getURI() {
        return URI.create(String.format("/content/dam.downloadbinaries.json?downloadId=%s&artifactId=%s", String.valueOf(this.id), this.getId())).toString();
    }

    @Override
    public Collection<String> getSuccesses() {
        ArrayList<String> successes = new ArrayList<String>();
        for (int i = 0; i < this.numSuccesses; ++i) {
            successes.add(String.format("Successful asset #%s (rendition-name).jpeg", String.valueOf(i)));
        }
        return successes;
    }

    @Override
    public Collection<String> getFailures() {
        ArrayList<String> failures = new ArrayList<String>();
        for (int i = 0; i < this.numFailures; ++i) {
            failures.add(String.format("Failed asset #%s (rendition-name)", String.valueOf(i)));
        }
        return failures;
    }
}

