/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.async.impl;

import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadEntry;
import com.adobe.cq.dam.download.api.DownloadArtifact;
import com.adobe.cq.dam.download.api.DownloadProgress;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.apache.sling.api.SlingHttpServletRequest;

public class DownloadEntryImpl
implements DownloadEntry {
    private final String id;
    private final DownloadProgress downloadProgress;
    private final DownloadArtifact downloadArtifact;
    private final SlingHttpServletRequest request;

    public DownloadEntryImpl(SlingHttpServletRequest request, String id, DownloadProgress downloadProgress) {
        this.request = request;
        this.id = id;
        this.downloadProgress = downloadProgress;
        this.downloadArtifact = downloadProgress.getArtifacts().iterator().hasNext() ? (DownloadArtifact)downloadProgress.getArtifacts().iterator().next() : null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getStarted() {
        return this.downloadProgress.getStarted();
    }

    @Override
    public Calendar getFinished() {
        return this.downloadProgress.getFinished();
    }

    @Override
    public DownloadProgress.Status getStatus() {
        return this.downloadProgress.getStatus();
    }

    @Override
    public int getProcessedCount() {
        return this.downloadProgress.getProcessedCount();
    }

    @Override
    public int getSuccessCount() {
        return this.downloadProgress.getSuccessCount();
    }

    @Override
    public int getFailureCount() {
        return this.downloadProgress.getFailureCount();
    }

    @Override
    public int getTotalCount() {
        return this.downloadProgress.getTotalCount();
    }

    @Override
    public long getTotalSize() {
        return this.downloadProgress.getTotalSize();
    }

    @Override
    public String getFormattedTotalSize() {
        return UIHelper.getSizeLabel((double)this.getTotalSize(), (SlingHttpServletRequest)this.request);
    }

    @Override
    public boolean isComplete() {
        return this.downloadProgress.isComplete();
    }

    @Override
    public int getProgress() {
        return this.downloadProgress.getProgress();
    }

    @Override
    public String getName() {
        if (this.downloadArtifact != null) {
            return this.downloadArtifact.getName();
        }
        return null;
    }

    @Override
    public Collection<String> getSuccesses() {
        if (this.downloadArtifact != null) {
            return this.downloadArtifact.getSuccesses();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getFailures() {
        if (this.downloadArtifact != null) {
            return this.downloadArtifact.getFailures().keySet();
        }
        return Collections.emptyList();
    }

    @Override
    public String getURI() {
        if (this.downloadArtifact != null && this.downloadArtifact.getBinaryURI() != null) {
            return this.downloadArtifact.getBinaryURI().toString();
        }
        return null;
    }

    @Override
    public boolean isArchive() {
        return this.getSuccessCount() + this.getFailureCount() > 0;
    }
}

