/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.async.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadArchiveNamer;
import com.adobe.aem.commons.assetshare.content.renditions.download.async.DownloadTargetParameters;
import com.adobe.cq.dam.download.api.DownloadApiFactory;
import com.adobe.cq.dam.download.api.DownloadException;
import com.adobe.cq.dam.download.api.DownloadFile;
import com.adobe.cq.dam.download.api.DownloadTarget;
import com.adobe.cq.dam.download.spi.DownloadTargetProcessor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class NamedRenditionDownloadTargetProcessor
implements DownloadTargetProcessor {
    private static final Logger log = LoggerFactory.getLogger(NamedRenditionDownloadTargetProcessor.class);
    public static final String TARGET_TYPE = "asset-share-commons__named-rendition";
    public static final String PARAM_ASSET_PATH = "path";
    public static final String PARAM_RENDITION_NAME = "renditionName";
    public static final String PARAM_ARCHIVE_NAME = "archiveName";
    public static final String PARAM_ARCHIVE_PATH = "archivePath";
    public static final String PARAM_DOWNLOAD_COMPONENT_PATH = "downloadComponentPath";
    public static final String PARAM_USER_ID = "userId";
    @Reference
    private transient AssetRenditionDispatchers assetRenditionDispatchers;
    @Reference
    private DownloadApiFactory apiFactory;
    @Reference
    private MimeTypeService mimeTypeService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private volatile DownloadArchiveNamer downloadArchiveNamer;

    public Collection<DownloadFile> processTarget(DownloadTarget target, ResourceResolver resourceResolver) throws DownloadException {
        ArrayList<DownloadFile> downloadFiles = new ArrayList<DownloadFile>();
        String path = (String)target.getParameter(DownloadTargetParameters.ASSET_PATH.toString(), String.class);
        String renditionName = (String)target.getParameter(DownloadTargetParameters.RENDITION_NAME.toString(), String.class);
        String archiveName = (String)target.getParameter(DownloadTargetParameters.ARCHIVE_NAME.toString(), String.class);
        String userId = (String)target.getParameter(DownloadTargetParameters.USER_ID.toString(), String.class);
        Resource resource = resourceResolver.getResource(path);
        AssetModel assetModel = (AssetModel)resource.adaptTo(AssetModel.class);
        AssetRenditionParameters assetRenditionParameters = new AssetRenditionParameters(assetModel, renditionName);
        assetRenditionParameters.setOtherProperty(PARAM_USER_ID, (Object)userId);
        for (AssetRenditionDispatcher assetRenditionDispatcher : this.assetRenditionDispatchers.getAssetRenditionDispatchers()) {
            if (assetRenditionDispatcher.accepts(assetModel, renditionName)) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting DownloadTarget for [ {} ] using AssetRenditionDispatcher [ {} ]", (Object)assetModel.getPath(), (Object)assetRenditionDispatcher.getName());
                }
                AssetRendition assetRendition = assetRenditionDispatcher.getRendition(assetModel, assetRenditionParameters);
                HashMap<String, String> downloadFileParameters = new HashMap<String, String>();
                downloadFileParameters.put(PARAM_ARCHIVE_NAME, archiveName);
                if (assetRendition != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Obtained AssetRendition [ {} ] details for [ {} ]", (Object)assetRendition.getBinaryUri(), (Object)assetModel.getPath());
                    }
                    downloadFileParameters.put(PARAM_ARCHIVE_PATH, this.downloadArchiveNamer.getArchiveFilePath(assetModel, assetRendition, target));
                    downloadFiles.add(this.apiFactory.createDownloadFile(assetRendition.getSize(), assetRendition.getBinaryUri(), downloadFileParameters));
                    break;
                }
                downloadFileParameters.put(PARAM_ARCHIVE_PATH, this.downloadArchiveNamer.getArchiveFilePath(assetModel, AssetRendition.UNAVAILABLE_ASSET_RENDITION, target));
                downloadFiles.add(this.apiFactory.createDownloadFile(Optional.of(0L), URI.create("failed://to.resolve.asset.rendition.combination"), downloadFileParameters));
                if (!log.isDebugEnabled()) break;
                log.debug("Unable to obtain AssetRendition details for [ {} ] from AssetDispatcher [ {} ]", (Object)assetModel.getPath(), (Object)assetRenditionDispatcher.getClass().getName());
                break;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("assetRenditionDispatcher [ {} ] does not accept AssetModel [ {} ] and renditionName [ {} ]", new Object[]{assetRenditionDispatcher.getClass().getName(), assetModel.getPath(), renditionName});
        }
        return downloadFiles;
    }

    public String getTargetType() {
        return TARGET_TYPE;
    }

    public Map<String, Boolean> getValidParameters() {
        HashMap<String, Boolean> validParameters = new HashMap<String, Boolean>();
        validParameters.put(PARAM_ASSET_PATH, true);
        validParameters.put(PARAM_RENDITION_NAME, true);
        validParameters.put(PARAM_ARCHIVE_NAME, true);
        validParameters.put(PARAM_ARCHIVE_PATH, false);
        validParameters.put(PARAM_DOWNLOAD_COMPONENT_PATH, true);
        validParameters.put(PARAM_USER_ID, true);
        return validParameters;
    }
}

