/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.share.impl;

import com.adobe.aem.commons.assetshare.components.actions.share.ShareException;
import com.adobe.aem.commons.assetshare.components.actions.share.ShareService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=asset-share-commons/actions/share", "sling.servlet.selectors=share", "sling.servlet.extensions=html", "sling.servlet.extensions=json"})
public class ShareServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ShareServlet.class);
    @Reference(target="(component.name=com.adobe.aem.commons.assetshare.components.actions.share.impl.EmailShareServiceImpl)")
    private transient ShareService defaultShareService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private volatile transient Collection<ShareService> volatileShareServices;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            this.share(request, response);
        }
        catch (RepositoryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private final void share(SlingHttpServletRequest request, SlingHttpServletResponse response) throws RepositoryException {
        AtomicInteger counter = new AtomicInteger(0);
        Collection<ShareService> shareServices = this.volatileShareServices;
        shareServices.stream().filter(Objects::nonNull).filter(shareService -> shareService.accepts(request)).forEach(shareService -> {
            block2: {
                try {
                    shareService.share(request, response, (ValueMap)new ValueMapDecorator(new HashMap(request.getParameterMap())));
                    counter.incrementAndGet();
                }
                catch (ShareException e) {
                    if (!log.isErrorEnabled()) break block2;
                    log.error("Failed to not share assets using [ {} ]", (Object)shareService.getClass().getName(), (Object)e);
                }
            }
        });
        try {
            if (counter.get() == 0) {
                this.defaultShareService.share(request, response, (ValueMap)new ValueMapDecorator(new HashMap(request.getParameterMap())));
            }
        }
        catch (ShareException ex) {
            log.error("Unable to share assets from Asset Share Commons", (Throwable)ex);
            response.setStatus(500);
        }
    }
}

