/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.adobe.aem.commons.assetshare.util.MimeTypeHelper;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class ThumbnailImpl
extends AbstractComputedProperty<String> {
    public static final String LABEL = "Thumbnail Rendition";
    public static final String NAME = "thumbnail";
    private static final String THUMBNAIL_RENDITION_NAME = "cq5dam.thumbnail.319.319.png";
    private Cfg cfg;
    @Reference
    private MimeTypeHelper mimeTypeHelper;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public boolean accepts(Asset asset, String propertyName) {
        return true;
    }

    @Override
    public String get(Asset asset) {
        Rendition rendition = asset.getRendition(THUMBNAIL_RENDITION_NAME);
        if (rendition == null && asset.getImagePreviewRendition() != null) {
            rendition = asset.getImagePreviewRendition();
        }
        if (rendition != null && this.mimeTypeHelper.isBrowserSupportedImage(rendition.getMimeType())) {
            return UrlUtil.escape(rendition.getPath());
        }
        return "";
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Thumbnail Rendition")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Thumbnail Rendition";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"rendition", "video-rendition"};
    }
}

