/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.assetkit.impl.componentupdaters;

import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.adobe.aem.commons.assetshare.util.assetkit.ComponentUpdater;
import com.day.cq.wcm.api.Page;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component
@Designate(ocd=Config.class)
public class AssetKitComponentUpdaterImpl
implements ComponentUpdater {
    private static String PROPERTY_NAME = "paths";
    @Reference
    private transient AssetKitHelper assetKitHelper;
    private Config config;

    @Override
    public String getName() {
        return "Asset kit component (Asset Share Commons)";
    }

    @Override
    public void updateComponent(Page assetKitPage, Resource assetKit) throws PersistenceException, RepositoryException {
        this.assetKitHelper.updateComponentOnPage(assetKitPage, this.config.resource_type(), PROPERTY_NAME, assetKit.getPath());
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.config = config;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Kit Component Updater", description="Component updater that updates an Asset Kit component")
    static @interface Config {
        @AttributeDefinition(name="Resource Type", description="The resource type of the component to update.")
        public String resource_type() default "asset-share-commons/components/asset-kit";
    }
}

