/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.FulltextPredicate;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.Text;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={FulltextPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/search-bar"})
@Exporter(name="jackson", extensions={"json"})
public class FulltextPredicateImpl
extends AbstractPredicate
implements FulltextPredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/search-bar";
    private static final String FORM_FIELD_TYPE = "text";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private Text coreText;
    @ValueMapValue(name="aiSearch")
    @Default(booleanValues={false})
    private boolean aiSearch;

    @PostConstruct
    protected void init() {
        this.initPredicate(this.request, (Field)this.coreText);
    }

    public boolean isRequired() {
        return this.coreText.isRequired();
    }

    public String getRequiredMessage() {
        return this.coreText.getRequiredMessage();
    }

    public String getPlaceholder() {
        return this.coreText.getPlaceholder();
    }

    public boolean isReadOnly() {
        return this.coreText.isReadOnly();
    }

    public String getConstraintMessage() {
        return this.coreText.getConstraintMessage();
    }

    public String getType() {
        return FORM_FIELD_TYPE;
    }

    public int getRows() {
        return 0;
    }

    public boolean hideTitle() {
        return this.coreText.hideTitle();
    }

    public String getName() {
        if (this.aiSearch) {
            return "ai-fulltext";
        }
        return "fulltext";
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public String getInitialValue() {
        return PredicateUtil.getParamFromQueryParams(this.request, this.getName());
    }

    @Override
    public ValueMap getInitialValues() {
        ValueMapDecorator intialValues = new ValueMapDecorator(new HashMap());
        intialValues.put((Object)this.getName(), (Object)this.getInitialValue());
        return intialValues;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

