/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class SmartTagTitlesImpl
extends AbstractComputedProperty<List<String>> {
    public static final String LABEL = "Smart Tags";
    public static final String NAME = "smartTagTitles";
    public static final String PN_SMART_TAG_NAME = "name";
    public static final String PN_SMART_TAG_CONFIDENCE = "confidence";
    public static final String REL_PATH_SMART_TAGS_RESOURCE = "jcr:content/metadata/predictedTags";
    private Cfg cfg;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public List<String> get(Asset asset, SlingHttpServletRequest request) {
        List<String> smartTagTitles = new ArrayList<String>();
        Resource smartTagsResource = this.getSmartTagsResource(asset);
        if (smartTagsResource != null) {
            smartTagTitles = this.getSmartTagsByConfidence(smartTagsResource).stream().map(r -> (String)r.getValueMap().get(PN_SMART_TAG_NAME, String.class)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        return smartTagTitles;
    }

    private Resource getSmartTagsResource(Asset asset) {
        if (asset == null) {
            return null;
        }
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        if (resource == null) {
            return null;
        }
        return resource.getChild(REL_PATH_SMART_TAGS_RESOURCE);
    }

    private Collection<Resource> getSmartTagsByConfidence(Resource smartTagsResource) {
        ArrayList<Resource> smartTagResources = new ArrayList<Resource>();
        smartTagsResource.listChildren().forEachRemaining(r -> smartTagResources.add((Resource)r));
        Collections.sort(smartTagResources, new SmartTagsConfidenceComparator());
        return smartTagResources;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    private class SmartTagsConfidenceComparator
    implements Comparator<Resource> {
        private SmartTagsConfidenceComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            Double confidence1 = (Double)o1.getValueMap().get(SmartTagTitlesImpl.PN_SMART_TAG_CONFIDENCE, (Object)0.0);
            Double confidence2 = (Double)o2.getValueMap().get(SmartTagTitlesImpl.PN_SMART_TAG_CONFIDENCE, (Object)0.0);
            return confidence1.compareTo(confidence2);
        }
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Smart Tag Titles")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Smart Tags";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};
    }
}

