/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRendition;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionTracker;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.content.renditions.download.DownloadExtensionResolver;
import com.adobe.aem.commons.assetshare.content.renditions.download.impl.AssetRenditionDownloadRequest;
import com.adobe.aem.commons.assetshare.content.renditions.impl.dispatchers.AbstractRenditionDispatcherImpl;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=-20000"})
@Designate(ocd=Cfg.class, factory=true)
public class StaticRenditionDispatcherImpl
extends AbstractRenditionDispatcherImpl
implements AssetRenditionDispatcher {
    private static final Logger log = LoggerFactory.getLogger(StaticRenditionDispatcherImpl.class);
    private static final String OSGI_PROPERTY_VALUE_DELIMITER = "=";
    private Cfg cfg;
    private ConcurrentHashMap<String, Pattern> mappings;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AssetRenditions assetRenditions;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile AssetRenditionTracker assetRenditionTracker;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile DownloadExtensionResolver downloadExtensionResolver;

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String getName() {
        return this.cfg.name();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.assetRenditions.getOptions(this.mappings);
    }

    @Override
    public boolean isHidden() {
        return this.cfg.hidden();
    }

    @Override
    public Set<String> getRenditionNames() {
        if (this.mappings == null) {
            return Collections.EMPTY_SET;
        }
        return this.mappings.keySet();
    }

    @Override
    public List<String> getTypes() {
        if (this.cfg.types() != null) {
            return Arrays.asList(this.cfg.types());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void dispatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        AssetRenditionParameters parameters;
        Asset asset = DamUtil.resolveToAsset((Resource)request.getResource());
        Rendition rendition = this.findRendition(asset, parameters = new AssetRenditionParameters(request));
        if (rendition != null) {
            if (log.isDebugEnabled()) {
                log.debug("Serving internal static rendition [ {} ] with resolved rendition name [ {} ] through internal Sling Forward", (Object)rendition.getPath(), (Object)parameters.getRenditionName());
            }
            if (this.assetRenditionTracker != null) {
                this.assetRenditionTracker.track((AssetRenditionDispatcher)this, request, parameters, rendition.getPath());
            }
        } else {
            throw new ServletException(String.format("Cloud not locate rendition [ %s ] for assets [ %s ]", parameters.getRenditionName(), asset.getPath()));
        }
        response.setHeader("Content-Type", rendition.getMimeType());
        request.getRequestDispatcher((Resource)rendition.adaptTo(Resource.class)).include((ServletRequest)new AssetRenditionDownloadRequest(request, "GET", (Resource)rendition.adaptTo(Resource.class), new String[0], null, ""), (ServletResponse)response);
    }

    @Override
    public AssetRendition getRendition(AssetModel assetModel, AssetRenditionParameters parameters) {
        Rendition rendition = this.findRendition(assetModel.getAsset(), parameters);
        if (rendition == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Downloading asset rendition [ {} ] for resolved rendition name [ {} ]", (Object)rendition.getPath(), (Object)parameters.getRenditionName());
        }
        if (this.assetRenditionTracker != null && ((Boolean)parameters.getOtherProperties().get("track", (Object)true)).booleanValue()) {
            this.assetRenditionTracker.track((AssetRenditionDispatcher)this, assetModel, parameters, rendition.getPath());
        }
        return new AssetRendition(rendition.getPath(), (Long)rendition.getSize(), rendition.getMimeType());
    }

    @Override
    public ValueMap getRenditionDetails(AssetModel assetModel, AssetRenditionParameters parameters) {
        parameters.setOtherProperty("track", false);
        AssetRendition assetRendition = this.getRendition(assetModel, parameters);
        parameters.setOtherProperty("track", null);
        ValueMapDecorator details = new ValueMapDecorator(new HashMap());
        details.put((Object)"size-in-bytes", assetRendition.getSize());
        details.put((Object)"mime-type", (Object)assetRendition.getMimeType());
        String extension = null;
        if (this.downloadExtensionResolver != null) {
            extension = this.downloadExtensionResolver.resolve(assetModel, assetRendition);
        } else {
            Rendition rendition = this.findRendition(assetModel.getAsset(), parameters);
            String staticRenditionName = rendition.getName();
            if ("original".equalsIgnoreCase(rendition.getName())) {
                staticRenditionName = assetModel.getName();
            }
            extension = StringUtils.substringAfterLast((String)staticRenditionName, (String)".");
        }
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            details.put((Object)"extension", (Object)extension);
        }
        return details;
    }

    @Override
    public boolean accepts(AssetModel assetModel, String renditionName) {
        return this.getRenditionNames().contains(renditionName);
    }

    private Rendition findRendition(Asset asset, AssetRenditionParameters parameters) {
        return asset.getRendition((RenditionPicker)new PatternRenditionPicker(this.mappings.get(parameters.getRenditionName())));
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
        this.mappings = super.parseMappingsAsPatterns(cfg.rendition_mappings());
    }

    protected class PatternRenditionPicker
    implements RenditionPicker {
        private final Pattern pattern;

        public PatternRenditionPicker(Pattern pattern) {
            this.pattern = pattern;
        }

        public Rendition getRendition(Asset asset) {
            if (this.pattern == null) {
                return null;
            }
            return asset.getRenditions().stream().filter(r -> this.pattern.matcher(r.getName()).matches()).findFirst().orElse(null);
        }
    }

    @ObjectClassDefinition(name="Asset Share Commons - Rendition Dispatcher - Static Renditions")
    public static @interface Cfg {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{name} [ {label} ] @ {service.ranking}";

        @AttributeDefinition(name="Name", description="The system name of this Rendition Dispatcher. This should be unique across all AssetRenditionDispatcher instances.")
        public String name() default "static";

        @AttributeDefinition(name="Label", description="The human-friendly name of this AssetRenditionDispatcher and may be displayed to authors.")
        public String label() default "Static Renditions";

        @AttributeDefinition(name="Rendition types", description="The types of renditions this configuration will return. Ideally all renditions in this configuration apply types specified here. This is used to drive and scope the Asset Renditions displays in Authoring datasources. OOTB types are: `image` and `video`")
        public String[] types() default {};

        @AttributeDefinition(name="Hide renditions", description="Hide if this AssetRenditionDispatcher configuration is not intended to be exposed to AEM authors for selection in dialogs.", type=AttributeType.BOOLEAN)
        public boolean hidden() default false;

        @AttributeDefinition(name="Static rendition mappings", description="In the form: <renditionName>=<renditionPickerPattern>")
        public String[] rendition_mappings() default {};

        @AttributeDefinition(name="Service ranking", description="The larger the number, the higher the precedence.", type=AttributeType.INTEGER)
        public int service_ranking() default 0;
    }
}

