/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl.datasources;

import com.adobe.aem.commons.assetshare.content.MetadataProperties;
import com.adobe.aem.commons.assetshare.search.FastProperties;
import com.adobe.aem.commons.assetshare.util.DataSourceBuilder;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=asset-share-commons/data-sources/orderable-properties", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class OrderablePropertiesDataSource
extends SlingSafeMethodsServlet {
    private static final String PN_ORDERED = "ordered";
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;
    @Reference
    private transient FastProperties fastPropertiesService;
    @Reference
    private transient MetadataProperties metadataProperties;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        Map<String, List<String>> collectedMetadata = this.metadataProperties.getMetadataProperties(request);
        List<String> fastProperties = this.fastPropertiesService.getFastProperties(PN_ORDERED);
        data.put(this.fastPropertiesService.getFastLabel("Search Relevancy (jcr:score)"), "@jcr:score");
        for (String fastProperty : fastProperties) {
            String value = "@" + fastProperty;
            if (collectedMetadata.keySet().contains("./" + fastProperty)) {
                List<String> labels = collectedMetadata.get("./" + fastProperty);
                String label = StringUtils.join(labels, (String)" / ") + " (" + fastProperty + " )";
                data.put(this.fastPropertiesService.getFastLabel(label), value);
                continue;
            }
            data.put(this.fastPropertiesService.getFastLabel(fastProperty), value);
        }
        this.dataSourceBuilder.build(request, data);
    }
}

