/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl.predicateevaluators;

import com.adobe.aem.commons.assetshare.search.impl.predicateevaluators.AiSearchRenderCondition;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.day.cq.search.Predicate;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.FulltextPredicateEvaluator;
import com.day.cq.search.eval.PredicateEvaluator;
import com.day.cq.search.facets.FacetExtractor;
import java.util.Comparator;
import javax.jcr.query.Row;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PredicateEvaluator.class}, factory="com.day.cq.search.eval.PredicateEvaluator/ai-fulltext")
public class AiFulltextPredicateEvaluator
implements PredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(AiFulltextPredicateEvaluator.class);
    @Reference(target="(distribution=cloud-ready)")
    RequireAem requireAem;
    private static final String AI_SEARCH_TOKEN = System.getProperty("com.adobe.granite.omnisearch.inference.query.prefix", "?{}?");
    public static final String PREDICATE_NAME = "ai-fulltext";
    protected static final String PREDICATE_BUILT_KEY = "__asset-share-commons--predicate-built";
    protected static final String PREDICATE_BUILT_VALUE = "true";
    private PredicateEvaluator fulltextEvaluator = new FulltextPredicateEvaluator();

    protected Predicate buildPredicate(Predicate predicate) {
        if (PREDICATE_BUILT_VALUE.equals(predicate.get(PREDICATE_BUILT_KEY))) {
            return predicate;
        }
        String value = predicate.get(PREDICATE_NAME, "");
        if (AiSearchRenderCondition.isAiSearchEnabled() && !StringUtils.isBlank((CharSequence)value)) {
            value = AI_SEARCH_TOKEN.concat(value);
        }
        predicate.set("fulltext", value);
        predicate.set(PREDICATE_NAME, null);
        predicate.set(PREDICATE_BUILT_KEY, PREDICATE_BUILT_VALUE);
        return predicate;
    }

    protected PredicateEvaluator getPredicateEvaluator(Predicate predicate) {
        return this.fulltextEvaluator;
    }

    public String getXPathExpression(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getXPathExpression(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean includes(Predicate predicate, Row row, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).includes(this.buildPredicate(predicate), row, evaluationContext);
    }

    public boolean canXpath(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).canXpath(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean canFilter(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).canFilter(this.buildPredicate(predicate), evaluationContext);
    }

    public boolean isFiltering(Predicate predicate, EvaluationContext evaluationContext) {
        throw new UnsupportedOperationException("isFiltering(..) is deprecated.");
    }

    public String[] getOrderByProperties(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getOrderByProperties(this.buildPredicate(predicate), evaluationContext);
    }

    public Comparator<Row> getOrderByComparator(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getOrderByComparator(this.buildPredicate(predicate), evaluationContext);
    }

    public FacetExtractor getFacetExtractor(Predicate predicate, EvaluationContext evaluationContext) {
        return this.getPredicateEvaluator(predicate).getFacetExtractor(this.buildPredicate(predicate), evaluationContext);
    }
}

