/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.workflow.assetkit.impl;

import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.adobe.aem.commons.assetshare.util.assetkit.ComponentUpdater;
import com.adobe.aem.commons.assetshare.util.assetkit.PagePathGenerator;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.QueryBuilder;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WorkflowProcess.class}, property={"process.label=Asset kit creator"})
public class AssetKitCreatorWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AssetKitCreatorWorkflowProcess.class);
    private static final String TRACKING_PROPERTY_ASSETS_KIT_ID = "assetsKitId";
    private static final String WORKFLOW_ASSETS_KIT_PAGE_COMPONENT_UPDATERS = "COMPONENT_UPDATER_IDS";
    private static final String WORKFLOW_ASSETS_KIT_PAGE_TEMPLATE_PATH = "ASSETS_KIT_PAGE_TEMPLATE_PATH";
    private static final String WORKFLOW_ROOT_PAGE_PATH = "ROOT_PAGE_PATH";
    public static final String WORKFLOW_ASSETS_KIT_PAGE_ID = "ASSETS_KIT_PAGE_ID";
    public static final String WORKFLOW_ASSETS_KIT_PATH = "ASSETS_KIT_PATH";
    public static final String WORKFLOW_TRACK_AND_UPDATE = "TRACK_AND_UPDATE";
    public static final String WORKFLOW_PAGE_PATH_GENERATOR_ID = "PAGE_PATH_GENERATOR_ID";
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient AssetKitHelper assetKitHelper;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    private transient Collection<ComponentUpdater> componentUpdaters;
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    private transient Collection<PagePathGenerator> pagePathGenerators;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String payload;
        ResourceResolver resourceResolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Resource payloadResource = resourceResolver.getResource(payload = workItem.getWorkflowData().getPayload().toString());
        if (payloadResource == null) {
            throw new WorkflowException(String.format("Payload [ %s ] is not a resource.", payload));
        }
        if (!this.assetKitHelper.isAssetFolder(payloadResource) && !this.assetKitHelper.isAssetCollection(payloadResource)) {
            throw new WorkflowException(String.format("Payload [ %s ] is not a valid DAM asset folder or collection.", payload));
        }
        boolean trackAndUpdate = (Boolean)metaDataMap.get(WORKFLOW_TRACK_AND_UPDATE, (Object)false);
        String templatePath = (String)metaDataMap.get(WORKFLOW_ASSETS_KIT_PAGE_TEMPLATE_PATH, String.class);
        String rootPagePath = (String)metaDataMap.get(WORKFLOW_ROOT_PAGE_PATH, (Object)"/content/asset-kits");
        String pagePathGeneratorId = (String)metaDataMap.get(WORKFLOW_PAGE_PATH_GENERATOR_ID, String.class);
        String[] componentUpdaterIds = (String[])metaDataMap.get(WORKFLOW_ASSETS_KIT_PAGE_COMPONENT_UPDATERS, String[].class);
        Resource trackingResource = this.getOrCreateTrackingResource(payloadResource);
        String assetsKitId = this.pagePathGenerators.stream().filter(pagePathGenerator -> StringUtils.equals((CharSequence)pagePathGeneratorId, (CharSequence)pagePathGenerator.getId())).findFirst().orElseThrow(() -> new WorkflowException(String.format("No PagePathGenerator found for ID [ %s ]", pagePathGeneratorId))).generatePagePath(rootPagePath, payloadResource);
        if (trackAndUpdate) {
            assetsKitId = (String)trackingResource.getValueMap().get(TRACKING_PROPERTY_ASSETS_KIT_ID, (Object)assetsKitId);
        }
        try {
            Page page = this.getOrCreateAssetsKitPage(resourceResolver, assetsKitId, templatePath, assetsKitId);
            ((ModifiableValueMap)trackingResource.adaptTo(ModifiableValueMap.class)).put((Object)TRACKING_PROPERTY_ASSETS_KIT_ID, (Object)page.getPath());
            for (String componentUpdaterId : componentUpdaterIds) {
                for (ComponentUpdater componentUpdater : this.componentUpdaters) {
                    if (!StringUtils.equals((CharSequence)componentUpdaterId, (CharSequence)componentUpdater.getId())) continue;
                    componentUpdater.updateComponent(page, payloadResource);
                }
            }
            resourceResolver.commit();
            this.persistData(workItem, workflowSession, WORKFLOW_ASSETS_KIT_PAGE_ID, page.getPath());
            this.persistData(workItem, workflowSession, WORKFLOW_ASSETS_KIT_PATH, payload);
        }
        catch (WCMException | RepositoryException | PersistenceException e) {
            throw new WorkflowException(String.format("Could not build Press Kit page for [ %s ]", payload), e);
        }
    }

    private Page getOrCreateAssetsKitPage(ResourceResolver resourceResolver, String assetsKitId, String templatePath, String pageTitle) throws RepositoryException, WCMException {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Page page = pageManager.getPage(assetsKitId);
        if (page != null) {
            ((ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class)).put((Object)"jcr:title", (Object)pageTitle);
        } else {
            Node node = JcrUtil.createPath((String)StringUtils.substringBeforeLast((String)assetsKitId, (String)"/"), (String)"sling:OrderedFolder", (String)"sling:OrderedFolder", (Session)((Session)resourceResolver.adaptTo(Session.class)), (boolean)false);
            page = pageManager.create(node.getPath(), StringUtils.substringAfterLast((String)assetsKitId, (String)"/"), templatePath, pageTitle, true);
        }
        return page;
    }

    private Resource getOrCreateTrackingResource(Resource resource) throws WorkflowException {
        if (this.assetKitHelper.isAssetFolder(resource)) {
            if (resource.getChild("jcr:content") != null) {
                if ((resource = resource.getChild("jcr:content")).getChild("metadata") == null) {
                    try {
                        resource = resource.getResourceResolver().create(resource, "metadata", Collections.unmodifiableMap(new HashMap<String, String>(){
                            {
                                this.put("jcr:primaryType", "nt:unstructured");
                            }
                        }));
                    }
                    catch (PersistenceException e) {
                        throw new WorkflowException(String.format("Could not create missing metadata node for asset folder [ {} ].", resource.getPath()), (Throwable)e);
                    }
                } else {
                    resource = resource.getChild("metadata");
                }
            } else {
                throw new WorkflowException(String.format("Asset folder [ %s ] does not have jcr:content node.", resource.getPath()));
            }
        }
        return resource;
    }

    private <T> boolean persistData(WorkItem workItem, WorkflowSession workflowSession, String key, T val) {
        WorkflowData data = workItem.getWorkflow().getWorkflowData();
        if (data.getMetaDataMap() == null) {
            return false;
        }
        data.getMetaDataMap().put((Object)key, val);
        workflowSession.updateWorkflowData(workItem.getWorkflow(), data);
        return true;
    }
}

