/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.share.impl;

import com.adobe.aem.commons.assetshare.components.actions.share.EmailShare;
import com.adobe.aem.commons.assetshare.components.actions.share.ShareException;
import com.adobe.aem.commons.assetshare.components.actions.share.ShareService;
import com.adobe.aem.commons.assetshare.configuration.AssetDetailsResolver;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.EmailService;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.Externalizer;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.scripting.core.ScriptHelper;
import org.apache.sling.xss.XSSAPI;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ShareService.class})
@Designate(ocd=Cfg.class)
public class EmailShareServiceImpl
implements ShareService {
    private static final Logger log = LoggerFactory.getLogger(EmailShareServiceImpl.class);
    public static final String SHARE_SERVICE_ACCEPTANCE_KEY = "asset-share-commons__share--email";
    public static final String SIGNATURE = "signature";
    private static final String ASSET_PATHS = "path";
    private static final String EMAIL_ADDRESSES = "email";
    private static final String EMAIL_ASSET_LINK_LIST_HTML = "assetLinksHTML";
    private transient Cfg cfg;
    private transient BundleContext bundleContext;
    @Reference
    private transient EmailService emailService;
    @Reference
    private transient Externalizer externalizer;
    @Reference
    private transient AssetDetailsResolver assetDetailsResolver;
    @Reference
    private transient RequireAem requireAem;
    @Reference
    private transient ModelFactory modelFactory;
    @Reference
    private transient XSSAPI xssAPI;

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        return "true".equals(request.getParameter(SHARE_SERVICE_ACCEPTANCE_KEY));
    }

    @Override
    public final void share(SlingHttpServletRequest request, SlingHttpServletResponse response, ValueMap shareParameters) throws ShareException {
        ValueMapDecorator unprotectedShareParameters = new ValueMapDecorator(new HashMap());
        unprotectedShareParameters.putAll((Map)shareParameters);
        SlingBindings bindings = new SlingBindings();
        bindings.setSling((SlingScriptHelper)new ScriptHelper(this.bundleContext, null, request, response));
        request.setAttribute(SlingBindings.class.getName(), (Object)bindings);
        UserProperties userProperties = this.getUserProperties(request);
        EmailShare emailShare = (EmailShare)request.adaptTo(EmailShare.class);
        shareParameters.putAll(this.xssProtectUserData((Map<String, Object>)emailShare.getUserData()));
        unprotectedShareParameters.putAll((Map)emailShare.getUserData());
        shareParameters.putAll((Map)emailShare.getConfiguredData());
        unprotectedShareParameters.putAll((Map)emailShare.getConfiguredData());
        shareParameters.put((Object)SIGNATURE, (Object)this.getSignature(emailShare, userProperties));
        String replyToAddress = this.getReplyToAddress(emailShare, userProperties);
        if (StringUtils.isNotEmpty((CharSequence)replyToAddress)) {
            shareParameters.put((Object)"replyTo", (Object)replyToAddress);
        }
        this.share((Config)request.adaptTo(Config.class), (ValueMap)unprotectedShareParameters, shareParameters, (String)StringUtils.defaultIfBlank((CharSequence)emailShare.getEmailTemplatePath(), (CharSequence)this.cfg.emailTemplate()));
    }

    private final void share(Config config, ValueMap unprotectedShareParameters, ValueMap shareParameters, String emailTemplatePath) throws ShareException {
        Object[] emailAddresses = StringUtils.split((String)((String)unprotectedShareParameters.get(EMAIL_ADDRESSES, (Object)"")), (String)",");
        Object[] assetPaths = (String[])Arrays.stream((Object[])unprotectedShareParameters.get(ASSET_PATHS, (Object)ArrayUtils.EMPTY_STRING_ARRAY)).filter(StringUtils::isNotBlank).map(path -> config.getResourceResolver().getResource(path)).filter(Objects::nonNull).map(DamUtil::resolveToAsset).filter(Objects::nonNull).map(Asset::getPath).toArray(String[]::new);
        if (log.isDebugEnabled()) {
            log.debug("Sharing [ {} ] to [ {} ]", (Object)StringUtils.join((Object[])((Object[])unprotectedShareParameters.get(ASSET_PATHS, (Object)ArrayUtils.EMPTY_STRING_ARRAY)), (String)", "), (Object)StringUtils.join((Object[])emailAddresses, (String)", "));
        }
        if (emailAddresses == null || emailAddresses.length == 0) {
            throw new ShareException("At least one e-mail address is required to share");
        }
        if (ArrayUtils.isEmpty((Object[])assetPaths)) {
            throw new ShareException("At least one asset is required to share");
        }
        HashMap<String, String> emailParameters = new HashMap<String, String>();
        for (String key : shareParameters.keySet()) {
            emailParameters.put(key, (String)shareParameters.get(key, String.class));
        }
        emailParameters.put(EMAIL_ASSET_LINK_LIST_HTML, this.getAssetLinkListHtml(config, (String[])assetPaths));
        List<String> failureList = this.emailService.sendEmail(emailTemplatePath, emailParameters, (String[])emailAddresses);
        if (failureList.size() > 0) {
            throw new ShareException(String.format("Unable to send share e-mail too [ %s ]", StringUtils.join((Object[])emailAddresses)));
        }
    }

    private final String getAssetLinkListHtml(Config config, String[] assetPaths) {
        StringBuilder sb = new StringBuilder();
        for (String assetPath : assetPaths) {
            Resource assetResource = config.getResourceResolver().getResource(assetPath);
            if (assetResource == null || !DamUtil.isAsset((Resource)assetResource)) continue;
            AssetModel asset = (AssetModel)this.modelFactory.getModelFromWrappedRequest(config.getRequest(), assetResource, AssetModel.class);
            String url = this.assetDetailsResolver.getFullUrl(config, asset);
            if (StringUtils.isBlank((CharSequence)url)) {
                log.warn("Could not determine an Asset Details page path for asset at [ {} ]", (Object)assetPath);
                continue;
            }
            url = Text.unescape((String)url);
            url = RequireAem.ServiceType.AUTHOR.equals((Object)this.requireAem.getServiceType()) ? this.externalizer.authorLink(config.getResourceResolver(), url) : this.externalizer.externalLink(config.getResourceResolver(), this.cfg.externalizerDomain(), url);
            sb.append("<li><a href=\"");
            sb.append(url);
            sb.append("\">");
            sb.append(asset.getTitle());
            sb.append("</a></li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private String getSignature(EmailShare emailShare, UserProperties userProperties) throws ShareException {
        boolean useSharerDisplayNameAsSignature = (Boolean)emailShare.getProperties().get("useSharerSignature", (Object)false);
        if (useSharerDisplayNameAsSignature && userProperties != null) {
            try {
                return StringUtils.trimToNull((String)userProperties.getDisplayName());
            }
            catch (RepositoryException ex) {
                throw new ShareException("Could not obtain user display name for '" + userProperties.getAuthorizableID() + "'", ex);
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)((CharSequence)emailShare.getConfiguredData().get(SIGNATURE, String.class)), (CharSequence)this.cfg.signature());
    }

    private String getReplyToAddress(EmailShare emailShare, UserProperties userProperties) throws ShareException {
        boolean replyToSharer = (Boolean)emailShare.getProperties().get("replyToSharer", (Object)false);
        if (replyToSharer && userProperties != null) {
            try {
                return userProperties.getProperty(EMAIL_ADDRESSES);
            }
            catch (RepositoryException ex) {
                throw new ShareException("Could not obtain email address for '" + userProperties.getAuthorizableID() + "'", ex);
            }
        }
        return null;
    }

    private UserProperties getUserProperties(SlingHttpServletRequest request) {
        if (!this.isValidUser(request)) {
            return null;
        }
        ResourceResolver resolver = request.getResourceResolver();
        UserPropertiesManager upm = (UserPropertiesManager)resolver.adaptTo(UserPropertiesManager.class);
        Authorizable authorizable = (Authorizable)resolver.adaptTo(Authorizable.class);
        try {
            return upm.getUserProperties(authorizable, "profile");
        }
        catch (RepositoryException ex) {
            if (log.isWarnEnabled()) {
                log.warn("Cannot get user profile properties of user '{}'", (Object)resolver.getUserID());
            }
            return null;
        }
    }

    private boolean isValidUser(SlingHttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String currentUser = request.getResourceResolver().getUserID();
        boolean anonymous = StringUtils.equalsIgnoreCase((CharSequence)currentUser, (CharSequence)"anonymous");
        boolean admin = StringUtils.equalsIgnoreCase((CharSequence)currentUser, (CharSequence)"admin");
        return !anonymous && !admin;
    }

    private Map<String, Object> xssProtectUserData(Map<String, Object> dirtyUserData) {
        HashMap<String, Object> cleanUserData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : dirtyUserData.entrySet()) {
            if (entry.getValue() instanceof String[]) {
                cleanUserData.put(entry.getKey(), this.xssCleanData((String[])entry.getValue()));
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            cleanUserData.put(entry.getKey(), this.xssCleanData((String)entry.getValue()));
        }
        return cleanUserData;
    }

    private String[] xssCleanData(String[] dirtyData) {
        ArrayList<String> cleanValues = new ArrayList<String>();
        for (String val : dirtyData) {
            cleanValues.add(this.xssAPI.encodeForHTML(val));
        }
        return cleanValues.toArray(new String[0]);
    }

    private String xssCleanData(String dirtyData) {
        return this.xssAPI.encodeForHTML(dirtyData);
    }

    @Activate
    protected final void activate(Cfg config, BundleContext bundleContext) {
        this.cfg = config;
        this.bundleContext = bundleContext;
    }

    @ObjectClassDefinition(name="Asset Share Commons - E-mail Share Service")
    public static @interface Cfg {
        @AttributeDefinition(name="Default E-mail Template", description="Absolute path to email template in the repository")
        public String emailTemplate() default "/etc/notification/email/asset-share-commons/share/default.html";

        @AttributeDefinition(name="Default Signature", description="The default value to use is no signature can be derived.")
        public String signature() default "Your Assets Team";

        @AttributeDefinition(name="Externalizer Domain", description="The externalizer domain used for creating asset links.")
        public String externalizerDomain() default "publish";
    }
}

