/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.assetkit.impl;

import com.adobe.aem.commons.assetshare.components.assetkit.AssetKit;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.adobe.cq.export.json.ComponentExporter;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={AssetKit.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/asset-kit"})
@Exporter(name="jackson", extensions={"json"})
public class AssetKitImpl
implements AssetKit {
    public static final String RESOURCE_TYPE = "asset-share-commons/components/asset-kit";
    @Self
    private SlingHttpServletRequest request;
    @ValueMapValue
    @Optional
    private Collection<String> paths;
    @OSGiService
    private AssetKitHelper assetKitHelper;
    @OSGiService
    @Optional
    private AssetKit.Filter assetsFilter;
    Collection<? extends AssetModel> assets;

    @Override
    public Collection<? extends AssetModel> getAssets() {
        if (this.assets != null) {
            return this.assets;
        }
        this.assets = this.assetKitHelper.getAssets(this.request.getResourceResolver(), this.paths.toArray(new String[0]));
        if (this.assetsFilter != null) {
            this.assets = this.assetsFilter.filter(this.assets);
        }
        return this.assets;
    }

    @Override
    public boolean isReady() {
        return this.getAssets().size() > 0;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

