/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Metadata;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.sightly.SightlyWCMMode;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Metadata.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/metadata"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class MetadataImpl
extends AbstractEmptyTextComponent
implements Metadata {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/metadata";
    protected static final String PN_TYPE = "type";
    private static final Logger log = LoggerFactory.getLogger(MetadataImpl.class);
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @ScriptVariable
    private SightlyWCMMode wcmmode;
    @ScriptVariable
    private Page currentPage;
    @ValueMapValue
    private String propertyName;
    @ValueMapValue
    private String computedProperty;
    @ValueMapValue
    private String formatDate;
    @ValueMapValue
    private String formatNumber;
    @ValueMapValue
    private Double unitConverter;
    @ValueMapValue(name="type")
    private String typeString;
    @ValueMapValue
    private String jsonSource;
    private Metadata.DataType type;
    private String locale;
    private ValueMap combinedProperties;
    private List<String> values = null;

    @PostConstruct
    public void init() {
        this.combinedProperties = this.getProperties();
    }

    @Override
    public Metadata.DataType getType() {
        this.type = Metadata.DataType.fromString(this.typeString);
        return this.type;
    }

    @Override
    public String getLocale() {
        if (this.locale == null) {
            this.locale = this.currentPage == null ? Locale.getDefault().getLanguage() : this.currentPage.getLanguage(false).getLanguage();
        }
        return this.locale;
    }

    @Override
    public String getFormat() {
        if (this.type == null) {
            this.getType();
        }
        switch (this.type) {
            case DATE: {
                return this.formatDate;
            }
            case NUMBER: {
                return this.formatNumber;
            }
        }
        return null;
    }

    @Override
    public ValueMap getProperties() {
        if (this.combinedProperties == null) {
            this.combinedProperties = this.asset.getProperties();
        }
        return this.combinedProperties;
    }

    @Override
    public AssetModel getAsset() {
        return this.asset;
    }

    @Override
    public String getPropertyName() {
        if (Metadata.DataType.COMPUTED.equals((Object)this.getType())) {
            return this.computedProperty;
        }
        return this.propertyName;
    }

    @Override
    public boolean isEmpty() {
        if (StringUtils.isBlank((CharSequence)this.getPropertyName())) {
            return true;
        }
        if (Metadata.DataType.JSON.equals((Object)this.getType())) {
            return CollectionUtils.isEmpty(this.getValues());
        }
        Object val = this.combinedProperties.get((Object)this.getPropertyName());
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            return StringUtils.isBlank((CharSequence)((String)val));
        }
        if (val instanceof String[]) {
            return ArrayUtils.isEmpty((Object[])((String[])val)) || !Arrays.stream((String[])val).filter(StringUtils::isNotBlank).findFirst().isPresent();
        }
        if (val instanceof Object[]) {
            return ArrayUtils.isEmpty((Object[])((Object[])val));
        }
        if (val instanceof Collection) {
            return ((Collection)val).isEmpty();
        }
        return false;
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty() || this.hasEmptyText();
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }

    @Override
    public List<String> getValues() {
        if (this.values == null) {
            Asset asset;
            this.values = new ArrayList<String>();
            Object val = this.combinedProperties.get((Object)this.getPropertyName());
            if (null == val) {
                return this.values;
            }
            if (val instanceof String) {
                this.values.add((String)val);
            } else if (val instanceof String[]) {
                this.values.addAll(Arrays.asList((String[])val));
            }
            if (Metadata.DataType.JSON.equals((Object)this.getType()) && null != (asset = DamUtil.resolveToAsset((Resource)this.request.getResourceResolver().getResource(this.jsonSource)))) {
                try {
                    this.values = this.readJson(this.values, asset);
                }
                catch (IOException e) {
                    log.error("Unable to read JSON from [ {} ]. Defaulting to no values.", (Object)asset.getPath(), (Object)e);
                }
            }
        }
        return this.values;
    }

    private List<String> readJson(List<String> metadataValues, Asset jsonAsset) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        try (InputStream stream = (InputStream)jsonAsset.getOriginal().adaptTo(InputStream.class);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Gson gson = new Gson();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject.isJsonObject()) {
                JsonElement optionsJson = jsonObject.get("options");
                if (null == optionsJson) {
                    if (log.isDebugEnabled()) {
                        log.debug("JSON is missing options array [ {} ]", (Object)jsonAsset.getPath());
                    }
                    List<String> list = metadataValues;
                    return list;
                }
                Type listType = new TypeToken<List<JsonOption>>(){}.getType();
                List options = (List)gson.fromJson(optionsJson, listType);
                for (String val : metadataValues) {
                    JsonOption value = options.stream().filter(option -> val.equals(((JsonOption)option).value)).findFirst().orElse(null);
                    if (null != value) {
                        values.add(value.text);
                        continue;
                    }
                    values.add(val);
                }
            }
        }
        return values;
    }

    protected class JsonOption {
        private String text;
        private String value;

        protected JsonOption() {
        }
    }
}

