/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Tags;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Tags.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/tags"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class TagsImpl
extends AbstractEmptyTextComponent
implements Tags {
    private static final Logger log = LoggerFactory.getLogger(TagsImpl.class);
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/tags";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @ValueMapValue
    @Named(value="tagPropertyName")
    private String[] tagPropertyNames;
    @ScriptVariable
    private Page currentPage;
    private List<String> tagTitles;

    @Override
    public List<String> getTagTitles() {
        if (this.tagTitles == null) {
            this.tagTitles = ArrayUtils.isEmpty((Object[])this.tagPropertyNames) ? (List<Object>)this.asset.getProperties().get("tagTitles", this.tagTitles) : this.getCombinedTagTitles();
        }
        return new ArrayList<String>(this.tagTitles);
    }

    private List<String> getCombinedTagTitles() {
        LinkedHashSet<String> combinedTagTitles = new LinkedHashSet<String>();
        for (String tagPropertyName : this.tagPropertyNames) {
            Collection<String> tagValues = this.getTagValuesAsList(tagPropertyName);
            if (tagValues.isEmpty()) continue;
            combinedTagTitles.addAll(this.getTagTitles(tagValues));
        }
        return new ArrayList<String>(combinedTagTitles);
    }

    private Collection<String> getTagTitles(Collection<String> tagValues) {
        Locale locale = this.getLocale();
        TagManager tagManager = (TagManager)this.request.getResourceResolver().adaptTo(TagManager.class);
        LinkedHashSet<String> combinedTagTitles = new LinkedHashSet<String>();
        for (String tagId : tagValues) {
            Tag tag = tagManager.resolve(tagId);
            if (tag != null) {
                combinedTagTitles.add(tag.getTitle(locale));
                continue;
            }
            combinedTagTitles.add(tagId);
        }
        return combinedTagTitles;
    }

    private Collection<String> getTagValuesAsList(String tagPropertyName) {
        Object value = this.asset.getProperties().get((Object)tagPropertyName);
        List<Object> tagValues = new ArrayList();
        if (value instanceof List) {
            tagValues = (List)value;
        } else if (value instanceof String[]) {
            tagValues = Arrays.asList((String[])value);
        } else if (value instanceof String) {
            tagValues.add((String)value);
        } else if (value instanceof Set) {
            tagValues = new ArrayList((Set)value);
        } else {
            log.warn("Failed to collect Tags from incompatible Computed Property [ {} ]", (Object)tagPropertyName);
        }
        return tagValues;
    }

    private Locale getLocale() {
        if (this.currentPage == null) {
            return this.request.getLocale();
        }
        return this.currentPage.getLanguage(false);
    }

    @Override
    public boolean isEmpty() {
        return this.getTagTitles() == null || this.getTagTitles().size() == 0;
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty() || this.hasEmptyText();
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

