/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.util.ServletHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=dam:Asset", "sling.servlet.extensions=renditions"})
@Designate(ocd=Cfg.class)
public class AssetRenditionServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionServlet.class);
    public static final String SERVLET_EXTENSION = "renditions";
    @Reference
    private transient AssetRenditionDispatchers assetRenditionDispatchers;
    @Reference
    private transient ModelFactory modelFactory;
    @Reference
    private transient ServletHelper servletHelper;
    private transient Set allowedParameters = new HashSet();

    public final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        try {
            AssetRenditionParameters parameters = new AssetRenditionParameters(request);
            if (this.acceptsAssetRenditionParameters(parameters)) {
                this.servletHelper.addSlingBindings(request, response);
                AssetModel assetModel = (AssetModel)this.modelFactory.getModelFromWrappedRequest(request, request.getResourceResolver().getResource(parameters.getAsset().getPath()), AssetModel.class);
                if (assetModel == null) {
                    response.sendError(400, "Asset [ " + parameters.getAsset().getPath() + " ] cannot be resolved.");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Looking for first accepting AssetRenditionDispatcher from ordered list of [ {} ] to dispatch asset [ {} ]", (Object)this.assetRenditionDispatchers.getAssetRenditionDispatchers().stream().map(AssetRenditionDispatcher::getName).collect(Collectors.joining(", ")), (Object)assetModel.getPath());
                }
                for (AssetRenditionDispatcher assetRenditionDispatcher : this.assetRenditionDispatchers.getAssetRenditionDispatchers()) {
                    if (this.acceptedByAssetRenditionDispatcher(request, assetModel, assetRenditionDispatcher, parameters)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Asset Rendition Dispatcher [ {} ] accepted for asset [ {} ]", (Object)assetRenditionDispatcher.getName(), (Object)assetModel.getPath());
                        }
                        this.setResponseHeaders(response, parameters);
                        assetRenditionDispatcher.dispatch(request, response);
                        return;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Asset Rendition Dispatcher [ {} ] rejected for asset [ {} ]", (Object)assetRenditionDispatcher.getName(), (Object)assetModel.getPath());
                }
                response.sendError(404, "Unable to resolve an AssetRenditionDispatcher that can dispatch to a rendition.");
            } else {
                response.sendError(400, "Unsupported suffix parameters detected.");
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid request URL format for AssetRenditionServlet.", (Throwable)e);
            response.sendError(400, "Invalid request URL format for AssetRenditionServlet.");
        }
        catch (NullPointerException e) {
            log.error("Null pointer in AssetRenditionServlet most likely trying to resolve a path to an AssetModel.", (Throwable)e);
            response.sendError(500, "Invalid asset path for AssetRenditionServlet.");
        }
    }

    protected boolean acceptedByAssetRenditionDispatcher(SlingHttpServletRequest request, AssetModel assetModel, AssetRenditionDispatcher assetRenditionDispatcher, AssetRenditionParameters parameters) {
        if (assetRenditionDispatcher.getRenditionNames() == null || this.assetRenditionDispatchers == null || StringUtils.isBlank((CharSequence)parameters.getRenditionName())) {
            return false;
        }
        return assetRenditionDispatcher.accepts(assetModel, parameters.getRenditionName());
    }

    protected boolean acceptsAssetRenditionParameters(AssetRenditionParameters assetRenditionParameters) {
        return !((Stream)assetRenditionParameters.getParameters().stream().parallel()).anyMatch(assetRenditionParameter -> !this.allowedParameters.contains(assetRenditionParameter));
    }

    protected void setResponseHeaders(SlingHttpServletResponse response, AssetRenditionParameters parameters) {
        if (parameters.isDownload()) {
            response.setHeader("Content-Disposition", String.format("attachment; filename=%s", parameters.getFileName()));
        } else {
            response.setHeader("Content-Disposition", String.format("filename=%s", parameters.getFileName()));
        }
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.allowedParameters = cfg.allowed_suffix_parameters() != null ? new HashSet<String>(Arrays.asList(cfg.allowed_suffix_parameters())) : Collections.EMPTY_SET;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Rendition Servlet")
    public static @interface Cfg {
        @AttributeDefinition(name="Allowed suffix parameters", description="Only accept requests to this servlet that contain any sub-set of these parameters. Any request that includes suffix parameters that are NOT in this list will be rejected by the servlet. Leave blank to allow any and all suffix parameters. Suffix parameters are any suffix segments between (exclusive) the first and last suffix segments.")
        public String[] allowed_suffix_parameters() default {"download"};
    }
}

