/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.day.cq.commons.Version;
import java.util.Collections;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakIndexResolver {
    private static final Logger log = LoggerFactory.getLogger(OakIndexResolver.class);
    private static final String PN_TYPE = "type";
    private static final String VALUE_TYPE_LUCENE = "lucene";
    private static final String PATH_OAK_INDEX = "/oak:index";

    private OakIndexResolver() {
    }

    public static final String resolveRankingOakIndex(ResourceResolver resourceResolver, String oakIndexRootName) {
        Resource oakIndexes = resourceResolver.getResource(PATH_OAK_INDEX);
        TreeMap map = new TreeMap(Collections.reverseOrder());
        StreamSupport.stream(oakIndexes.getChildren().spliterator(), false).filter(oakIndex -> VALUE_TYPE_LUCENE.equals(oakIndex.getValueMap().get(PN_TYPE, String.class))).forEach(oakIndex -> {
            Version version = OakIndexResolver.getOakIndexVersion(oakIndexRootName, oakIndex.getName());
            if (version != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Resolved Oak Index [ {} ] -> [ {} ]", (Object)oakIndex.getPath(), (Object)version);
                }
                map.put(version, oakIndex.getName());
            } else if (log.isWarnEnabled()) {
                log.warn("Unable to parse version for Oak Index [ {} ]", (Object)oakIndex.getPath());
            }
        });
        if (map.isEmpty()) {
            log.warn("Unable to collect any versions for the provided Oak Index Root Name [ {} ]. This probably means there is a type-o in this parameter.", (Object)oakIndexRootName);
            return null;
        }
        return (String)map.entrySet().iterator().next().getValue();
    }

    protected static final Version getOakIndexVersion(String oakIndexRootName, String oakIndexName) {
        Pattern pattern = Pattern.compile(oakIndexRootName + "(-(\\d+)(-custom-(\\d+))?)?");
        Matcher matcher = pattern.matcher(oakIndexName);
        if (matcher.matches()) {
            String product = (String)StringUtils.defaultIfEmpty((CharSequence)matcher.group(2), (CharSequence)"0");
            String custom = (String)StringUtils.defaultIfEmpty((CharSequence)matcher.group(4), (CharSequence)"0");
            return Version.create((String[])new String[]{product, custom});
        }
        return null;
    }
}

