/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.aem.commons.assetshare.util.impl.RequireAemCanary;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={}, property={"service.type=publish"})
@Designate(ocd=Config.class)
public class RequireAemImpl
implements RequireAem {
    private static final Logger log = LoggerFactory.getLogger(RequireAemImpl.class);
    static final String PN_DISTRIBUTION = "distribution";
    static final String PN_SERVICE_TYPE = "service.type";
    protected static final String PUBLISH_SERVICE_TYPE_VALUE = "publish";
    private ServiceRegistration<?> serviceRegistration;
    private Config config;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile RequireAemCanary requireAemCanary;
    private RequireAem.Distribution distribution;

    @Override
    public RequireAem.Distribution getDistribution() {
        if (RequireAem.Distribution.CLOUD_READY.equals((Object)this.distribution)) {
            return RequireAem.Distribution.CLOUD_READY;
        }
        return RequireAem.Distribution.CLASSIC;
    }

    @Override
    public RequireAem.ServiceType getServiceType() {
        if (StringUtils.equalsIgnoreCase((CharSequence)PUBLISH_SERVICE_TYPE_VALUE, (CharSequence)this.config.service_type())) {
            return RequireAem.ServiceType.PUBLISH;
        }
        return RequireAem.ServiceType.AUTHOR;
    }

    @Activate
    protected void activate(Config config, BundleContext bundleContext) {
        this.config = config;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        this.distribution = this.isCloudService() ? RequireAem.Distribution.CLOUD_READY : RequireAem.Distribution.CLASSIC;
        ((Dictionary)properties).put(PN_DISTRIBUTION, this.distribution.getValue());
        ((Dictionary)properties).put(PN_SERVICE_TYPE, this.config.service_type());
        this.serviceRegistration = bundleContext.registerService(RequireAem.class.getName(), (Object)this, properties);
        if (log.isInfoEnabled()) {
            log.info("Registering [ RequireAem.class ] as an OSGi Service with OSGi properties [ distribution = {}, serviceType = {} ] so it can be used to enable/disable other OSGi Components", ((Dictionary)properties).get(PN_DISTRIBUTION), ((Dictionary)properties).get(PN_SERVICE_TYPE));
        }
    }

    protected boolean isCloudService() {
        return this.requireAemCanary != null;
    }

    @Deactivate
    protected void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    @ObjectClassDefinition(name="Asset Share Commons - AEM Service", description="Describes the AEM Service being operated on.")
    static @interface Config {
        @AttributeDefinition(name="Service type name", description="Defines the which AEM service type (author or publish) the application is running under. Allowed values are: author or publish. Defaults to: publish.")
        public String service_type() default "publish";
    }
}

