/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.async.impl;

import com.adobe.aem.commons.assetshare.components.actions.ActionHelper;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.ExpressionEvaluator;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.cq.dam.download.api.DownloadApiFactory;
import com.adobe.cq.dam.download.api.DownloadException;
import com.adobe.cq.dam.download.api.DownloadManifest;
import com.adobe.cq.dam.download.api.DownloadService;
import com.adobe.cq.dam.download.api.DownloadTarget;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=asset-share-commons/actions/download", "sling.servlet.selectors=download-asset-renditions", "sling.servlet.extensions=zip", "sling.servlet.extensions=json"})
public class AsyncAssetRenditionsDownloadServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AsyncAssetRenditionsDownloadServlet.class);
    private static final String DOWNLOAD_ASSETS = "assets";
    private static final String DOWNLOAD_ASSET_COUNT = "assetCount";
    private static final String DOWNLOAD_RENDITION_COUNT = "renditionCount";
    private static final String DOWNLOAD_ID = "id";
    private static final String REQ_KEY_TIME_ZONE = "timezone";
    private static final String REQ_KEY_ASSET_PATHS = "path";
    private static final String REQ_KEY_RENDITION_NAMES = "renditionName";
    private static final String PN_ALLOWED_RENDITION_NAMES = "allowedRenditionNames";
    public static final String PN_BASE_ARCHIVE_NAME_EXPRESSION = "archiveNameExpression";
    public static final String PARAM_ARCHIVE_NAME = "archiveName";
    public static final String PARAM_RENDITION_BY_ASSET_FOLDER = "groupRenditionsByAssetFolder";
    private static final String DOWNLOAD_ARCHIVE_NAME = "archiveName";
    private static final String ZIP_EXTENSION = ".zip";
    @Reference(target="(distribution=cloud-ready)")
    private transient RequireAem requireAem;
    @Reference
    private transient ActionHelper actionHelper;
    @Reference
    private transient DownloadService downloadService;
    @Reference
    private transient DownloadApiFactory apiFactory;
    @Reference
    private transient ExpressionEvaluator expressionEvaluator;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        boolean groupRenditionsByAssetFolder;
        ValueMap componentProperties = request.getResource().getValueMap();
        List assetModels = this.actionHelper.getAssetsFromQueryParameter(request, REQ_KEY_ASSET_PATHS);
        List renditionNames = this.actionHelper.getAllowedValuesFromQueryParameter(request, REQ_KEY_RENDITION_NAMES, (String[])request.getResource().getValueMap().get(PN_ALLOWED_RENDITION_NAMES, (Object)new String[0]));
        String archiveName = this.evaluateArchiveName((String)componentProperties.get(PN_BASE_ARCHIVE_NAME_EXPRESSION, (Object)"Assets"), this.getZonedNowDateTime(ZonedDateTime.now(ZoneId.of("UTC")), request.getParameter(REQ_KEY_TIME_ZONE)), assetModels, renditionNames);
        boolean bl = groupRenditionsByAssetFolder = assetModels.size() > 1 && renditionNames.size() > 1;
        if (log.isDebugEnabled()) {
            log.debug("Requested assets to download: [ {} ]", (Object)StringUtils.join((Object[])assetModels.stream().map(AssetModel::getPath).toArray(), (String)", "));
            log.debug("Requested renditions to download: [ {} ]", (Object)StringUtils.join((Iterable)renditionNames, (String)", "));
            log.debug("Archive name: [ {} ]", (Object)archiveName);
            log.debug("Group renditions by folder: [ {} ]", (Object)groupRenditionsByAssetFolder);
        }
        DownloadManifest manifest = this.apiFactory.createDownloadManifest();
        for (AssetModel assetModel : assetModels) {
            this.addToDownloadManifest(assetModel, renditionNames, manifest, request.getResource(), archiveName, groupRenditionsByAssetFolder);
        }
        try {
            String downloadId = this.downloadService.download(manifest, request.getResourceResolver());
            if (log.isDebugEnabled()) {
                log.debug("AEM Download Framework Download Id: [ {} ]", (Object)downloadId);
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.getResponseJson(downloadId, assetModels, manifest.getTargetCount(), archiveName).toString());
        }
        catch (DownloadException e) {
            throw new ServletException("Unable to initiate download", (Throwable)e);
        }
    }

    private void addToDownloadManifest(AssetModel asset, Collection renditionNames, DownloadManifest manifest, Resource downloadComponentResource, String archiveName, boolean groupRenditionsByAssetFolder) {
        if (log.isDebugEnabled()) {
            log.debug("Adding Download to Manifest for [ {} ]", (Object)asset.getPath());
        }
        renditionNames.forEach(renditionName -> {
            if (log.isDebugEnabled()) {
                log.debug("Adding Download Rendition to Manifest for [ {} ]", renditionName);
            }
            HashMap<String, Object> renditionParameters = new HashMap<String, Object>();
            renditionParameters.put(REQ_KEY_ASSET_PATHS, asset.getPath());
            renditionParameters.put(REQ_KEY_RENDITION_NAMES, renditionName);
            renditionParameters.put("archiveName", archiveName);
            renditionParameters.put(PARAM_RENDITION_BY_ASSET_FOLDER, groupRenditionsByAssetFolder);
            renditionParameters.put("downloadComponentPath", downloadComponentResource.getPath());
            renditionParameters.put("userId", asset.getResource().getResourceResolver().getUserID());
            if (log.isDebugEnabled()) {
                log.debug("Download Target rendition [ {} ] parameters for [ {} ]", renditionName, (Object)"asset-share-commons__named-rendition");
                renditionParameters.entrySet().stream().forEach(renditionParameter -> log.debug("Rendition [ {} ] parameter: [ {} ] -> [ {} ]", new Object[]{renditionName, renditionParameter.getKey(), renditionParameter.getValue()}));
            }
            DownloadTarget downloadTarget = this.apiFactory.createDownloadTarget("asset-share-commons__named-rendition", renditionParameters);
            manifest.addTarget(downloadTarget);
        });
    }

    private JsonObject getResponseJson(String downloadId, Collection<AssetModel> assetModels, int downloadRenditionCount, String archiveName) {
        JsonObject json = new JsonObject();
        JsonArray assetsJsonArray = new JsonArray();
        assetModels.forEach(assetModel -> assetsJsonArray.add(assetModel.getPath()));
        json.addProperty(DOWNLOAD_ID, downloadId);
        json.add(DOWNLOAD_ASSETS, (JsonElement)assetsJsonArray);
        json.addProperty(DOWNLOAD_ASSET_COUNT, (Number)assetModels.size());
        json.addProperty(DOWNLOAD_RENDITION_COUNT, (Number)downloadRenditionCount);
        json.addProperty("archiveName", archiveName);
        return json;
    }

    protected ZonedDateTime getZonedNowDateTime(ZonedDateTime utcNow, String timeZoneId) {
        block3: {
            if (StringUtils.isNotBlank((CharSequence)timeZoneId)) {
                try {
                    return utcNow.withZoneSameInstant(ZoneId.of(timeZoneId));
                }
                catch (ZoneRulesException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("Time Zone Id [ {} ] invalid. Falling back to UTC.", (Object)utcNow.getZone().getId());
                }
            }
        }
        return utcNow;
    }

    private String evaluateArchiveName(String expression, ZonedDateTime now, Collection<AssetModel> assetModels, Collection<String> renditionNames) {
        expression = this.expressionEvaluator.evaluateAssetsRenditionsExpressions(expression, assetModels, renditionNames);
        if (!StringUtils.endsWith((CharSequence)(expression = this.expressionEvaluator.evaluateDateTimeExpressions(expression, now)), (CharSequence)ZIP_EXTENSION)) {
            expression = expression + ZIP_EXTENSION;
        }
        return expression;
    }
}

