/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.impl;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.resourceTypes=cq:Page", "sling.servlet.selectors=partial", "sling.servlet.extensions=html"})
@Designate(ocd=Cfg.class)
public class ActionPageServlet
extends SlingAllMethodsServlet
implements OptingServlet {
    private static final String RESOURCE_TYPE = "asset-share-commons/components/structure/page";
    private transient Cfg cfg;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        request.getRequestDispatcher(request.getResource()).forward((ServletRequest)new GetRequest(request), (ServletResponse)response);
    }

    public boolean accepts(@Nonnull SlingHttpServletRequest request) {
        Resource resource = request.getResource().getChild("jcr:content");
        if (resource != null) {
            return Arrays.stream(this.cfg.resourceTypes()).anyMatch(resourceType -> resource.isResourceType(resourceType));
        }
        return false;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Action Page Servlet")
    public static @interface Cfg {
        @AttributeDefinition(name="Resource Types", description="The resource types (or super types) that represent Action Pages. Default to [ asset-share-commons/components/structure/page]")
        public String[] resourceTypes() default {"asset-share-commons/components/structure/page"};
    }

    private class GetRequest
    extends SlingHttpServletRequestWrapper {
        private static final String METHOD_GET = "GET";

        public GetRequest(SlingHttpServletRequest request) {
            super(request);
        }

        public String getMethod() {
            return METHOD_GET;
        }
    }
}

