/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates;

import com.adobe.aem.commons.assetshare.components.predicates.Predicate;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.Comparator;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPredicate
implements Predicate {
    private static final Logger log = LoggerFactory.getLogger(AbstractPredicate.class);
    private static final String REQUEST_ATTR_PREDICATE_GROUP_TRACKER = "asset-share-commons__predicate-group";
    private static final String REQUEST_ATTR_LEGACY_PREDICATE_GROUP_TRACKER = "asset-share-commons__legacy_predicate-group";
    private static final String REQUEST_ATTR_FORM_ID_TRACKER = "asset-share-commons__form-id";
    private static final String PN_GENERATE_PREDICATE_GROUP_ID = "generatePredicateGroupId";
    private static final Integer INITIAL_GROUP_ID = 0;
    private static final Integer INITIAL_LEGACY_GROUP_ID = 9999;
    @Self
    @Required
    private SlingHttpServletRequest request;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean expanded;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean autoSearch;
    @ValueMapValue
    @Named(value="updateMethod")
    @Default(values={""})
    private String componentUpdateMethod;
    private int group = 1;
    private Field coreField;

    @Override
    public boolean isExpanded() {
        if (!this.expanded) {
            return StringUtils.isNotBlank((CharSequence)this.getInitialValue()) || !this.getInitialValues().isEmpty();
        }
        return this.expanded;
    }

    @Override
    public boolean isAutoSearch() {
        return this.autoSearch;
    }

    @Override
    public String getGroup() {
        return this.group + "_group";
    }

    @Override
    public String getInitialValue() {
        return null;
    }

    @Override
    public ValueMap getInitialValues() {
        return ValueMap.EMPTY;
    }

    public String getId() {
        if (this.request.getResource() != null && !ResourceUtil.isNonExistingResource((Resource)this.request.getResource())) {
            return "cmp-" + this.getName() + "_" + String.valueOf(this.request.getResource().getPath().hashCode());
        }
        return "cmp-" + this.coreField.getId();
    }

    @Override
    public String getComponentUpdateMethod() {
        return this.componentUpdateMethod;
    }

    public String getTitle() {
        return this.coreField.getTitle();
    }

    public String getValue() {
        return this.coreField.getValue();
    }

    public String getHelpMessage() {
        return this.coreField.getHelpMessage();
    }

    @Override
    public String getFormId() {
        if (this.request.getAttribute(REQUEST_ATTR_FORM_ID_TRACKER) == null) {
            this.request.setAttribute(REQUEST_ATTR_FORM_ID_TRACKER, (Object)1);
        }
        return "asset-share-commons__form-id__" + String.valueOf(this.request.getAttribute(REQUEST_ATTR_FORM_ID_TRACKER));
    }

    public boolean isParameterizedSearchRequest() {
        return PredicateUtil.isParameterizedSearchRequest(this.request);
    }

    protected final void initPredicate(SlingHttpServletRequest request, Field coreField) {
        this.coreField = coreField;
        this.initGroup(request);
    }

    protected final synchronized void initGroup(SlingHttpServletRequest request) {
        if (!(this.isGroupIdGeneratingComponent(request) && this.isReady() && this.generateGroupId(request))) {
            this.generateLegacyGroupId(request);
        }
    }

    private boolean isGroupIdGeneratingComponent(SlingHttpServletRequest request) {
        Component component = WCMUtils.getComponent((Resource)request.getResource());
        return component != null && (Boolean)component.getProperties().get(PN_GENERATE_PREDICATE_GROUP_ID, (Object)false) != false;
    }

    private boolean generateGroupId(SlingHttpServletRequest request) {
        Object groupTracker = request.getAttribute(REQUEST_ATTR_PREDICATE_GROUP_TRACKER);
        if (groupTracker == null) {
            groupTracker = INITIAL_GROUP_ID;
        }
        if (groupTracker instanceof Integer) {
            this.group = (Integer)groupTracker + 1;
            request.setAttribute(REQUEST_ATTR_PREDICATE_GROUP_TRACKER, (Object)this.group);
            return true;
        }
        return false;
    }

    private void generateLegacyGroupId(SlingHttpServletRequest request) {
        Object legacyGroupTracker = request.getAttribute(REQUEST_ATTR_LEGACY_PREDICATE_GROUP_TRACKER);
        if (legacyGroupTracker == null) {
            legacyGroupTracker = INITIAL_LEGACY_GROUP_ID;
        }
        if (legacyGroupTracker instanceof Integer) {
            this.group = (Integer)legacyGroupTracker + 1;
            request.setAttribute(REQUEST_ATTR_LEGACY_PREDICATE_GROUP_TRACKER, (Object)this.group);
        } else {
            this.group = -1;
        }
    }

    public class AlphabeticalOptionItems
    implements Comparator<OptionItem> {
        @Override
        public int compare(OptionItem a, OptionItem b) {
            return a.getText().compareTo(b.getText());
        }
    }
}

