/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl;

import com.adobe.aem.commons.assetshare.configuration.Messages;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Messages.class})
public class MessagesImpl
implements Messages {
    private static final String MESSAGES_REL_PATH = "config/messages";
    private static final String PN_MESSAGE_STYLE = "style";
    private static final String PN_MESSAGE_TEXT = "text";
    private static final String PN_MESSAGE_EVENT_ID = "eventId";
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/configuration/messages";
    @Self
    private SlingHttpServletRequest request;
    @ScriptVariable
    private Page currentPage;
    private Collection<ValueMap> messages;

    @Override
    public Collection<ValueMap> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList<ValueMap>();
            ArrayList<String> tracker = new ArrayList<String>();
            for (Page page = this.currentPage; page != null && StringUtils.startsWith((CharSequence)page.getPath(), (CharSequence)"/content/"); page = page.getParent()) {
                Resource messageResources = page.getContentResource().getChild(MESSAGES_REL_PATH);
                if (messageResources == null) continue;
                Iterator children = messageResources.listChildren();
                while (children.hasNext()) {
                    this.addToTracker(tracker, (Resource)children.next());
                }
            }
        }
        return new ArrayList<ValueMap>(this.messages);
    }

    private void addToTracker(List<String> tracker, Resource child) {
        String trackedPath = StringUtils.substringAfter((String)child.getPath(), (String)"jcr:content");
        if (!tracker.contains(trackedPath) && !this.isMessageEmpty(child.getValueMap())) {
            this.messages.add(child.getValueMap());
            tracker.add(trackedPath);
        }
    }

    private boolean isMessageEmpty(ValueMap properties) {
        return StringUtils.isBlank((CharSequence)((CharSequence)properties.get(PN_MESSAGE_STYLE, String.class))) || StringUtils.isBlank((CharSequence)((CharSequence)properties.get(PN_MESSAGE_TEXT, String.class))) || StringUtils.isBlank((CharSequence)((CharSequence)properties.get(PN_MESSAGE_EVENT_ID, String.class)));
    }

    @Override
    public boolean isReady() {
        return !this.getMessages().isEmpty();
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

