/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl;

import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.AssetResolver;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.WCMMode;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AssetResolverImpl
implements AssetResolver {
    private static final Logger log = LoggerFactory.getLogger(AssetResolverImpl.class);

    @Override
    public Asset resolveAsset(SlingHttpServletRequest request) {
        Asset asset = null;
        String suffix = request.getRequestPathInfo().getSuffix();
        Resource suffixResource = request.getRequestPathInfo().getSuffixResource();
        if (suffixResource != null) {
            asset = this.getAssetByPath(suffixResource);
        } else if (StringUtils.startsWith((CharSequence)request.getRequestPathInfo().getResourcePath(), (CharSequence)"/content/dam") && StringUtils.equals((CharSequence)request.getRequestPathInfo().getExtension(), (CharSequence)"renditions")) {
            asset = null;
        } else if (StringUtils.isNotBlank((CharSequence)suffix) && !StringUtils.startsWith((CharSequence)suffix, (CharSequence)"/content/dam")) {
            asset = this.getAssetById(request, suffix);
        }
        if (asset == null) {
            Resource requestResource = request.getResource();
            asset = (Asset)requestResource.adaptTo(Asset.class);
        }
        if (asset == null) {
            if (!WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)request))) {
                asset = this.resolvePlaceholderAsset((Config)request.adaptTo(Config.class));
            }
            if (asset == null) {
                throw new IllegalArgumentException(String.format("Unable to adapt request [ %s ] via a SlingHttpServletRequest into an Asset.", request.getRequestURI()));
            }
        }
        return asset;
    }

    private Asset getAssetByPath(Resource suffixResource) {
        return (Asset)suffixResource.adaptTo(Asset.class);
    }

    private Asset getAssetById(SlingHttpServletRequest request, String suffix) {
        block3: {
            String id = StringUtils.substringBefore((String)StringUtils.removeStart((String)suffix, (String)"/"), (String)".");
            if (StringUtils.isNotBlank((CharSequence)id)) {
                try {
                    return DamUtil.getAssetFromID((ResourceResolver)request.getResourceResolver(), (String)id);
                }
                catch (RepositoryException e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("Error attempting to resolve asset via ID [ " + id + " ]", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Asset resolveAsset(Resource assetResource) {
        Asset asset = (Asset)assetResource.adaptTo(Asset.class);
        if (asset == null) {
            throw new IllegalArgumentException(String.format("Unable to adapt resource [ %s ] via a Resource into an Asset.", assetResource.getPath()));
        }
        return asset;
    }

    public Asset resolvePlaceholderAsset(Config config) {
        AssetModel placeholder;
        if (log.isDebugEnabled()) {
            log.debug("Attempting to construct a placeholder AssetModel for [ {} ]", (Object)config.getRootPath());
        }
        if ((placeholder = config.getPlaceholderAsset()) != null && placeholder.getResource() != null) {
            return (Asset)placeholder.getResource().adaptTo(Asset.class);
        }
        return null;
    }
}

