/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.ComputedProperties;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(reference={@Reference(name="computedProperty", bind="bindComputedProperty", unbind="unbindComputedProperty", service=ComputedProperty.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)})
public final class ComputedPropertiesImpl
implements ComputedProperties {
    private static final Logger log = LoggerFactory.getLogger(ComputedPropertiesImpl.class);
    private final Object lock = new Object();
    private transient Map<ComputedProperty, RankedComputedProperty> allComputedProperties = new ConcurrentHashMap<ComputedProperty, RankedComputedProperty>();
    private transient List<ComputedProperty> rankedComputedProperties = new CopyOnWriteArrayList<ComputedProperty>();

    @Override
    public List<ComputedProperty> getComputedProperties() {
        if (log.isTraceEnabled()) {
            log.trace("Returning this list of highest ranking Computed Properties by label");
            this.rankedComputedProperties.stream().forEach(computedProperty -> log.trace("Computed property: [ name: {} ] - [ label: {} ]", (Object)computedProperty.getName(), (Object)computedProperty.getLabel()));
        }
        return new ArrayList<ComputedProperty>(this.rankedComputedProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindComputedProperty(ComputedProperty computedProperty, Map<String, Object> props) {
        RankedComputedProperty rankedComputedProperty = new RankedComputedProperty(computedProperty, props);
        log.debug("Binding Computed Property: [ name: {} ] - [ rank: {} ] - [ label: {} ]", (Object[])new String[]{rankedComputedProperty.getName(), String.valueOf(rankedComputedProperty.getRank()), rankedComputedProperty.getComputedProperty().getLabel()});
        this.allComputedProperties.put(computedProperty, rankedComputedProperty);
        Object object = this.lock;
        synchronized (object) {
            this.rankedComputedProperties = this.getHighestRankingByLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindComputedProperty(ComputedProperty computedProperty, Map<String, Object> props) {
        RankedComputedProperty rankedComputedProperty = new RankedComputedProperty(computedProperty, props);
        log.debug("Unbinding Computed Property: [ name: {} ] - [ rank: {} ] - [ label: {} ]", (Object[])new String[]{rankedComputedProperty.getName(), String.valueOf(rankedComputedProperty.getRank()), rankedComputedProperty.getComputedProperty().getLabel()});
        this.allComputedProperties.remove(computedProperty);
        Object object = this.lock;
        synchronized (object) {
            this.rankedComputedProperties = this.getHighestRankingByLabel();
        }
    }

    private CopyOnWriteArrayList<ComputedProperty> getHighestRankingByLabel() {
        return new CopyOnWriteArrayList<ComputedProperty>(this.allComputedProperties.values().stream().sorted(Comparator.comparing(RankedComputedProperty::getRank).reversed()).peek(rankedComputedProperty -> log.trace("Computed Property by Rank: [ name: {} ] - [ rank: {} ] - [ label: {} ]", (Object[])new String[]{rankedComputedProperty.getName(), String.valueOf(rankedComputedProperty.getRank()), rankedComputedProperty.getComputedProperty().getLabel()})).filter(this.distinctByKey(RankedComputedProperty::getName)).peek(rankedComputedProperty -> log.trace("Highest ranking Computed Property: [ name: {} ] - [ rank: {} ] - [ label: {} ]", (Object[])new String[]{rankedComputedProperty.getName(), String.valueOf(rankedComputedProperty.getRank()), rankedComputedProperty.getComputedProperty().getLabel()})).map(RankedComputedProperty::getComputedProperty).sorted(Comparator.comparing(ComputedProperty::getLabel)).collect(Collectors.toList()));
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    private class RankedComputedProperty {
        private final String name;
        private final ComputedProperty computedProperty;
        private final Integer rank;

        public RankedComputedProperty(ComputedProperty computedProperty, Map<String, Object> props) {
            this.rank = (Integer)new ValueMapDecorator(props).get("service.ranking", (Object)0);
            this.name = computedProperty.getName();
            this.computedProperty = computedProperty;
        }

        public String getName() {
            return this.name;
        }

        public ComputedProperty getComputedProperty() {
            return this.computedProperty;
        }

        public int getRank() {
            return this.rank;
        }
    }
}

