/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.impl;

import com.adobe.acs.commons.util.BufferedSlingHttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletResponse;

public class AssetRenditionDownloadResponse
extends BufferedSlingHttpServletResponse {
    private String redirectLocation = null;
    private ByteArrayOutputStream baos;
    private int statusCode = 200;
    private boolean redirect = false;
    private String contentType;
    private int contentLength;

    public AssetRenditionDownloadResponse(SlingHttpServletResponse wrappedResponse, StringWriter writer, ByteArrayOutputStream outputStream) {
        super(wrappedResponse, writer, outputStream);
        this.baos = outputStream;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public String getRedirect() {
        return this.redirectLocation;
    }

    public void sendRedirect(String location) {
        this.redirect = true;
        this.redirectLocation = location;
    }

    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
        if (statusCode == 302 || statusCode == 301) {
            this.redirect = true;
        }
    }

    public void setHeader(String key, String value) {
        if ("Location".equals(key)) {
            this.redirectLocation = value;
        } else if ("Content-Type".equals(key)) {
            this.contentType = value;
        } else if ("Content-Length".equals(key)) {
            this.contentLength = Integer.parseInt(value);
        }
    }

    public void sendError(int statusCode) {
        this.statusCode = statusCode;
    }

    public void sendError(int statusCode, String msg) {
        this.statusCode = statusCode;
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.baos;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.contentType, (CharSequence)super.getContentType());
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }
}

