/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.aem.commons.assetshare.util.MimeTypeHelper;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={MimeTypeHelper.class})
@Designate(ocd=Cfg.class)
public class MimeTypeHelperImpl
implements MimeTypeHelper {
    private Cfg cfg;

    @Override
    public boolean isBrowserSupportedImage(String mimeType) {
        return Arrays.stream(this.cfg.browserSupportedImageMimeTypes()).anyMatch(browserSupportedImageMimeType -> StringUtils.equals((CharSequence)browserSupportedImageMimeType, (CharSequence)mimeType));
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - MimeTypeHelper")
    public static @interface Cfg {
        @AttributeDefinition(name="Browser Supported Image MIME Types", description="List of MIME types that are considered images supported by the browser (can be displayed via img tag).")
        public String[] browserSupportedImageMimeTypes() default {"image/jpg", "image/jpeg", "image/png", "image/apng", "image/gif", "image/webp", "image/tiff", "image/svg+xml", "image/bmp", "image/x-xbitmap"};
    }
}

