/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Metadata;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.JsonResolver;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.sightly.SightlyWCMMode;
import com.day.cq.wcm.api.Page;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Metadata.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/metadata"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class MetadataImpl
extends AbstractEmptyTextComponent
implements Metadata {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/metadata";
    protected static final String PN_TYPE = "type";
    private static final Logger log = LoggerFactory.getLogger(MetadataImpl.class);
    @Self
    @Required
    private SlingHttpServletRequest request;
    @SlingObject
    @Required
    private SlingHttpServletResponse response;
    @Self
    @Required
    private AssetModel asset;
    @OSGiService
    private JsonResolver jsonResolver;
    @ScriptVariable
    private SightlyWCMMode wcmmode;
    @ScriptVariable
    private Page currentPage;
    @ValueMapValue
    private String propertyName;
    @ValueMapValue
    private String computedProperty;
    @ValueMapValue
    private String formatDate;
    @ValueMapValue
    private String formatNumber;
    @ValueMapValue
    private Double unitConverter;
    @ValueMapValue(name="type")
    private String typeString;
    @ValueMapValue
    private String jsonSource;
    private Metadata.DataType type;
    private String locale;
    private ValueMap combinedProperties;
    private List<String> values = null;

    @PostConstruct
    public void init() {
        this.combinedProperties = this.getProperties();
    }

    @Override
    public Metadata.DataType getType() {
        this.type = Metadata.DataType.fromString(this.typeString);
        return this.type;
    }

    @Override
    public String getLocale() {
        if (this.locale == null) {
            this.locale = this.currentPage == null ? Locale.getDefault().getLanguage() : this.currentPage.getLanguage(false).getLanguage();
        }
        return this.locale;
    }

    @Override
    public String getFormat() {
        if (this.type == null) {
            this.getType();
        }
        switch (this.type) {
            case DATE: {
                return this.formatDate;
            }
            case NUMBER: {
                return this.formatNumber;
            }
        }
        return null;
    }

    @Override
    public ValueMap getProperties() {
        if (this.combinedProperties == null) {
            this.combinedProperties = this.asset.getProperties();
        }
        return this.combinedProperties;
    }

    @Override
    public AssetModel getAsset() {
        return this.asset;
    }

    @Override
    public String getPropertyName() {
        if (Metadata.DataType.COMPUTED.equals((Object)this.getType())) {
            return this.computedProperty;
        }
        return this.propertyName;
    }

    @Override
    public boolean isEmpty() {
        if (StringUtils.isBlank((CharSequence)this.getPropertyName())) {
            return true;
        }
        if (Metadata.DataType.JSON.equals((Object)this.getType())) {
            return CollectionUtils.isEmpty(this.getValues());
        }
        Object val = this.combinedProperties.get((Object)this.getPropertyName());
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            return StringUtils.isBlank((CharSequence)((String)val));
        }
        if (val instanceof String[]) {
            return ArrayUtils.isEmpty((Object[])((String[])val)) || !Arrays.stream((String[])val).filter(StringUtils::isNotBlank).findFirst().isPresent();
        }
        if (val instanceof Object[]) {
            return ArrayUtils.isEmpty((Object[])((Object[])val));
        }
        if (val instanceof Collection) {
            return ((Collection)val).isEmpty();
        }
        return false;
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty() || this.hasEmptyText();
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }

    @Override
    public List<String> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<String>();
            Object val = this.combinedProperties.get((Object)this.getPropertyName());
            if (null == val) {
                return this.values;
            }
            if (val instanceof String) {
                this.values.add((String)val);
            } else if (val instanceof String[]) {
                this.values.addAll(Arrays.asList((String[])val));
            }
            if (Metadata.DataType.JSON.equals((Object)this.getType()) && StringUtils.isNotBlank((CharSequence)this.jsonSource)) {
                JsonElement jsonElement = this.jsonResolver.resolveJson(this.request, this.response, this.jsonSource);
                if (jsonElement != null) {
                    this.values = this.getValuesFromJson(this.values, jsonElement);
                } else {
                    log.error("Unable to read JSON from [ {} ]. Defaulting to no values.", (Object)this.jsonSource);
                }
            }
        }
        return this.values;
    }

    private List<String> getValuesFromJson(List<String> propertyValues, JsonElement json) {
        String OPTIONS = "options";
        ArrayList<String> values = new ArrayList<String>();
        JsonArray jsonArray = new JsonArray();
        if (json.isJsonArray()) {
            jsonArray = json.getAsJsonArray();
        } else if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("options") && jsonObject.get("options").isJsonArray()) {
                jsonArray = jsonObject.getAsJsonArray("options");
            }
        } else {
            return propertyValues;
        }
        List options = (List)new Gson().fromJson((JsonElement)jsonArray, new TypeToken<List<JsonOption>>(){}.getType());
        for (String propertyValue : propertyValues) {
            JsonOption value = options.stream().filter(option -> propertyValue.equals(option.value)).findFirst().orElse(null);
            if (null != value) {
                values.add(value.text);
                continue;
            }
            values.add(propertyValue);
        }
        return values;
    }

    class JsonOption {
        String text;
        String value;

        JsonOption() {
        }
    }
}

