/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Title;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.Page;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Title.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/title"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class TitleImpl
extends AbstractEmptyTextComponent
implements Title {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/title";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @ValueMapValue
    private String returnPath;
    @ValueMapValue
    @Default(values={"asset-share-commons/components/structure/search-page"})
    private String[] returnPathResourceTypes;
    @ValueMapValue
    @Default(values={"title"})
    private String propertyName;
    @Self
    @Required
    private AssetModel asset;
    @ScriptVariable
    @Required
    private Page currentPage;
    private ValueMap combinedProperties;

    @PostConstruct
    public void init() {
        this.combinedProperties = this.asset.getProperties();
    }

    @Override
    public String getTitle() {
        String value;
        if (StringUtils.isBlank((CharSequence)this.propertyName)) {
            this.propertyName = "title";
        }
        if (StringUtils.isBlank((CharSequence)(value = (String)this.combinedProperties.get(this.propertyName, (Object)"")))) {
            return (String)this.combinedProperties.get("title", (Object)"");
        }
        return value;
    }

    @Override
    public String getReturnPath() {
        if (StringUtils.isBlank((CharSequence)this.returnPath)) {
            for (Page page = this.currentPage; page != null; page = page.getParent()) {
                for (String returnPathResourceType : this.returnPathResourceTypes) {
                    if (!page.getContentResource().isResourceType(returnPathResourceType)) continue;
                    return page.getPath();
                }
            }
        }
        return this.returnPath;
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getTitle());
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

