/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.DefaultValuesPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.PropertyPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.impl.options.SelectedOptionItem;
import com.adobe.aem.commons.assetshare.components.predicates.impl.options.UnselectedOptionItem;
import com.adobe.aem.commons.assetshare.util.JsonResolver;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={PropertyPredicate.class, DefaultValuesPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/property"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class PropertyPredicateImpl
extends AbstractPredicate
implements PropertyPredicate,
DefaultValuesPredicate,
Options {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/property";
    protected static final String PN_TYPE = "type";
    protected String valueFromRequest = null;
    protected ValueMap valuesFromRequest = null;
    @Self
    @Required
    private SlingHttpServletRequest request;
    @SlingObject
    @Required
    private SlingHttpServletResponse response;
    @SlingObject
    private Resource resource;
    @Self
    @Required
    private Options coreOptions;
    @OSGiService
    private JsonResolver jsonResolver;
    @ValueMapValue
    private String label;
    @ValueMapValue
    private String property;
    @ValueMapValue
    private String operation;
    @ValueMapValue
    private Boolean expanded;
    @ValueMapValue(name="type")
    private String typeString;
    @ValueMapValue
    @Named(value="and")
    @Default(booleanValues={false})
    private boolean and;
    @ValueMapValue
    private String source;
    @ValueMapValue
    private String jsonSource;
    private List<OptionItem> items = null;

    @PostConstruct
    protected void init() {
        this.initPredicate(this.request, (Field)this.coreOptions);
    }

    @Override
    public List<OptionItem> getItems() {
        if (this.items == null) {
            ValueMap initialValues = this.getInitialValues();
            ArrayList<OptionItem> processedOptionItems = new ArrayList<OptionItem>();
            boolean useDefaultSelected = !this.isParameterizedSearchRequest();
            List<Object> optionItems = new ArrayList();
            if (StringUtils.equalsIgnoreCase((CharSequence)"json", (CharSequence)this.source)) {
                JsonElement jsonElement = this.jsonResolver.resolveJson(this.request, this.response, this.jsonSource);
                if (jsonElement != null) {
                    optionItems = this.getOptionItemsFromJson(jsonElement);
                }
            } else {
                optionItems = this.coreOptions.getItems();
            }
            optionItems.stream().forEach(optionItem -> {
                if (PredicateUtil.isOptionInInitialValues(optionItem, initialValues)) {
                    processedOptionItems.add(new SelectedOptionItem((OptionItem)optionItem));
                } else if (useDefaultSelected) {
                    processedOptionItems.add((OptionItem)optionItem);
                } else {
                    processedOptionItems.add(new UnselectedOptionItem((OptionItem)optionItem));
                }
            });
            this.items = processedOptionItems;
        }
        return this.items;
    }

    @Override
    public Options.Type getType() {
        return this.coreOptions.getType();
    }

    @Override
    public String getSubType() {
        return this.typeString;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public String getValuesKey() {
        return "values";
    }

    @Override
    public boolean hasOperation() {
        return StringUtils.isNotBlank((CharSequence)this.getOperation());
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public boolean hasAnd() {
        return this.and;
    }

    @Override
    public Boolean getAnd() {
        return this.and;
    }

    public String getName() {
        return "propertyvalues";
    }

    @Override
    public boolean isReady() {
        return this.getItems().size() > 0;
    }

    @Override
    public String getInitialValue() {
        if (this.valueFromRequest == null) {
            this.valueFromRequest = PredicateUtil.getInitialValue(this.request, this, "values");
        }
        return this.valueFromRequest;
    }

    @Override
    public ValueMap getInitialValues() {
        if (this.valuesFromRequest == null) {
            this.valuesFromRequest = PredicateUtil.getInitialValues(this.request, this, "values");
        }
        return this.valuesFromRequest;
    }

    @Override
    public PredicateGroup getPredicateGroup() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.resource == null) {
            return new PredicateGroup();
        }
        String prefix = this.getName() + ".";
        int i = 0;
        for (OptionItem item : this.getItems()) {
            if (!item.isSelected()) continue;
            params.put(prefix + "property", this.getProperty());
            params.put(prefix + i + "_" + this.getValuesKey(), item.getValue());
            params.put(prefix + "operation", this.getOperation());
            if (this.hasAnd()) {
                params.put(prefix + "and", String.valueOf(this.getAnd()));
            }
            ++i;
        }
        return PredicateConverter.createPredicates(params);
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }

    protected List<OptionItem> getOptionItemsFromJson(JsonElement json) {
        String OPTIONS = "options";
        TypeToken<List<TextValueJsonOption>> textValueTypeToken = new TypeToken<List<TextValueJsonOption>>(){};
        List<OptionItem> values = new ArrayList();
        JsonArray jsonArray = new JsonArray();
        if (json != null) {
            JsonObject jsonObject;
            if (json.isJsonArray()) {
                jsonArray = json.getAsJsonArray();
            } else if (json.isJsonObject() && (jsonObject = json.getAsJsonObject()).has("options") && jsonObject.get("options").isJsonArray()) {
                jsonArray = json.getAsJsonObject().getAsJsonArray("options");
            }
        }
        if ((values = (List)new Gson().fromJson((JsonElement)jsonArray, textValueTypeToken.getType())).stream().anyMatch(kv -> kv.getText() == null || kv.getValue() == null)) {
            values = new ArrayList();
        }
        return values;
    }

    protected class TextValueJsonOption
    implements OptionItem {
        private final String text;
        private final String value;

        public TextValueJsonOption(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public String getText() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

