/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.AssetResolver;
import com.adobe.aem.commons.assetshare.content.impl.CombinedProperties;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperties;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={AssetModel.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class AssetModelImpl
implements AssetModel {
    @Self
    private SlingHttpServletRequest request;
    @Self
    @Optional
    private Resource resource;
    @OSGiService
    @Required
    private ComputedProperties computedProperties;
    @OSGiService
    @Required
    private AssetResolver assetResolver;
    private ValueMap properties;
    private Asset asset;

    @PostConstruct
    public void init() {
        if (this.request != null) {
            this.asset = this.assetResolver.resolveAsset(this.request);
        } else if (this.resource != null) {
            this.asset = DamUtil.resolveToAsset((Resource)this.resource);
        }
        if (this.asset == null) {
            throw new IllegalArgumentException("Unable to to construct an AssetModel from the provided adaptables.");
        }
        this.resource = (Resource)this.asset.adaptTo(Resource.class);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getPath() {
        return this.asset.getPath();
    }

    @Override
    public String getUrl() {
        return UrlUtil.escape(this.getPath());
    }

    @Override
    public Asset getAsset() {
        return DamUtil.resolveToAsset((Resource)this.getResource());
    }

    @Override
    public String getAssetId() {
        return this.asset.getID();
    }

    @Override
    public String getName() {
        return this.asset.getName();
    }

    @Override
    public String getTitle() {
        return (String)this.getProperties().get("title", String.class);
    }

    @Override
    public List<Rendition> getRenditions() {
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        Iterator itr = this.asset.listRenditions();
        while (itr.hasNext()) {
            renditions.add((Rendition)itr.next());
        }
        return renditions;
    }

    @Override
    public ValueMap getProperties() {
        if (this.properties == null) {
            this.properties = this.asset != null ? new ValueMapDecorator((Map)new CombinedProperties(this.computedProperties.getComputedProperties(), this.request, this.asset)) : new ValueMapDecorator(new HashMap());
        }
        return this.properties;
    }
}

