/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class TagTitlesImpl
extends AbstractComputedProperty<List<String>> {
    public static final String LABEL = "Tag Titles";
    public static final String NAME = "tagTitles";
    private Cfg cfg;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public List<String> get(Asset asset, SlingHttpServletRequest request) {
        ArrayList<String> tagLabels = new ArrayList<String>();
        Resource metadataResource = ((Resource)asset.adaptTo(Resource.class)).getChild("jcr:content/metadata");
        TagManager tagManager = (TagManager)metadataResource.getResourceResolver().adaptTo(TagManager.class);
        if (metadataResource == null || tagManager == null) {
            return tagLabels;
        }
        Tag[] tags = tagManager.getTags(metadataResource);
        if (tags != null) {
            ComponentContext componentContext = this.getComponentContext(request);
            Page currentPage = componentContext != null ? componentContext.getPage() : null;
            Locale locale = currentPage == null ? request.getLocale() : currentPage.getLanguage(false);
            for (Tag tag : tags) {
                tagLabels.add(tag.getTitle(locale));
            }
        }
        Collections.sort(tagLabels);
        return tagLabels;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Tag Titles")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Tag Titles";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};
    }
}

