/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions.download.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionStreamer;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsDownloadOrchestrator;
import com.adobe.aem.commons.assetshare.content.renditions.download.AssetRenditionsException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Cfg.class)
public class AssetRenditionsZipperImpl
implements AssetRenditionsDownloadOrchestrator {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionsZipperImpl.class);
    private static final String DEFAULT_FILE_ATTACHMENT_NAME = "Assets.zip";
    public static final String NAME = "asset-share-commons__download-orchestrator--zip-packer";
    private static final long BYTES_IN_MB = 1024L;
    public static final String VAR_ASSET_NAME = "${asset.name}";
    public static final String VAR_ASSET_EXTENSION = "${asset.extension}";
    public static final String VAR_RENDITION_NAME = "${rendition.name}";
    public static final String VAR_RENDITION_EXTENSION = "${rendition.extension}";
    public static final String VAR_ASSET_FILE_NAME = "${asset.filename}";
    public static final String VAR_ASSET_TITLE = "${asset.title}";
    private static final String PN_NO_CONTENT_FILE_NAME = "noContentFileName";
    private static final String PN_NO_CONTENT_MESSAGE = "noContentMessage";
    private static final String PN_FILE_NAME = "fileName";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String DEFAULT_NO_CONTENT_FILE_NAME = "NO DOWNLOADABLE RENDITIONS.txt";
    public static final String DEFAULT_NO_CONTENT_MESSAGE = "Sorry, we could not find any downloadable renditions for the selected assets / renditions combinations.";
    @Reference
    private AssetRenditionStreamer assetRenditionStreamer;
    @Reference
    private MimeTypeService mimeTypeService;
    private Cfg cfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SlingHttpServletRequest request, SlingHttpServletResponse response, List<AssetModel> assets, List<String> renditionNames) throws IOException {
        String filename = (String)StringUtils.defaultIfBlank((CharSequence)this.getFileName(request.getResource().getValueMap()), (CharSequence)DEFAULT_FILE_ATTACHMENT_NAME);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        response.setContentType("application/zip");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        boolean groupAssetRenditionsByFolder = true;
        long size = 0L;
        HashSet<String> zipEntryFileNames = new HashSet<String>();
        HashSet<String> zipEntryFolderNames = new HashSet<String>();
        for (AssetModel asset : assets) {
            String folderName = null;
            folderName = this.generateUniqueZipEntry(asset.getName(), zipEntryFolderNames);
            for (String renditionName : renditionNames) {
                AssetRenditionStreamer.AssetRenditionStream stream = null;
                try {
                    stream = this.assetRenditionStreamer.getAssetRendition(request, response, asset, renditionName);
                    if (stream.getOutputStream().size() <= 0) continue;
                    this.checkForMaxSize(size += (long)stream.getOutputStream().size());
                    if (folderName != null && !zipEntryFolderNames.contains(folderName)) {
                        this.addFolderAsZipEntry(folderName + "/", zipOutputStream);
                        zipEntryFolderNames.add(folderName);
                    }
                    String zipEntryName = this.getZipEntryName(folderName, asset, renditionName, stream.getContentType(), zipEntryFileNames);
                    this.addAssetRenditionAsZipEntry(folderName, zipEntryName, zipOutputStream, stream.getOutputStream());
                }
                catch (AssetRenditionsException ex) {
                    log.error("Unable to obtain the AssetRendition as an output stream. Skipping...", (Throwable)ex);
                }
                catch (IOException ex) {
                    log.error("Unable to add entry to Zip that is streamed to HTTP Response. Skipping...", (Throwable)ex);
                }
                finally {
                    if (stream == null || stream.getOutputStream() == null) continue;
                    stream.getOutputStream().close();
                }
            }
        }
        if (size == 0L) {
            String fileName = (String)request.getResource().getValueMap().get(PN_NO_CONTENT_FILE_NAME, String.class);
            String message = (String)request.getResource().getValueMap().get(PN_NO_CONTENT_MESSAGE, String.class);
            this.addNoContentFile(fileName, message, zipOutputStream);
        }
        zipOutputStream.close();
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request, List<AssetModel> assets, List<String> renditionNames) {
        return NAME.equals(request.getRequestParameter("asset-renditions-download-orchestrator").getString());
    }

    protected void checkForMaxSize(long size) throws AssetRenditionsException {
        if (this.cfg.max_size() >= 0L && size > this.cfg.max_size() * 1024L) {
            throw new AssetRenditionsException("Selected assets exceed maximum allows size.");
        }
    }

    protected String getFileName(ValueMap properties) {
        String fileName = (String)properties.get(PN_FILE_NAME, (Object)StringUtils.defaultString((String)this.cfg.file_name(), (String)DEFAULT_FILE_ATTACHMENT_NAME));
        if (!StringUtils.endsWith((CharSequence)fileName, (CharSequence)ZIP_EXTENSION)) {
            fileName = fileName + ZIP_EXTENSION;
        }
        return fileName;
    }

    protected String getZipEntryName(String folderName, AssetModel asset, String renditionName, String responseContentType, Set<String> zipEntryFileNames) {
        String extension = this.mimeTypeService.getExtension(responseContentType);
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        variables.put(VAR_ASSET_FILE_NAME, asset.getName());
        variables.put(VAR_ASSET_NAME, StringUtils.substringBeforeLast((String)asset.getName(), (String)"."));
        variables.put(VAR_ASSET_TITLE, asset.getTitle());
        variables.put(VAR_ASSET_EXTENSION, StringUtils.substringAfterLast((String)asset.getName(), (String)"."));
        variables.put(VAR_RENDITION_NAME, renditionName);
        variables.put(VAR_RENDITION_EXTENSION, extension);
        String zipEntryName = StringUtils.replaceEach((String)this.cfg.rendition_filename_expression(), (String[])variables.keySet().toArray(new String[variables.keySet().size()]), (String[])variables.values().toArray(new String[variables.values().size()]));
        zipEntryName = this.generateUniqueZipEntry(zipEntryName, zipEntryFileNames);
        if (folderName != null) {
            zipEntryFileNames.add(folderName + "/" + zipEntryName);
        } else {
            zipEntryFileNames.add(zipEntryName);
        }
        return zipEntryName;
    }

    private String generateUniqueZipEntry(String zipEntryName, Set<String> existingZipEntryNames) {
        String tmpZipEntryName = zipEntryName;
        int count = 1;
        while (existingZipEntryNames.contains(tmpZipEntryName)) {
            tmpZipEntryName = count++ + "-" + zipEntryName;
        }
        return tmpZipEntryName;
    }

    private void addFolderAsZipEntry(String folderName, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(folderName);
        zipOutputStream.putNextEntry(zipEntry);
    }

    private void addAssetRenditionAsZipEntry(String prefix, String zipEntryName, ZipOutputStream zipOutputStream, ByteArrayOutputStream assetRenditionOutputStream) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            zipEntryName = prefix + "/" + zipEntryName;
        }
        ZipEntry zipEntry = new ZipEntry(zipEntryName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.write((byte[])assetRenditionOutputStream.toByteArray(), (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
        assetRenditionOutputStream.close();
    }

    private void addNoContentFile(String fileName, String message, ZipOutputStream zipOutputStream) throws IOException {
        fileName = StringUtils.defaultString((String)fileName, (String)DEFAULT_NO_CONTENT_FILE_NAME);
        message = StringUtils.defaultString((String)message, (String)DEFAULT_NO_CONTENT_MESSAGE);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.write((String)message, (OutputStream)zipOutputStream, (String)"UTF-8");
        zipOutputStream.closeEntry();
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Renditions Zipper")
    public static @interface Cfg {
        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{zip_filename_expression} with max size in MB {max.size}";

        @AttributeDefinition(name="Filename of packed asset renditions", description="The default value for the zip to be downloaded.")
        public String file_name() default "Assets.zip";

        @AttributeDefinition(name="Max Size (in MB)", description="The max size (in MB; 1024 bytes) of source (pre-zipped) files allowed to be zipped.")
        public long max_size() default -1L;

        @AttributeDefinition(name="Rendition Filename Expression", description="The expression that defines how the filename for each entry in the zip file is constructed.")
        public String rendition_filename_expression() default "${asset.name}__${rendition.name}.${rendition.extension}";
    }
}

