/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class ResourceTypeVisitor
extends AbstractResourceVisitor {
    final Collection<Resource> resources = new ArrayList<Resource>();
    protected final String[] resourceTypes;

    public ResourceTypeVisitor(String[] resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public Collection<Resource> getResources() {
        return this.resources;
    }

    public void accept(Resource resource) {
        ValueMap properties = resource.getValueMap();
        if (properties.get("sling:resourceType", String.class) != null) {
            super.accept(resource);
        }
    }

    protected void visit(Resource resource) {
        for (String resourceType : this.resourceTypes) {
            if (this.handleResourceVisit(resource, resourceType)) break;
        }
    }

    protected boolean handleResourceVisit(Resource resource, String resourceType) {
        if (resource != null && resource.getResourceResolver().isResourceType(resource, resourceType)) {
            this.resources.add(resource);
            return true;
        }
        return false;
    }
}

