/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.assetkit.impl.componentupdaters;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.adobe.aem.commons.assetshare.util.assetkit.ComponentUpdater;
import com.day.cq.wcm.api.Page;
import java.util.Collection;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Config.class)
public class BannerComponentUpdaterImpl
implements ComponentUpdater {
    private static final Logger log = LoggerFactory.getLogger(BannerComponentUpdaterImpl.class);
    @Reference
    private transient AssetKitHelper assetKitHelper;
    private Config config;

    @Override
    public String getName() {
        return "Banner component (Asset Share Commons)";
    }

    @Override
    public void updateComponent(Page assetKitPage, Resource assetKit) {
        Collection<? extends AssetModel> assets = this.assetKitHelper.getAssets(new Resource[]{assetKit});
        assets.stream().filter(asset -> StringUtils.equals((CharSequence)"banner", (CharSequence)StringUtils.lowerCase((String)asset.getTitle()))).findFirst().ifPresent(asset -> {
            try {
                this.assetKitHelper.updateComponentOnPage(assetKitPage, this.config.resource_type(), this.config.banner_asset_path_property(), asset.getPath());
            }
            catch (RepositoryException | PersistenceException e) {
                log.error(String.format("Failed to update banner component on page [ %s ]", assetKitPage.getPath()), e);
            }
        });
    }

    @Activate
    @Modified
    protected void activate(Config config) {
        this.config = config;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Banner Component Updater", description="Component updater that updates an Banner component")
    static @interface Config {
        @AttributeDefinition(name="Resource Type", description="The resource type of the component to update.")
        public String resource_type() default "asset-share-commons/components/content/image";

        @AttributeDefinition(name="Banner asset property", description="The property name that holds the banner asset's path.")
        public String banner_asset_path_property() default "fileReference";
    }
}

