/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl;

import com.adobe.aem.commons.assetshare.components.actions.share.ShareService;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.ForcedInheritanceValueMapWrapper;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Config.class})
public class ConfigImpl
implements Config {
    private static final Logger log = LoggerFactory.getLogger(ConfigImpl.class);
    public static final String NODE_NAME = "config";
    private static final String HTML_EXTENSION = ".html";
    private static final String[] rootResourceTypes = new String[]{"asset-share-commons/components/structure/search-page"};
    private static final String SCENE7_FEATURE_FLAG = "com.adobe.dam.asset.scene7.feature.flag";
    private static final String DEFAULT_VIEW_SELECTOR = "partial";
    private static final String PN_VIEW_SELECTOR = "config/actions/viewSelector";
    private static final String PN_LICENSE_ENABLED = "config/actions/license/enabled";
    private static final String PN_LICENSE_AGREEMENT_VIEW_PATH = "config/actions/license/path";
    private static final String PN_DOWNLOAD_ENABLED = "config/actions/download/enabled";
    private static final String PN_DOWNLOAD_VIEW_PATH = "config/actions/download/path";
    private static final String PN_DOWNLOADS_VIEW_PATH = "config/actions/downloads/path";
    private static final String PN_CART_ENABLED = "config/actions/cart/enabled";
    private static final String PN_CART_VIEW_PATH = "config/actions/cart/path";
    private static final String PN_SHARE_ENABLED = "config/actions/share/enabled";
    private static final String PN_SHARE_VIEW_PATH = "config/actions/share/path";
    private static final String PN_DEFAULT_ASSET_DETAILS_PATH = "config/asset-details/defaultPath";
    private static final String PN_ASSET_DETAILS_SELECTOR = "config/asset-details/selector";
    public static final String PN_PLACEHOLDER_ASSET_PATH = "config/asset-details/placeholderPath";
    public static final String PN_ASSET_REFERENCE_BY_ID = "config/asset-details/assetReferenceById";
    public static final String DEFAULT_PLACEHOLDER_ASSET_PATH = "/apps/asset-share-commons/resources/placeholder.png";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @OSGiService
    @Required
    private ModelFactory modelFactory;
    @OSGiService
    @Required
    private RequireAem requireAem;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private ShareService shareService;
    @SlingObject
    @Required
    private Resource requestResource;
    private Page currentPage;
    private ValueMap properties;
    private String viewSelector;
    private String rootPath;

    @PostConstruct
    protected void init() {
        ComponentContext componentContext = WCMUtils.getComponentContext((ServletRequest)this.request);
        Resource pageResource = this.requestResource;
        if (componentContext != null && componentContext.getPage() != null) {
            pageResource = componentContext.getPage().getContentResource();
        }
        PageManager pageManager = (PageManager)pageResource.getResourceResolver().adaptTo(PageManager.class);
        this.currentPage = pageManager.getContainingPage(pageResource);
        this.properties = new ForcedInheritanceValueMapWrapper((InheritanceValueMap)new HierarchyNodeInheritanceValueMap(this.currentPage.getContentResource()));
        this.viewSelector = (String)this.properties.get(PN_VIEW_SELECTOR, (Object)DEFAULT_VIEW_SELECTOR);
        this.rootPath = this.getRootPath(this.currentPage);
    }

    @Override
    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public ResourceResolver getResourceResolver() {
        return this.request.getResourceResolver();
    }

    @Override
    public ValueMap getProperties() {
        return this.properties;
    }

    @Override
    public Locale getLocale() {
        if (this.currentPage != null) {
            return this.currentPage.getLanguage(false);
        }
        return Locale.getDefault();
    }

    @Override
    public AssetModel getPlaceholderAsset() {
        String path = (String)this.properties.get(PN_PLACEHOLDER_ASSET_PATH, (Object)DEFAULT_PLACEHOLDER_ASSET_PATH);
        Resource placeholderResource = this.requestResource.getResourceResolver().getResource(path);
        if (placeholderResource != null) {
            return (AssetModel)this.modelFactory.getModelFromWrappedRequest(this.request, placeholderResource, AssetModel.class);
        }
        return null;
    }

    @Override
    public String getDownloadActionUrl() {
        String path = (String)this.properties.get(PN_DOWNLOAD_VIEW_PATH, (Object)(this.rootPath + "/actions/download")) + "." + this.viewSelector + HTML_EXTENSION;
        return this.pathResolves(path) ? path : null;
    }

    @Override
    public String getDownloadsActionUrl() {
        String path = (String)this.properties.get(PN_DOWNLOADS_VIEW_PATH, (Object)(this.rootPath + "/actions/downloads")) + "." + this.viewSelector + HTML_EXTENSION;
        return this.pathResolves(path) ? path : null;
    }

    @Override
    public String getLicenseActionUrl() {
        String path = (String)this.properties.get(PN_LICENSE_AGREEMENT_VIEW_PATH, (Object)(this.rootPath + "/actions/license")) + "." + this.viewSelector + HTML_EXTENSION;
        return this.pathResolves(path) ? path : null;
    }

    @Override
    public String getShareActionUrl() {
        String path = (String)this.properties.get(PN_SHARE_VIEW_PATH, (Object)(this.rootPath + "/actions/share")) + "." + this.viewSelector + HTML_EXTENSION;
        return this.pathResolves(path) ? path : null;
    }

    @Override
    public String getCartActionUrl() {
        String path = (String)this.properties.get(PN_CART_VIEW_PATH, (Object)(this.rootPath + "/actions/cart")) + "." + this.viewSelector + HTML_EXTENSION;
        return this.pathResolves(path) ? path : null;
    }

    @Override
    public boolean isShareEnabled() {
        return this.shareService != null && this.compareEnablementValue(this.properties, PN_SHARE_ENABLED, ActionEnablements.ALWAYS) && this.getShareActionUrl() != null;
    }

    @Override
    public boolean isDownloadEnabled() {
        return this.compareEnablementValue(this.properties, PN_DOWNLOAD_ENABLED, ActionEnablements.ALWAYS) && this.getDownloadActionUrl() != null;
    }

    @Override
    public boolean isDownloadEnabledCart() {
        if (this.isCartEnabled()) {
            return this.compareEnablementValue(this.properties, PN_DOWNLOAD_ENABLED, ActionEnablements.ALWAYS, ActionEnablements.CART) && this.getDownloadActionUrl() != null;
        }
        return false;
    }

    @Override
    public boolean isShareEnabledCart() {
        if (this.isCartEnabled() && this.shareService != null) {
            return this.compareEnablementValue(this.properties, PN_SHARE_ENABLED, ActionEnablements.ALWAYS, ActionEnablements.CART) && this.getShareActionUrl() != null;
        }
        return false;
    }

    private boolean compareEnablementValue(ValueMap properties, String propertyName, ActionEnablements ... validValues) {
        String strValue = (String)properties.get(propertyName, (Object)ActionEnablements.NEVER.value);
        ActionEnablements enablementVal = ActionEnablements.forValue(strValue);
        for (ActionEnablements enablement : validValues) {
            if (enablement != enablementVal) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCartEnabled() {
        return (Boolean)this.properties.get(PN_CART_ENABLED, (Object)false) != false && this.getCartActionUrl() != null;
    }

    @Override
    public boolean isLicenseEnabled() {
        return (Boolean)this.properties.get(PN_LICENSE_ENABLED, (Object)false) != false && this.getLicenseActionUrl() != null;
    }

    @Override
    public String getAssetDetailsSelector() {
        return (String)this.properties.get(PN_ASSET_DETAILS_SELECTOR, (Object)"always-use-default");
    }

    @Override
    public boolean getAssetDetailReferenceById() {
        return (Boolean)this.properties.get(PN_ASSET_REFERENCE_BY_ID, (Object)false);
    }

    @Override
    public String getAssetDetailsPath() {
        return (String)this.properties.get(PN_DEFAULT_ASSET_DETAILS_PATH, (Object)(this.rootPath + "/details"));
    }

    @Override
    public String getAssetDetailsUrl() {
        return this.getAssetDetailsPath() + HTML_EXTENSION;
    }

    @Override
    public String getRootPath() {
        return this.getRootPath(this.currentPage);
    }

    @Override
    public boolean isContextHubEnabled() {
        Resource resource;
        HierarchyNodeInheritanceValueMap properties = new HierarchyNodeInheritanceValueMap(this.currentPage.getContentResource());
        String path = (String)properties.getInherited("cq:contextHubPath", String.class);
        if (StringUtils.isNotBlank((CharSequence)path) && (resource = this.request.getResourceResolver().getResource(path)) != null) {
            return resource.isResourceType("granite/contexthub/cloudsettings/components/baseconfiguration");
        }
        return false;
    }

    @Override
    public boolean isAemClassic() {
        return RequireAem.Distribution.CLASSIC.equals((Object)this.requireAem.getDistribution());
    }

    private boolean pathResolves(String path) {
        Resource resource = this.request.getResourceResolver().resolve((HttpServletRequest)this.request, path);
        return resource != null && !ResourceUtil.isNonExistingResource((Resource)resource);
    }

    private String getRootPath(Page currentPage) {
        ResourceResolver resourceResolver = this.request.getResourceResolver();
        Page page = currentPage;
        do {
            if (page == null) continue;
            for (String resourceType : rootResourceTypes) {
                if (page.getContentResource() != null && resourceResolver.isResourceType(page.getContentResource(), resourceType)) {
                    return page.getPath();
                }
                page = page.getParent();
            }
        } while (page != null);
        if (currentPage != null) {
            if (log.isWarnEnabled()) {
                log.warn("Could not find a valid Asset Share Commons root page for [ {} ]. Check to ensure a parent page sling:resourceSuperTypes one of [ {} ]", (Object)currentPage.getPath(), (Object)StringUtils.join((Object[])rootResourceTypes, (String)","));
            }
        } else {
            log.warn("Could not find a valid Asset Share Commons root page for because the current page could not be resolved.");
        }
        return "/";
    }

    private static enum ActionEnablements {
        ALWAYS("true"),
        NEVER("false"),
        CART("cart");

        private String value;

        private ActionEnablements(String value) {
            this.value = value;
        }

        public static ActionEnablements forValue(String value) {
            for (ActionEnablements enablement : ActionEnablements.values()) {
                if (!enablement.value.equalsIgnoreCase(value)) continue;
                return enablement;
            }
            return NEVER;
        }
    }
}

