/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util;

import com.adobe.aem.commons.assetshare.components.predicates.Predicate;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public final class PredicateUtil {
    private PredicateUtil() {
    }

    public static boolean isParameterizedSearchRequest(SlingHttpServletRequest request) {
        return Arrays.stream(new String[]{"_group.", "?p.", "&p."}).anyMatch(needle -> StringUtils.contains((CharSequence)request.getQueryString(), (CharSequence)needle));
    }

    public static String getParamFromQueryParams(SlingHttpServletRequest request, String parameterName) {
        RequestParameter requestParameter = request.getRequestParameter(parameterName);
        if (requestParameter != null) {
            return requestParameter.getString();
        }
        return "";
    }

    public static boolean isOptionInInitialValues(OptionItem optionItem, ValueMap initialValues) {
        return PredicateUtil.isOptionInInitialValues(optionItem.getValue(), initialValues);
    }

    public static boolean isOptionInInitialValues(String value, ValueMap initialValues) {
        for (String key : initialValues.keySet()) {
            if (!PredicateUtil.isValueInValueMap(value, initialValues.get((Object)key))) continue;
            return true;
        }
        return false;
    }

    private static boolean isValueInValueMap(String needle, Object haystack) {
        boolean found = false;
        if (haystack instanceof String) {
            found = StringUtils.equals((CharSequence)((String)haystack), (CharSequence)needle);
        } else if (haystack instanceof String[]) {
            found = ArrayUtils.contains((Object[])((String[])haystack), (Object)needle);
        }
        return found;
    }

    public static String getInitialValue(SlingHttpServletRequest request, Predicate predicate, String predicateValueName) {
        RequestParameter requestParameter = request.getRequestParameter(predicate.getGroup() + "." + predicate.getName() + "." + predicateValueName);
        if (requestParameter == null && (StringUtils.equals((CharSequence)predicate.getName(), (CharSequence)predicateValueName) || StringUtils.isBlank((CharSequence)predicateValueName))) {
            requestParameter = request.getRequestParameter(predicate.getGroup() + "." + predicate.getName());
        }
        if (requestParameter != null) {
            return requestParameter.getString();
        }
        return "";
    }

    public static ValueMap getInitialValues(SlingHttpServletRequest request, Predicate predicate, String predicateValueName) {
        ValueMapDecorator valuesFromRequest = new ValueMapDecorator(new HashMap());
        Pattern p = Pattern.compile("^(" + predicate.getGroup() + "\\.)?(\\d+_)?" + predicate.getName() + "(\\.((\\d+_)?" + predicateValueName + "))?$");
        for (Map.Entry entry : request.getRequestParameterMap().entrySet()) {
            List<Object> values = new ArrayList();
            Matcher matcher = p.matcher((CharSequence)entry.getKey());
            if (matcher.matches()) {
                values = Arrays.stream((Object[])entry.getValue()).map(RequestParameter::getString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            }
            if (values.isEmpty()) continue;
            valuesFromRequest.put(entry.getKey(), (Object)values.toArray(new String[values.size()]));
        }
        return valuesFromRequest;
    }

    public static ValueMap findPredicate(Map<String, String> queryBuilderParams, String predicateName, String predicateValueName) {
        if (predicateValueName == null) {
            predicateValueName = predicateName;
        }
        ValueMapDecorator foundPredicates = new ValueMapDecorator(new HashMap());
        Pattern p = Pattern.compile("^((\\d+_)?group\\.)?(\\d+_)?" + predicateName + "(\\.((\\d+_)?" + predicateValueName + "))?$");
        queryBuilderParams.keySet().stream().filter(key -> p.matcher((CharSequence)key).matches()).forEach(arg_0 -> PredicateUtil.lambda$findPredicate$2((ValueMap)foundPredicates, queryBuilderParams, arg_0));
        return foundPredicates;
    }

    public static boolean hasPredicate(Map<String, String> predicates, String[] predicateNames) {
        for (String predicateName : predicateNames) {
            Pattern p = Pattern.compile("^((\\d+_)?group\\.)?(\\d+_)?" + predicateName + "(\\.((\\d+_)?(.+)))?$");
            for (String key : predicates.keySet()) {
                if (!p.matcher(key).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$findPredicate$2(ValueMap foundPredicates, Map queryBuilderParams, String key) {
        foundPredicates.put((Object)key, queryBuilderParams.get(key));
    }
}

