/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl;

import com.adobe.aem.commons.assetshare.configuration.AssetDetailsResolver;
import com.adobe.aem.commons.assetshare.configuration.AssetDetailsSelector;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(reference={@Reference(name="assetDetailSelector", bind="bindAssetDetailsSelector", unbind="unbindAssetDetailsSelector", service=AssetDetailsSelector.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)})
public class AssetDetailsResolverImpl
implements AssetDetailsResolver {
    private Map<String, AssetDetailsSelector> assetDetailsSelectors = new ConcurrentHashMap<String, AssetDetailsSelector>();

    @Override
    public String getUrl(Config config, AssetModel asset) {
        String url = null;
        for (AssetDetailsSelector selector : this.assetDetailsSelectors.values()) {
            if (!selector.accepts(config, asset)) continue;
            url = selector.getUrl(config, asset);
            break;
        }
        if (StringUtils.isBlank(url) || ResourceUtil.isNonExistingResource((Resource)config.getResourceResolver().resolve(url))) {
            url = config.getAssetDetailsUrl();
        }
        return url;
    }

    @Override
    public String getFullUrl(Config config, AssetModel asset) {
        String fullUrl = this.getUrl(config, asset);
        if (StringUtils.isNotBlank((CharSequence)fullUrl)) {
            fullUrl = config.getAssetDetailReferenceById() ? fullUrl + "/" + asset.getAssetId() + ".html" : fullUrl + asset.getUrl();
        }
        return fullUrl;
    }

    protected final void bindAssetDetailsSelector(AssetDetailsSelector service, Map<Object, Object> props) {
        String type = service.getClass().getName();
        if (type != null) {
            this.assetDetailsSelectors.put(type, service);
        }
    }

    protected final void unbindAssetDetailsSelector(AssetDetailsSelector service, Map<Object, Object> props) {
        String type = service.getClass().getName();
        if (type != null) {
            this.assetDetailsSelectors.remove(type);
        }
    }
}

