/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.impl;

import com.adobe.acs.commons.util.BufferedServletOutput;
import com.adobe.aem.commons.assetshare.util.JsonResolver;
import com.adobe.aem.commons.assetshare.util.impl.requests.IncludableRequestWrapper;
import com.adobe.aem.commons.assetshare.util.impl.responses.IncludableResponseWrapper;
import com.day.cq.commons.PathInfo;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JsonResolver.class})
public class JsonResolverImpl
implements JsonResolver {
    private static final Logger log = LoggerFactory.getLogger(JsonResolverImpl.class);

    @Override
    public JsonElement resolveJson(SlingHttpServletRequest request, SlingHttpServletResponse response, String path) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource resource = request.getResourceResolver().getResource(path);
        JsonElement result = null;
        try {
            if (resource != null && (resourceResolver.isResourceType(resource, "nt:file") || resourceResolver.isResourceType(resource, "nt:resource") || resourceResolver.isResourceType(resource, "oak:Resource"))) {
                result = this.getJsonFromNtFile(resource);
            } else if (resource != null && DamUtil.resolveToAsset((Resource)resource) != null) {
                result = this.getJsonStringFromDamAsset(resource);
            } else if (resource == null && StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"http://", "https://"})) {
                result = this.getJsonFromExternalUrl(path);
            } else if (resource != null && StringUtils.startsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"/etc/acs-commons/lists/"})) {
                PageManager pageManager = (PageManager)request.getResourceResolver().adaptTo(PageManager.class);
                Page page = pageManager.getContainingPage(path);
                if (page != null) {
                    JsonArray jsonArray = new JsonArray();
                    Resource list = page.getContentResource("list");
                    list.getChildren().forEach(child -> {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("text", (String)child.getValueMap().get("jcr:title", String.class));
                        jsonObject.addProperty("value", (String)child.getValueMap().get("value", String.class));
                        jsonArray.add((JsonElement)jsonObject);
                    });
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("options", (JsonElement)jsonArray);
                    return jsonObject;
                }
            } else {
                result = this.getJsonAsInternalRequest(request, response, path);
            }
        }
        catch (IOException | InterruptedException | ServletException e) {
            log.error("Unable to resolve JSON from path: {}", (Object)path, (Object)e);
        }
        return result;
    }

    private JsonElement getJsonFromNtFile(Resource resource) {
        Resource jcrContent = resource.getChild("jcr:content");
        if (jcrContent != null && StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)jcrContent.getValueMap().get("jcr:mimeType", String.class)), (CharSequence)"application/json")) {
            return this.getJsonElement((InputStream)jcrContent.adaptTo(InputStream.class));
        }
        return null;
    }

    private JsonElement getJsonStringFromDamAsset(Resource resource) {
        Asset asset = DamUtil.resolveToAsset((Resource)resource);
        if (StringUtils.equalsIgnoreCase((CharSequence)asset.getMimeType(), (CharSequence)"application/json")) {
            return this.getJsonElement(asset.getOriginal().getStream());
        }
        return null;
    }

    private JsonElement getJsonAsInternalRequest(SlingHttpServletRequest request, SlingHttpServletResponse response, String path) throws ServletException, IOException {
        IncludableResponseWrapper wrappedResponse = new IncludableResponseWrapper(response);
        PathInfo pathInfo = new PathInfo(path);
        String extension = (String)StringUtils.defaultIfEmpty((CharSequence)pathInfo.getExtension(), (CharSequence)"json");
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(pathInfo.getSelectorString());
        options.setReplaceSuffix("");
        IncludableRequestWrapper wrappedRequest = new IncludableRequestWrapper(request, extension);
        WCMMode.DISABLED.toRequest((ServletRequest)wrappedRequest);
        request.getRequestDispatcher(pathInfo.getResourcePath(), options).include((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        byte[] bytes = null;
        if (wrappedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.WRITER) {
            bytes = wrappedResponse.getBufferedServletOutput().getBufferedString().getBytes(StandardCharsets.UTF_8);
        } else if (wrappedResponse.getBufferedServletOutput().getWriteMethod() == BufferedServletOutput.ResponseWriteMethod.OUTPUTSTREAM) {
            bytes = wrappedResponse.getBufferedServletOutput().getBufferedBytes();
        }
        if (bytes != null) {
            return this.getJsonElement(new ByteArrayInputStream(bytes));
        }
        log.warn("Unable to resolve JSON from path: {}", (Object)path);
        return null;
    }

    private JsonElement getJsonFromExternalUrl(String path) throws IOException, InterruptedException {
        URL url = new URL(path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(10000);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JsonElement jsonElement = this.getJsonElement(new ByteArrayInputStream(response.toString().getBytes(StandardCharsets.UTF_8)));
                return jsonElement;
            }
        }
        return null;
    }

    private JsonElement getJsonElement(InputStream inputStream) {
        String jsonString = null;
        try {
            jsonString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Could not parse JSON from input stream to a string", (Throwable)e);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Resolved to JSON string: {}", (Object)jsonString);
        }
        JsonElement jsonElement = (JsonElement)new Gson().fromJson(jsonString, JsonElement.class);
        if (log.isDebugEnabled()) {
            log.debug("Resolved to JSON element: {}", (Object)jsonElement.getAsString());
        }
        return jsonElement;
    }
}

