/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Analytics {
    static Logger logger = Logger.getLogger(Analytics.class);

    public static void main(String[] args) {
        String hostname = null;
        String url = null;
        String eventfile = null;
        Options options = new Options();
        options.addOption("h", true, "Hostname");
        options.addOption("u", true, "Url");
        options.addOption("f", true, "Event data file");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("u")) {
                url = cmd.getOptionValue("u");
            }
            if (cmd.hasOption("f")) {
                eventfile = cmd.getOptionValue("f");
            }
            if (cmd.hasOption("h")) {
                hostname = cmd.getOptionValue("h");
            }
            if (eventfile == null || hostname == null || url == null) {
                System.out.println("Command line parameters: -h hostname -u url -f path_to_XML_file");
                System.exit(-1);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage());
        }
        URLConnection urlConn = null;
        DataOutputStream printout = null;
        BufferedReader input = null;
        String u = "http://" + hostname + "/" + url;
        String tmp = null;
        try {
            URL myurl = new URL(u);
            urlConn = myurl.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            printout = new DataOutputStream(urlConn.getOutputStream());
            String xml = Analytics.readFile(eventfile, StandardCharsets.UTF_8);
            printout.writeBytes(xml);
            printout.flush();
            printout.close();
            input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            logger.debug((Object)xml);
            while (null != (tmp = input.readLine())) {
                logger.debug((Object)tmp);
            }
            printout.close();
            input.close();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

