/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine;

import com.adobe.aem.demomachine.gui.AemDemoConstants;
import com.adobe.aem.demomachine.gui.AemDemoUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class Checksums {
    static Logger logger = Logger.getLogger(Checksums.class);

    public static void main(String[] args) {
        String rootFolder = null;
        Options options = new Options();
        options.addOption("f", true, "Demo Machine root folder");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("f")) {
                rootFolder = cmd.getOptionValue("f");
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
        Properties md5properties = new Properties();
        List<String[]> listPaths = Arrays.asList(AemDemoConstants.demoPaths);
        for (String[] path : listPaths) {
            if (path.length != 5) continue;
            logger.debug((Object)path[1]);
            File pathFolder = new File(rootFolder + (path[1].length() > 0 ? File.separator + path[1] : ""));
            if (pathFolder.exists()) {
                String md5 = AemDemoUtils.calcMD5HashForDir(pathFolder, Boolean.parseBoolean(path[3]), false);
                logger.debug((Object)("MD5 is: " + md5));
                md5properties.setProperty("demo.path." + path[0], path[1]);
                md5properties.setProperty("demo.md5." + path[0], md5);
                continue;
            }
            logger.error((Object)"Folder cannot be found");
        }
        File md5 = new File(rootFolder + File.separator + "conf" + File.separator + "checksums.properties");
        try {
            Properties tmpProperties = new Properties(){

                @Override
                public synchronized Enumeration<Object> keys() {
                    return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                }
            };
            tmpProperties.putAll((Map<?, ?>)md5properties);
            tmpProperties.store(new FileOutputStream(md5), null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        System.out.println("MD5 checkums generated");
    }
}

