/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;

public class Hostname {
    public static void main(String[] args) {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            Properties props = new Properties();
            props.setProperty("demo.hostname", hostname);
            File f = new File("hostname.properties");
            FileOutputStream out = new FileOutputStream(f);
            props.store(out, "Detected hostname");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(String host, String port) {
        if (port == null || port.equals("")) {
            return false;
        }
        if (host == null || host.equals("")) {
            return false;
        }
        InetSocketAddress sockaddr = new InetSocketAddress(host, Integer.parseInt(port));
        Socket socket = new Socket();
        boolean online = true;
        try {
            socket.connect(sockaddr, 10000);
        }
        catch (SocketTimeoutException stex) {
            online = false;
        }
        catch (IOException iOException) {
            online = false;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException stex) {}
        }
        return online;
    }
}

