/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Json2Csv {
    static Logger logger = Logger.getLogger(Json2Csv.class);

    public static void main(String[] args) throws IOException {
        String inputFile1 = null;
        String inputFile2 = null;
        String outputFile = null;
        HashMap<String, String> hmReportSuites = new HashMap<String, String>();
        Options options = new Options();
        options.addOption("c", true, "Filename 1");
        options.addOption("r", true, "Filename 2");
        options.addOption("o", true, "Filename 3");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("c")) {
                inputFile1 = cmd.getOptionValue("c");
            }
            if (cmd.hasOption("r")) {
                inputFile2 = cmd.getOptionValue("r");
            }
            if (cmd.hasOption("o")) {
                outputFile = cmd.getOptionValue("o");
            }
            if (inputFile1 == null || inputFile1 == null || outputFile == null) {
                System.exit(-1);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage());
        }
        String sInputFile1 = Json2Csv.readFile(inputFile1, Charset.defaultCharset());
        sInputFile1 = sInputFile1.replaceAll("ObjectId\\(\"([0-9a-z]*)\"\\)", "\"$1\"");
        try {
            JSONArray jCustomers = new JSONArray(sInputFile1.trim());
            int size = jCustomers.length();
            for (int i = 0; i < size; ++i) {
                String key;
                JSONObject jCustomer = jCustomers.getJSONObject(i);
                Iterator keys = jCustomer.keys();
                String companyName = null;
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (!key.equals("company")) continue;
                    companyName = jCustomer.getString(key);
                }
                keys = jCustomer.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (!key.equals("report_suites")) continue;
                    JSONArray jReportSuites = jCustomer.getJSONArray(key);
                    int rSize = jReportSuites.length();
                    for (int j = 0; j < rSize; ++j) {
                        hmReportSuites.put(jReportSuites.getString(j), companyName);
                        System.out.println(jReportSuites.get(j) + " for company " + companyName);
                    }
                }
            }
            PrintWriter writer = new PrintWriter(outputFile, "UTF-8");
            writer.println("\"Customer\",\"ReportSuite ID\",\"Number of Documents\",\"Last Updated\"");
            String sInputFile2 = Json2Csv.readFile(inputFile2, Charset.defaultCharset());
            sInputFile2 = sInputFile2.replaceAll("NumberLong\\(\"([0-9a-z]*)\"\\)", "\"$1\"");
            JSONObject jResults = new JSONObject(sInputFile2.trim());
            JSONArray jCollections = jResults.getJSONArray("result");
            int size2 = jCollections.length();
            for (int i = 0; i < size2; ++i) {
                String key;
                JSONObject jCollection = jCollections.getJSONObject(i);
                String id = null;
                String number = null;
                String lastupdate = null;
                Iterator keys = jCollection.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (!key.equals("_id")) continue;
                    id = jCollection.getString(key);
                }
                keys = jCollection.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (!key.equals("noOfDocs")) continue;
                    number = jCollection.getString(key);
                }
                keys = jCollection.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if (!key.equals("latestUpdateDate")) continue;
                    lastupdate = jCollection.getString(key);
                }
                Date d = new Date(Long.parseLong(lastupdate));
                System.out.println((String)hmReportSuites.get(id) + "," + id + "," + number + "," + lastupdate + "," + new SimpleDateFormat("MM-dd-yyyy").format(d));
                writer.println("\"" + (String)hmReportSuites.get(id) + "\",\"" + id + "\",\"" + number + "\",\"" + new SimpleDateFormat("MM-dd-yyyy").format(d) + "\"");
            }
            writer.close();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

