/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class RegExp {
    static Logger logger = Logger.getLogger(RegExp.class);

    public static void main(String[] args) throws IOException {
        String fileName = null;
        String regExp = null;
        String position = null;
        String value = "n/a";
        ArrayList<String> allMatches = new ArrayList<String>();
        Options options = new Options();
        options.addOption("f", true, "Filename");
        options.addOption("r", true, "RegExp");
        options.addOption("p", true, "Position");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("f")) {
                fileName = cmd.getOptionValue("f");
            }
            if (cmd.hasOption("r")) {
                regExp = cmd.getOptionValue("r");
            }
            if (cmd.hasOption("p")) {
                position = cmd.getOptionValue("p");
            }
            if (fileName == null || regExp == null || position == null) {
                System.out.println("Command line parameters: -f fileName -r regExp -p position");
                System.exit(-1);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage());
        }
        String content = RegExp.readFile(fileName, Charset.defaultCharset());
        if (content != null) {
            Matcher m = Pattern.compile(regExp).matcher(content);
            while (m.find()) {
                String group = m.group();
                int pos = group.indexOf(".zip");
                if (pos > 0) {
                    group = group.substring(0, pos);
                }
                logger.debug((Object)("RegExp: " + m.group() + " found returning " + group));
                allMatches.add(group);
            }
            if (allMatches.size() > 0) {
                if (position.equals("first")) {
                    value = (String)allMatches.get(0);
                }
                if (position.equals("last")) {
                    value = (String)allMatches.get(allMatches.size() - 1);
                }
            }
        }
        System.out.println(value);
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

