/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.communities;

import com.adobe.aem.demomachine.Hostname;
import com.adobe.aem.demomachine.communities.Loader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@SlingServlet(paths={"/bin/CreateCommunities"}, methods={"GET"}, metatype=false)
public class CreateCommunities
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 9187308313909516127L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServerException, IOException {
        Resource resHelp;
        int maxretries;
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        ResourceResolver resourceResolver = request.getResourceResolver();
        String userId = resourceResolver.getUserID();
        if (userId == null || !userId.equals("admin")) {
            out.println("Permission denied: admin user requested to access this feature");
            return;
        }
        String coralVersion = "3";
        String coralPath = "/etc";
        Resource resCoral63 = resourceResolver.getResource("/etc/clientlibs/granite/coralui3.js");
        Resource resCoral64 = resourceResolver.getResource("/libs/clientlibs/granite/coralui3.js");
        if (resCoral63 == null && resCoral64 == null) {
            coralVersion = "2";
        }
        if (resCoral64 != null) {
            coralPath = "/libs";
        }
        out.println("<html><head>");
        out.println("<link rel=\"stylesheet\" href=\"" + coralPath + "/clientlibs/granite/coralui" + coralVersion + ".css\" type=\"text/css\">");
        out.println("<script type=\"text/javascript\" src=\"" + coralPath + "/clientlibs/granite/typekit.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"" + coralPath + "/clientlibs/granite/jquery.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"" + coralPath + "/clientlibs/granite/utils.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"" + coralPath + "/clientlibs/granite/moment.js\"></script>");
        out.println("<script type=\"text/javascript\" src=\"" + coralPath + "/clientlibs/granite/coralui" + coralVersion + ".js\"></script>");
        out.println("</head><body class=\"coral--light u-coral-clearFix\" style=\"margin:40px\">");
        out.println("<div><h1>");
        if (coralVersion.equals("3")) {
            out.println("<coral-wait></coral-wait> ");
        }
        out.println("AEM Communities demo setup in progress, please wait...</h1>");
        String csvPath = request.getParameter("contentPath");
        if (csvPath == null) {
            out.println("Aborting: No content path to configuration file provided with csv query string");
            return;
        }
        String hostname = request.getParameter("hostname");
        String port = request.getParameter("port");
        String hostname_author = request.getParameter("hostname_author");
        String port_author = request.getParameter("port_author");
        String password = request.getParameter("password");
        String analytics = request.getParameter("analytics");
        String minimizeParam = request.getParameter("minimize");
        String enablementParam = request.getParameter("noenablement");
        String nomultilingualParam = request.getParameter("nomultilingual");
        String sMaxRetries = request.getParameter("maxretries");
        boolean minimize = minimizeParam != null && minimizeParam.length() > 0;
        boolean enablement = enablementParam != null && enablementParam.length() > 0;
        boolean nomultilingual = nomultilingualParam != null && nomultilingualParam.length() > 0;
        int n = maxretries = sMaxRetries == null ? 30 : Integer.parseInt(sMaxRetries);
        if (hostname_author == null || port_author == null || !Hostname.isReachable(hostname_author, port_author)) {
            out.println("Aborting: Your AEM Author instance is not reachable. Please verify it is properly started.");
            return;
        }
        if (hostname == null) {
            hostname = "";
        }
        if (port == null) {
            port = "";
        }
        if (!(hostname.equals("") || port.equals("") || Hostname.isReachable(hostname, port))) {
            out.println("Aborting: Your AEM Publish instance is not reachable. Please verify it is properly started.");
            return;
        }
        if (hostname.equals("") || port.equals("")) {
            hostname = hostname_author;
            port = port_author;
            out.println("<div><coral-alert>");
            out.println("<coral-alert-header>WARNING</coral-alert-header>");
            out.println("<coral-alert-content>Using an AEM Publish instance is strongly recommended. All UGC is now being posted against this Author instance, which might fail if the demo members are not granted appropriate permissions on Author.</coral-alert-content>");
            out.println("</coral-alert></div>");
        }
        String returnURL = request.getParameter("returnURL");
        out.println("<p>Path to configuration file: " + csvPath + "</p>");
        ArrayList<String> configOptions = new ArrayList<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!paramName.startsWith("setup")) continue;
            configOptions.add(paramName);
        }
        Collections.sort(configOptions);
        if (configOptions.size() > 0) {
            for (String configOption : configOptions) {
                Resource resConfigFiles = resourceResolver.getResource(csvPath);
                for (Resource resConfigFile : resConfigFiles.getChildren()) {
                    if (resConfigFile == null || !resConfigFile.getName().startsWith(configOption.replace("setup-", "")) || !resConfigFile.getName().toLowerCase().endsWith(".csv")) continue;
                    InputStream stream = (InputStream)resConfigFile.adaptTo(InputStream.class);
                    InputStreamReader in = new InputStreamReader(stream);
                    out.println("<p>Processing: " + resConfigFile.getName() + "</p>");
                    response.flushBuffer();
                    if (resConfigFile.getName().contains("author")) {
                        Loader.processLoading(resourceResolver, in, hostname_author, port_author, port, password, analytics, false, true, minimize, enablement, nomultilingual, csvPath, maxretries);
                    } else {
                        Loader.processLoading(resourceResolver, in, hostname, port, port, password, analytics, false, true, minimize, enablement, nomultilingual, csvPath, maxretries);
                    }
                    try {
                        ((Reader)in).close();
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if ((resHelp = resourceResolver.getResource(csvPath + "/readme.html")) != null) {
            String line;
            InputStream stream = (InputStream)resHelp.adaptTo(InputStream.class);
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            try {
                in.close();
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        out.println("<p>Process completed!</p>");
        if (returnURL != null) {
            out.println("<p><a href=\"http://" + request.getServerName() + ":" + request.getServerPort() + returnURL + "\">Check your site !</a></p>");
        }
        response.flushBuffer();
        out.println("</body></html>");
    }
}

