/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.demomachine.communities;

import com.adobe.aem.demomachine.Hostname;
import com.adobe.aem.demomachine.communities.Version;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Loader {
    static Logger logger = Logger.getLogger(Loader.class);
    private static final String USERS = "Users";
    private static final String COMMENTS = "Comments";
    private static final String REVIEWS = "Reviews";
    private static final String RATINGS = "Ratings";
    private static final String FORUM = "Forum";
    private static final String JOURNAL = "Journal";
    private static final String TAG = "Tag";
    private static final String IDEATION = "Ideation";
    private static final String BLOG = "Blog";
    private static final String SUMMARY = "Summary";
    private static final String CALENDAR = "Calendar";
    private static final String PREFERENCES = "Preferences";
    private static final String FILES = "Files";
    private static final String IMAGE = "file";
    private static final String AVATAR = "Avatar";
    private static final String ACTIVATE = "Activate";
    private static final String QNA = "QnA";
    private static final String ACTIVITIES = "Activities";
    private static final String SLINGPOST = "SlingPost";
    private static final String SLINGDELETE = "SlingDelete";
    private static final String FRAGMENT = "Fragment";
    private static final String FOLDER = "Folder";
    private static final String PASSWORD = "password";
    private static final String SITE = "Site";
    private static final String SITEUPDATE = "SiteUpdate";
    private static final String SITEPUBLISH = "SitePublish";
    private static final String SITEDELETE = "SiteDelete";
    private static final String SITETEMPLATE = "SiteTemplate";
    private static final String SITEPATH = "SitePath";
    private static final String GROUPTEMPLATE = "GroupTemplate";
    private static final String GROUPMEMBERS = "GroupMembers";
    private static final String GROUPPUBLISH = "GroupPublish";
    private static final String GROUPDELETE = "GroupDelete";
    private static final String SITEMEMBERS = "SiteMembers";
    private static final String UGCUPVOTE = "Upvote";
    private static final String UGCDOWNVOTE = "Downvote";
    private static final String UGCREPLY = "Reply";
    private static final String UGCFLAG = "Flag";
    private static final String UGCDENY = "Deny";
    private static final String UGCLIKE = "Like";
    private static final String UGCFEATURE = "Feature";
    private static final String UGCPIN = "Pin";
    private static final String UGCANSWER = "Answer";
    private static final String GROUP = "Group";
    private static final String SUBGROUP = "SubGroup";
    private static final String JOIN = "Join";
    private static final String ASSET = "Asset";
    private static final String ASSETINSIGHTS = "AssetInsights";
    private static final String KILL = "Kill";
    private static final String MESSAGE = "Message";
    private static final String RESOURCE = "Resource";
    private static final String BADGE = "Badge";
    private static final String BADGEIMAGE = "BadgeImage";
    private static final String BADGEASSIGN = "BadgeAssign";
    private static final String OPTION_ANALYTICS = "enableAnalytics";
    private static final String OPTION_FACEBOOK = "allowFacebook";
    private static final String OPTION_TWITTER = "allowTwitter";
    private static final String OPTION_TRANSLATION = "allowMachineTranslation";
    private static final String CLOUDSERVICE_ANALYTICS = "analyticsCloudConfigPath";
    private static final String CLOUDSERVICE_FACEBOOK = "fbconnectoauthid";
    private static final String CLOUDSERVICE_TWITTER = "twitterconnectoauthid";
    private static final String CLOUDSERVICE_TRANSLATION = "translationProviderConfig";
    private static final int RESOURCE_INDEX_PATH = 5;
    private static final int RESOURCE_INDEX_THUMBNAIL = 3;
    private static final int CALENDAR_INDEX_THUMBNAIL = 8;
    private static final int CALENDAR_INDEX_TAGS = 9;
    private static final int ASSET_INDEX_NAME = 4;
    private static final int RESOURCE_INDEX_SITE = 7;
    private static final int RESOURCE_INDEX_FUNCTION = 9;
    private static final int RESOURCE_INDEX_PROPERTIES = 10;
    private static final int GROUP_INDEX_NAME = 1;
    private static final String SLEEP = "Sleep";
    private static final String FOLLOW = "Follow";
    private static final String NOTIFICATION = "Notification";
    private static final String NOTIFICATIONPREFERENCE = "NotificationPreference";
    private static final String LEARNING = "LearningPath";
    private static final String BANNER = "pagebanner";
    private static final String THUMBNAIL = "pagethumbnail";
    private static final String LANGUAGE = "baseLanguage";
    private static final String LANGUAGES = "initialLanguages";
    private static final String ROOT = "siteRoot";
    private static final String CSS = "pagecss";
    private static final int MAXRETRIES = 20;
    private static final int REPORTINGDAYS = -21;
    private static final String ENABLEMENT61FP2 = "1.0.135";
    private static final String ENABLEMENT61FP3 = "1.0.148";
    private static final String ENABLEMENT61FP4 = "1.0.164";
    private static final String ENABLEMENT62 = "1.1.0";
    private static final String ENABLEMENT62FP1 = "1.1.19";
    private static final String COMMUNITIES61 = "1.0.13";
    private static final String COMMUNITIES61FP5 = "2.0.7";
    private static final String COMMUNITIES61FP6 = "2.0.14";
    private static final String COMMUNITIES61FP7 = "2.0.15";
    private static final String COMMUNITIES61FP8 = "2.0.16";
    private static final String COMMUNITIES64 = "2.2.0";
    private static String[] comments = new String[]{"This course deserves some improvements", "The conclusion is not super clear", "Very crisp, love it", "Interesting, but I need to look at this course again", "Good course, I'll recommend it.", "Really nice done. Sharing with my peers", "Excellent course. Giving it a top rating."};

    public static void main(String[] args) {
        String hostname = null;
        String port = null;
        String altport = null;
        String csvfile = null;
        String analytics = null;
        String adminPassword = "admin";
        boolean reset = false;
        boolean configure = false;
        boolean minimize = false;
        boolean noenablement = true;
        boolean nomultilingual = true;
        int maxretries = 20;
        Options options = new Options();
        options.addOption("h", true, "Hostname");
        options.addOption("p", true, "Port");
        options.addOption("a", true, "Alternate Port");
        options.addOption("f", true, "CSV file");
        options.addOption("r", false, "Reset");
        options.addOption("u", true, "Admin Password");
        options.addOption("c", false, "Configure");
        options.addOption("m", false, "Minimize");
        options.addOption("l", false, "No Multilingual");
        options.addOption("e", false, "No Enablement");
        options.addOption("s", true, "Analytics Endpoint");
        options.addOption("t", false, "Analytics");
        options.addOption("w", false, "Retry");
        BasicParser parser = new BasicParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                hostname = cmd.getOptionValue("h");
            }
            if (cmd.hasOption("p")) {
                port = cmd.getOptionValue("p");
            }
            if (cmd.hasOption("a")) {
                altport = cmd.getOptionValue("a");
            }
            if (cmd.hasOption("f")) {
                csvfile = cmd.getOptionValue("f");
            }
            if (cmd.hasOption("u")) {
                adminPassword = cmd.getOptionValue("u");
            }
            if (cmd.hasOption("t") && cmd.hasOption("s")) {
                analytics = cmd.getOptionValue("s");
            }
            if (cmd.hasOption("r")) {
                reset = true;
            }
            if (cmd.hasOption("w")) {
                maxretries = Integer.parseInt(cmd.getOptionValue("w"));
            }
            if (cmd.hasOption("c")) {
                configure = true;
            }
            if (cmd.hasOption("m")) {
                minimize = true;
            }
            if (cmd.hasOption("l")) {
                nomultilingual = true;
            }
            if (cmd.hasOption("e")) {
                noenablement = false;
            }
            if (csvfile == null || port == null || hostname == null) {
                System.out.println("Request parameters: -h hostname -p port -a alternateport -u adminPassword -f path_to_CSV_file -r (true|false, delete content before import) -c (true|false, post additional properties)");
                System.exit(-1);
            }
        }
        catch (ParseException ex) {
            logger.error((Object)ex.getMessage());
        }
        logger.info((Object)("AEM Demo Loader: Processing file " + csvfile));
        try {
            if (csvfile != null && csvfile.toLowerCase().endsWith(".zip")) {
                ZipEntry zipEntry;
                ZipFile zipFile = new ZipFile(csvfile);
                ZipInputStream stream = new ZipInputStream(new FileInputStream(csvfile));
                while ((zipEntry = stream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory() || !zipEntry.getName().toLowerCase().endsWith(".csv")) continue;
                    InputStream is = zipFile.getInputStream(zipEntry);
                    BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    Loader.processLoading(null, in, hostname, port, altport, adminPassword, analytics, reset, configure, minimize, noenablement, nomultilingual, csvfile, maxretries);
                }
                try {
                    stream.close();
                    zipFile.close();
                }
                catch (IOException iOException) {}
            } else if (csvfile.toLowerCase().endsWith(".csv")) {
                FileReader in = new FileReader(csvfile);
                Loader.processLoading(null, in, hostname, port, altport, adminPassword, analytics, reset, configure, minimize, noenablement, nomultilingual, csvfile, maxretries);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public static void processLoading(ResourceResolver rr, Reader in, String hostname, String port, String altport, String adminPassword, String analytics, boolean reset, boolean configure, boolean minimize, boolean noenablement, boolean nomultilingual, String csvfile, int maxretries) {
        String location = null;
        String userHome = null;
        String sitePagePath = null;
        String analyticsPagePath = null;
        String resourceType = null;
        String subComponentType = null;
        String rootPath = "/content/sites";
        String[] url = new String[10];
        int urlLevel = 0;
        int row = 0;
        boolean ignoreUntilNextComponent = false;
        HashMap<String, ArrayList> learningpaths = new HashMap<String, ArrayList>();
        try {
            String componentType = null;
            logger.info((Object)"AEM Demo Loader: Loading bundles versions");
            String bundlesList = Loader.doGet(hostname, port, "/system/console/bundles.json", "admin", adminPassword, null, false);
            Version vBundleCommunitiesEnablement = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-enablement-impl");
            Version vBundleCommunitiesCalendar = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-calendar");
            if (vBundleCommunitiesCalendar == null) {
                vBundleCommunitiesCalendar = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-calendar-impl");
            }
            Version vBundleCommunitiesNotifications = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-notifications-impl");
            Version vBundleCommunitiesSCORM = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-scorm-dam");
            Version vBundleCommunitiesSCF = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-scf-impl");
            Version vBundleCommunitiesScoring = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-scoring-impl");
            Version vBundleCommunitiesAdvancedScoring = Loader.getVersion(bundlesList, "com.adobe.cq.social.cq-social-scoring-advanced-impl");
            boolean isCommunities61 = vBundleCommunitiesSCF != null && vBundleCommunitiesSCF.compareTo(new Version(COMMUNITIES61)) == 0;
            boolean isCommunities61FP5orlater = vBundleCommunitiesSCF != null && vBundleCommunitiesSCF.compareTo(new Version(COMMUNITIES61FP5)) >= 0;
            boolean isCommunities61FP6orlater = vBundleCommunitiesSCF != null && vBundleCommunitiesSCF.compareTo(new Version(COMMUNITIES61FP6)) >= 0;
            boolean isCommunities61FP7orlater = vBundleCommunitiesSCF != null && vBundleCommunitiesSCF.compareTo(new Version(COMMUNITIES61FP7)) >= 0;
            boolean isCommunities61FP8orlater = vBundleCommunitiesSCF != null && vBundleCommunitiesSCF.compareTo(new Version(COMMUNITIES61FP8)) >= 0;
            boolean isCommunities64orlater = vBundleCommunitiesScoring != null && vBundleCommunitiesScoring.compareTo(new Version(COMMUNITIES64)) >= 0;
            CSVParser records = CSVFormat.EXCEL.parse(in);
            ignoreUntilNextComponent = false;
            block24: for (CSVRecord record : records) {
                List<NameValuePair> nameValuePairs;
                List<Object> nameValuePairs2;
                MultipartEntityBuilder builder;
                MultipartEntityBuilder builder2;
                LinkedList<InputStream> lIs = new LinkedList<InputStream>();
                logger.info((Object)("Row: " + ++row + ", new record: " + record.get(0)));
                if (record.size() > 2) {
                    subComponentType = record.get(2);
                } else {
                    logger.info((Object)"No subcomponent type to load");
                }
                String action = record.get(0);
                int versionBound = action.indexOf("@");
                if (versionBound > 0) {
                    String version = action.substring(1 + versionBound);
                    if (version.equals("6.4") && !isCommunities64orlater) {
                        logger.info((Object)"Not processing this action on this version");
                        continue;
                    }
                    action = action.substring(0, versionBound);
                }
                if (action.startsWith("#")) continue;
                if (action.equals(KILL)) {
                    if (rr == null) {
                        System.exit(1);
                    } else {
                        return;
                    }
                }
                if (action.equals(SLEEP) && record.get(1).length() > 0) {
                    Loader.doSleep(Long.valueOf(record.get(1)), "Pausing " + record.get(1) + " ms");
                    continue;
                }
                if (action.equals(SITEPATH)) {
                    sitePagePath = record.get(1);
                }
                if (action.equals(SITE)) {
                    builder2 = MultipartEntityBuilder.create();
                    builder2.setCharset(MIME.UTF8_CHARSET);
                    builder2.addTextBody(":operation", "social:createSite", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    builder2.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    String urlName = null;
                    String[] initialLanguages = null;
                    boolean isPostValid = true;
                    for (int i = 2; i < record.size() - 1; i += 2) {
                        if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0) continue;
                        String name = record.get(i).trim();
                        String value = record.get(i + 1).trim();
                        int isRecordValid = 1;
                        if (value.equals("TRUE")) {
                            value = "true";
                        }
                        if (value.equals("FALSE")) {
                            value = "false";
                        }
                        if (name.equals("urlName")) {
                            urlName = value;
                        }
                        if (isCommunities64orlater) {
                            value = value.replaceAll("/etc/community/templates/sites/custom", "/conf/global/settings/community/templates/sites");
                            value = value.replaceAll("/etc/designs/community/sitethemes", "/libs/clientlibs/social/themes/sitethemes");
                        }
                        logger.debug((Object)(name + " " + value));
                        if (name.equals(ROOT)) {
                            rootPath = value;
                            logger.info((Object)("Rootpath for subsequent processing is: " + rootPath));
                            if (!Loader.isResourceAvailable(hostname, port, adminPassword, rootPath)) {
                                logger.warn((Object)("Rootpath " + rootPath + " is not available, proceeding to next record"));
                                isPostValid = false;
                            } else {
                                logger.info((Object)("Rootpath " + rootPath + " is available"));
                            }
                        }
                        if (name.equals(CSS) && isCommunities64orlater) {
                            isRecordValid = 0;
                        }
                        if (name.equals("theme") && !isCommunities64orlater && value.startsWith("/apps")) {
                            isRecordValid = 0;
                        }
                        if ((name.equals(LANGUAGE) || name.equals(LANGUAGES)) && !value.startsWith("en") && nomultilingual) {
                            logger.info((Object)("Language " + value + " is not desired for this site, proceeding to next record"));
                            isPostValid = false;
                        }
                        if (name.equals(BANNER)) {
                            Loader.addBinaryBody(builder2, lIs, rr, BANNER, csvfile, value);
                            continue;
                        }
                        if (name.equals(THUMBNAIL)) {
                            Loader.addBinaryBody(builder2, lIs, rr, THUMBNAIL, csvfile, value);
                            continue;
                        }
                        if (name.equals(CSS)) {
                            Loader.addBinaryBody(builder2, lIs, rr, CSS, csvfile, value);
                            continue;
                        }
                        if (name.equals(LANGUAGE) || name.equals(LANGUAGES)) {
                            if (isCommunities61FP5orlater && !nomultilingual) {
                                for (String initialLanguage : initialLanguages = value.split(",")) {
                                    builder2.addTextBody(LANGUAGES, initialLanguage, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                                }
                                continue;
                            }
                            initialLanguages = new String[]{value.split(",")[0]};
                            builder2.addTextBody(LANGUAGE, initialLanguages[0], ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                            continue;
                        }
                        if (record.size() > i + 3 && (name.equals(OPTION_TRANSLATION) || name.equals(OPTION_ANALYTICS) || name.equals(OPTION_FACEBOOK) || name.equals(OPTION_TWITTER)) && value.equals("true")) {
                            String cloudName = record.get(i + 2).trim();
                            String cloudValue = record.get(i + 3).trim();
                            String cloudUrl = null;
                            if (isCommunities64orlater) {
                                cloudValue = cloudValue.replaceAll("/etc/cloudservices/(.*connect)/", "/conf/global/settings/cloudconfigs/");
                                cloudUrl = !(cloudValue = cloudValue.replaceAll("/etc/cloudservices/msft-translation", "cloudconfigs/translation/msft-translation")).startsWith("/") ? "/libs/settings/" + cloudValue : cloudValue;
                            }
                            if ((cloudName.equals(CLOUDSERVICE_TRANSLATION) || cloudName.equals(CLOUDSERVICE_FACEBOOK) || cloudName.equals(CLOUDSERVICE_TWITTER) || cloudName.equals(CLOUDSERVICE_ANALYTICS)) && !Loader.isResourceAvailable(hostname, port, adminPassword, cloudUrl)) {
                                builder2.addTextBody(name, "false", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                                logger.warn((Object)("Cloud service: " + cloudValue + " is not available on this instance"));
                                continue;
                            }
                            builder2.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                            builder2.addTextBody(cloudName, cloudValue, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                            i += 2;
                            logger.info((Object)("Cloud service: " + cloudValue + " available on this instance"));
                            continue;
                        }
                        if (isRecordValid == 0) continue;
                        builder2.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    }
                    if (!isPostValid) continue;
                    Loader.doPost(hostname, port, "/content.social.json", "admin", adminPassword, builder2.build(), null, null);
                    boolean existingSiteWithLocale = rootPath.indexOf("/" + (String)initialLanguages[0]) > 0;
                    Loader.doWaitPath(hostname, port, adminPassword, rootPath + "/" + urlName + (existingSiteWithLocale ? "" : "/" + (String)initialLanguages[0]), maxretries);
                    if (port.equals(altport)) continue;
                    for (String initialLanguage : initialLanguages) {
                        ArrayList<BasicNameValuePair> nameValuePairs3 = new ArrayList<BasicNameValuePair>();
                        nameValuePairs3.add(new BasicNameValuePair("id", "nobot"));
                        nameValuePairs3.add(new BasicNameValuePair(":operation", "social:publishSite"));
                        nameValuePairs3.add(new BasicNameValuePair("path", rootPath + "/" + urlName + (existingSiteWithLocale ? "" : "/" + initialLanguage)));
                        logger.info((Object)("Publishing site " + urlName + " for language " + initialLanguage));
                        Loader.doPost(hostname, port, "/communities/sites.html", "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs3), null);
                        Loader.doWaitPath(hostname, altport, adminPassword, rootPath + "/" + urlName + (existingSiteWithLocale ? "" : "/" + initialLanguage), maxretries);
                    }
                    continue;
                }
                if (action.equals(SITEUPDATE) && record.get(1) != null && record.get(2) != null) {
                    Version vRecord = null;
                    if (record.get(2).startsWith(">") || record.get(2).startsWith("<") || record.get(2).startsWith("=")) {
                        try {
                            vRecord = new Version(record.get(2).substring(1));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Invalid version number specified" + record.get(2)));
                        }
                    }
                    if (vRecord != null && record.get(2).startsWith(">") && vBundleCommunitiesSCF.compareTo(vRecord) <= 0) {
                        logger.info((Object)("Ignoring the site update command for this version of AEM" + vBundleCommunitiesSCF.get()));
                        continue;
                    }
                    if (vRecord != null && record.get(2).startsWith("<") && vBundleCommunitiesSCF.compareTo(vRecord) > 0) {
                        logger.info((Object)("Ignoring the site update command for this version of AEM" + vBundleCommunitiesSCF.get()));
                        continue;
                    }
                    if (!Loader.isResourceAvailable(hostname, port, adminPassword, record.get(1))) {
                        logger.error((Object)("Can't update a Community Site " + record.get(1)));
                        continue;
                    }
                    logger.info((Object)("Updating a Community Site " + record.get(1)));
                    String siteConfig = Loader.doGet(hostname, port, record.get(1), "admin", adminPassword, null);
                    if (siteConfig == null) {
                        logger.error((Object)("Can't update a Community Site " + record.get(1)));
                        continue;
                    }
                    builder = MultipartEntityBuilder.create();
                    builder.setCharset(MIME.UTF8_CHARSET);
                    builder.addTextBody(":operation", "social:updateSite", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    builder.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    List<String> props = Arrays.asList("urlName", "theme", "moderators", "communitymanagers", "privilegedmembers", "createGroupPermission", "groupAdmin", CLOUDSERVICE_TWITTER, CLOUDSERVICE_FACEBOOK, CLOUDSERVICE_TRANSLATION, "translationProvider", "commonStoreLanguage");
                    try {
                        JSONObject siteprops = new JSONObject(siteConfig).getJSONObject("properties");
                        for (String prop : props) {
                            boolean willOverride = false;
                            for (int i = 3; i < record.size() - 1; i += 2) {
                                String name;
                                if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0 || !(name = record.get(i).trim()).equals(prop)) continue;
                                willOverride = true;
                            }
                            if (siteprops.has(prop) && !willOverride) {
                                Object propValue = siteprops.get(prop);
                                if (propValue instanceof JSONArray) {
                                    JSONArray propArray = (JSONArray)propValue;
                                    for (int i = 0; i < propArray.length(); ++i) {
                                        builder.addTextBody(prop, propArray.get(i).toString(), ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                                    }
                                    continue;
                                }
                                String value = propValue.toString();
                                if (isCommunities64orlater) {
                                    value = value.replaceAll("/libs/settings/", "");
                                }
                                builder.addTextBody(prop, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                                continue;
                            }
                            logger.info((Object)("Not adding property " + prop + " with override status " + willOverride));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                    boolean isValid = true;
                    for (int i = 3; i < record.size() - 1; i += 2) {
                        if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0) continue;
                        String name = record.get(i).trim();
                        String value = record.get(i + 1).trim();
                        if (name.equals("functions") && isCommunities64orlater) {
                            value = value.replaceAll("/etc/community/templates/functions/reference", "/libs/settings/community/templates/functions");
                            value = value.replaceAll("/etc/community/templates/groups/reference", "/libs/settings/community/templates/groups");
                            value = value.replaceAll("/etc/community/templates/groups/custom", "/conf/global/settings/community/templates/groups");
                        }
                        builder.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                        if (name.equals("functions") && value.indexOf("assignments") > 0 && vBundleCommunitiesEnablement == null) {
                            logger.info((Object)"Site update is not compatible with this version of AEM");
                            isValid = false;
                        }
                        if (!name.equals("functions") || value.indexOf("ideation") <= 0 || isCommunities61FP6orlater) continue;
                        logger.info((Object)"Site update is not compatible with this version of AEM");
                        isValid = false;
                    }
                    Loader.printPOST(builder.build());
                    if (!isValid) continue;
                    Loader.doPost(hostname, port, record.get(1), "admin", adminPassword, builder.build(), null);
                    continue;
                }
                if (action.equals(SITEPUBLISH) && record.get(1) != null) {
                    if (!Loader.isResourceAvailable(hostname, port, adminPassword, record.get(1))) {
                        logger.warn((Object)("Can't publish a Community Site " + record.get(1)));
                        continue;
                    }
                    logger.info((Object)("Publishing a Community Site " + record.get(1)));
                    if (port.equals(altport)) continue;
                    nameValuePairs2 = new ArrayList();
                    nameValuePairs2.add(new BasicNameValuePair("id", "nobot"));
                    nameValuePairs2.add(new BasicNameValuePair(":operation", "social:publishSite"));
                    nameValuePairs2.add(new BasicNameValuePair("nestedActivation", "true"));
                    nameValuePairs2.add(new BasicNameValuePair("path", record.get(1)));
                    Loader.doPost(hostname, port, "/communities/sites.html", "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs2), null);
                    Loader.doWaitPath(hostname, altport, adminPassword, record.get(1), maxretries);
                    continue;
                }
                if (action.equals(GROUPPUBLISH) && record.get(1) != null) {
                    if (port.equals(altport)) continue;
                    nameValuePairs2 = new ArrayList<BasicNameValuePair>();
                    nameValuePairs2.add(new BasicNameValuePair("id", "nobot"));
                    nameValuePairs2.add(new BasicNameValuePair(":operation", "social:publishCommunityGroup"));
                    nameValuePairs2.add(new BasicNameValuePair("nestedActivation", "true"));
                    nameValuePairs2.add(new BasicNameValuePair("path", record.get(1) + "/" + record.get(2)));
                    Loader.doPost(hostname, port, "/communities/communitygroups.html/" + record.get(1), "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs2), null);
                    continue;
                }
                if (action.equals(ACTIVATE) && record.get(1) != null) {
                    String activatePath = record.get(1);
                    if (isCommunities64orlater) {
                        activatePath = activatePath.replaceAll("/etc/cloudservices/(.*connect)/", "/conf/global/settings/cloudconfigs/");
                    }
                    if (!port.equals(altport) && Loader.isResourceAvailable(hostname, port, adminPassword, activatePath)) {
                        ArrayList<BasicNameValuePair> nameValuePairs4 = new ArrayList<BasicNameValuePair>();
                        nameValuePairs4.add(new BasicNameValuePair("cmd", "activate"));
                        nameValuePairs4.add(new BasicNameValuePair("path", activatePath));
                        Loader.doPost(hostname, port, (isCommunities64orlater ? "/libs" : "/etc") + "/replication/treeactivation.html", "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs4), null);
                        continue;
                    }
                    logger.warn((Object)"Not activating the requested path");
                    continue;
                }
                if (action.equals(TAG)) {
                    builder2 = MultipartEntityBuilder.create();
                    builder2.setCharset(MIME.UTF8_CHARSET);
                    builder2.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    for (int i = 1; i < record.size() - 1; i += 2) {
                        if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0 || record.get(i + 1).length() <= 0) continue;
                        String name = record.get(i).trim();
                        String value = record.get(i + 1).trim();
                        builder2.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    }
                    Loader.doPost(hostname, port, "/bin/tagcommand", "admin", adminPassword, builder2.build(), null);
                    continue;
                }
                if (action.equals(BADGE)) {
                    if (vBundleCommunitiesEnablement == null || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP3)) < 0) {
                        logger.info((Object)"Badging operations not available with this version of AEM");
                        continue;
                    }
                    nameValuePairs2 = Loader.buildNVP(hostname, port, adminPassword, null, record, 2, isCommunities64orlater);
                    String badgePath = record.get(1);
                    if (badgePath.startsWith("/etc") && (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP4)) == 0 || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) > 0)) {
                        badgePath = badgePath.replaceAll("/jcr:content", "");
                    }
                    if (isCommunities64orlater) {
                        badgePath = badgePath.replaceAll("/etc/community", "/conf/global/settings/community");
                    }
                    if (nameValuePairs2.size() > 2) {
                        for (int i = 0; i < nameValuePairs2.size(); ++i) {
                            String name = ((NameValuePair)nameValuePairs2.get(i)).getName();
                            String value = ((NameValuePair)nameValuePairs2.get(i)).getValue();
                            if (isCommunities64orlater) {
                                value = value.replaceAll("/etc/community/badging/images", "/libs/community/badging/images");
                                value = value.replaceAll("/etc/community", "community");
                            }
                            if (name.equals("badgeContentPath") && (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP4)) == 0 || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) > 0)) {
                                value = value.replaceAll("/jcr:content", "");
                            }
                            if (name.startsWith("thresholds") && (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP4)) == 0 || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) > 0)) {
                                value = value.replaceAll("/jcr:content(.*)", "");
                            }
                            if (name.equals("jcr:primaryType") && (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP4)) == 0 || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) > 0) && (value.equals("cq:PageContent") || value.equals("cq:Page"))) {
                                value = "nt:unstructured";
                            }
                            nameValuePairs2.set(i, new BasicNameValuePair(name, value));
                            if (!name.endsWith("Rules") || !value.contains("adv-") || vBundleCommunitiesAdvancedScoring != null) continue;
                            nameValuePairs2.remove(i--);
                        }
                    }
                    Loader.doPost(hostname, port, badgePath, "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs2), null);
                    continue;
                }
                if (action.equals(SITETEMPLATE) || record.get(0).equals(GROUPTEMPLATE)) {
                    builder2 = MultipartEntityBuilder.create();
                    builder2.setCharset(MIME.UTF8_CHARSET);
                    builder2.addTextBody(":operation", "social:create" + record.get(0), ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    builder2.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    boolean isValid = true;
                    for (int i = 2; i < record.size() - 1; i += 2) {
                        if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0) continue;
                        String name = record.get(i).trim();
                        String value = record.get(i + 1).trim();
                        if (name.equals("templateName") && (Loader.isResourceAvailable(hostname, port, adminPassword, "/etc/community/templates/sites/custom/" + Loader.title2name(value)) || Loader.isResourceAvailable(hostname, port, adminPassword, "/etc/community/templates/groups/custom/" + Loader.title2name(value)) || Loader.isResourceAvailable(hostname, port, adminPassword, "/conf/global/settings/community/templates/sites/" + Loader.title2name(value)) || Loader.isResourceAvailable(hostname, port, adminPassword, "/conf/global/settings/community/templates/groups/" + Loader.title2name(value)))) {
                            logger.info((Object)("Template " + value + " is already there"));
                            isValid = false;
                        }
                        if (name.equals("functions") && value.indexOf("assignments") > 0 && vBundleCommunitiesEnablement == null) {
                            logger.info((Object)("Template " + record.get(3) + " is not compatible with this version of AEM"));
                            isValid = false;
                        }
                        if (name.equals("functions") && value.indexOf("ideation") > 0 && !isCommunities61FP6orlater) {
                            logger.info((Object)("Template " + record.get(3) + " is not compatible with this version of AEM"));
                            isValid = false;
                        }
                        if (record.get(0).equals(GROUPTEMPLATE) && name.equals("functions") && value.indexOf("groups") > 0 && vBundleCommunitiesEnablement != null && vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) <= 0) {
                            logger.info((Object)("Group template " + record.get(3) + " is not compatible with this version of AEM"));
                            isValid = false;
                        }
                        if (name.equals("functions") && (value.indexOf("blog") > 0 || value.indexOf("calendar") > 0) && vBundleCommunitiesEnablement == null) {
                            logger.info((Object)("Template " + record.get(3) + " is not compatible with this version of AEM"));
                            isValid = false;
                        }
                        if (name.equals("functions") && isCommunities64orlater) {
                            value = value.replaceAll("/etc/community/templates/functions/reference", "/libs/settings/community/templates/functions");
                            value = value.replaceAll("/etc/community/templates/groups/reference", "/libs/settings/community/templates/groups");
                            value = value.replaceAll("/etc/community/templates/groups/custom", "/conf/global/settings/community/templates/groups");
                        }
                        builder2.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    }
                    if (!isValid) continue;
                    Loader.doPost(hostname, port, "/content.social.json", "admin", adminPassword, builder2.build(), null);
                    continue;
                }
                if (action.equals(GROUP) || record.get(0).equals(SUBGROUP)) {
                    int i;
                    if (action.equals(SUBGROUP) && !isCommunities61FP5orlater) {
                        logger.warn((Object)"Subgroups are not supported with this version of AEM Communities");
                        continue;
                    }
                    builder2 = MultipartEntityBuilder.create();
                    builder2.setCharset(MIME.UTF8_CHARSET);
                    builder2.addTextBody(":operation", "social:createCommunityGroup", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    builder2.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                    String urlName = null;
                    String groupType = null;
                    for (i = 3; i < record.size() - 1; i += 2) {
                        if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0) continue;
                        String name = record.get(i).trim();
                        String value = record.get(i + 1).trim();
                        if (isCommunities64orlater) {
                            value = value.replaceAll("/etc/community/templates/groups/custom", "/conf/global/settings/community/templates/groups");
                        }
                        if (value.equals("TRUE")) {
                            value = "true";
                        }
                        if (value.equals("FALSE")) {
                            value = "false";
                        }
                        if (name.equals("type")) {
                            groupType = value;
                        }
                        if (name.equals(IMAGE)) {
                            Loader.addBinaryBody(builder2, lIs, rr, IMAGE, csvfile, value);
                        } else {
                            builder2.addTextBody(name, value, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                        }
                        if (name.equals("urlName")) {
                            urlName = value;
                        }
                        if (!name.equals(ROOT)) continue;
                        Loader.doWaitPath(hostname, port, adminPassword, value, maxretries);
                    }
                    if (groupType != null && groupType.equals("Secret") && isCommunities61) continue;
                    Loader.doPost(hostname, port, record.get(1), Loader.getUserName(record.get(2)), Loader.getPassword(record.get(2), adminPassword), builder2.build(), null);
                    int n = i = record.get(1).indexOf("/jcr:content") > 0 ? record.get(1).indexOf("/jcr:content") : record.get(1).indexOf(".social.json");
                    if (urlName != null && i > 0) {
                        Loader.doWaitPath(hostname, port, adminPassword, record.get(1).substring(0, i) + "/" + urlName, maxretries);
                        continue;
                    }
                    logger.warn((Object)"Not waiting for Group to be fully available");
                    continue;
                }
                if (action.equals(SLINGDELETE)) {
                    String deletePath = record.get(1);
                    Loader.doDelete(hostname, port, deletePath, "admin", adminPassword);
                    continue;
                }
                if (action.equals(GROUPDELETE) && record.get(1) != null) {
                    ArrayList<NameValuePair> sitesNameValuePairs = new ArrayList<NameValuePair>();
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("path", "/content"));
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("1_property", "sling:resourceType"));
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("1_property.value", "social/console/components/hbs/sitecollection/site"));
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("1_property.operation", "like"));
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("p.limit", "-1"));
                    sitesNameValuePairs.add((NameValuePair)new BasicNameValuePair("p.hits", "full"));
                    String siteList = Loader.doGet(hostname, port, "/bin/querybuilder.json", "admin", adminPassword, sitesNameValuePairs);
                    ArrayList<String> orphanKeys = new ArrayList<String>();
                    ArrayList<NameValuePair> nameValuePairs5 = new ArrayList<NameValuePair>();
                    nameValuePairs5.add((NameValuePair)new BasicNameValuePair("type", "rep:Group"));
                    nameValuePairs5.add((NameValuePair)new BasicNameValuePair("p.limit", "-1"));
                    nameValuePairs5.add((NameValuePair)new BasicNameValuePair("p.hits", "full"));
                    String groupList = Loader.doGet(hostname, port, "/bin/querybuilder.json", "admin", adminPassword, nameValuePairs5);
                    JSONArray jsonArray = new JSONObject(groupList).getJSONArray("hits");
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String keyCommunity;
                        int indexUrlCommunity;
                        int indexStopCommunity;
                        String communityGroups;
                        int indexStartCommunity;
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        String groupPath = jsonObject.getString("jcr:path");
                        String groupName = jsonObject.getString("rep:authorizableId");
                        boolean deleteGroup = false;
                        if (groupName.startsWith(record.get(2)) && groupPath.startsWith(record.get(1))) {
                            deleteGroup = true;
                        }
                        if ((indexStartCommunity = groupPath.indexOf(communityGroups = "/home/groups/community/")) >= 0 && (indexStopCommunity = groupPath.indexOf("/", communityGroups.length() + indexStartCommunity)) > 0 && (indexUrlCommunity = (keyCommunity = groupPath.substring(communityGroups.length() + indexStartCommunity, indexStopCommunity)).indexOf("-")) > 0) {
                            String urlCommunity = keyCommunity.substring(0, indexUrlCommunity);
                            if (!siteList.contains(keyCommunity) && !siteList.contains("siteUrlName\":\"" + urlCommunity)) {
                                deleteGroup = true;
                                orphanKeys.add(keyCommunity);
                                orphanKeys.add("community-" + urlCommunity);
                            }
                        }
                        if (!deleteGroup) continue;
                        logger.info((Object)("Deleting orphan or desired group " + groupName));
                        ArrayList<BasicNameValuePair> groupDeleteValuePairs = new ArrayList<BasicNameValuePair>();
                        groupDeleteValuePairs.add(new BasicNameValuePair("deleteAuthorizable", groupName));
                        MultipartEntityBuilder builder3 = MultipartEntityBuilder.create();
                        builder3.setCharset(MIME.UTF8_CHARSET);
                        builder3.addTextBody("_charset_", "UTF-8", ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                        builder3.addTextBody("deleteAuthorizable", groupName, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                        Loader.doPost(hostname, port, groupPath, "admin", adminPassword, builder3.build(), null);
                    }
                    for (String key : orphanKeys) {
                        logger.info((Object)("Deleting folder /home/groups/community/" + key));
                        Loader.doDelete(hostname, port, "/home/groups/community/" + key, "admin", adminPassword);
                    }
                }
                if (action.equals(SITEDELETE) && record.get(1) != null) {
                    String siteConfig = Loader.doGet(hostname, port, record.get(1), "admin", adminPassword, null);
                    if (siteConfig == null) continue;
                    try {
                        String siteRoot = new JSONObject(siteConfig).getString(ROOT);
                        String urlName = new JSONObject(siteConfig).getString("urlName");
                        String siteId = new JSONObject(siteConfig).getString("siteId");
                        String resourcesRoot = new JSONObject(siteConfig).getString("siteAssetsPath");
                        if (siteRoot != null && urlName != null && siteId != null && resourcesRoot != null) {
                            Loader.doDelete(hostname, port, siteRoot + "/" + urlName, "admin", adminPassword);
                            Loader.doDelete(hostname, altport, siteRoot + "/" + urlName, "admin", adminPassword);
                            Loader.doDelete(hostname, port, resourcesRoot, "admin", adminPassword);
                            Loader.doDelete(hostname, altport, resourcesRoot, "admin", adminPassword);
                            Loader.doDelete(hostname, port, "/content/usergenerated/asi/jcr" + siteRoot + "/" + urlName, "admin", adminPassword);
                            Loader.doDelete(hostname, altport, "/content/usergenerated/asi/jcr" + siteRoot + "/" + urlName, "admin", adminPassword);
                            Loader.doDelete(hostname, port, "/home/groups/community-" + siteId, "admin", adminPassword);
                            Loader.doDelete(hostname, altport, "/home/groups/community-" + siteId, "admin", adminPassword);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                }
                if ((action.equals(GROUPMEMBERS) || record.get(0).equals(SITEMEMBERS)) && record.get(1) != null) {
                    String groupName = null;
                    if (action.equals(SITEMEMBERS)) {
                        String configurationPath = record.get(1);
                        Loader.doWaitPath(hostname, port, adminPassword, configurationPath, maxretries);
                        String siteConfig = Loader.doGet(hostname, port, configurationPath, "admin", adminPassword, null);
                        if (siteConfig == null) {
                            logger.error((Object)"Can't retrieve site configuration");
                            continue;
                        }
                        String siteId = null;
                        try {
                            siteId = new JSONObject(siteConfig).getString("siteId");
                        }
                        catch (Exception e) {
                            logger.warn((Object)"No site Id available");
                        }
                        String urlName = null;
                        try {
                            urlName = new JSONObject(siteConfig).getString("urlName");
                        }
                        catch (Exception e) {
                            logger.error((Object)"No site url available");
                            continue;
                        }
                        groupName = siteId != null ? "community-" + siteId + "-members" : "community-" + urlName + "-members";
                        logger.info((Object)("Site Member group name is " + groupName));
                    }
                    if (record.get(0).equals(GROUPMEMBERS)) {
                        groupName = record.get(1);
                    }
                    if (groupName == null) continue;
                    String groupList = Loader.doWait(hostname, port, "admin", adminPassword, groupName, maxretries);
                    if (groupList != null && groupList.indexOf("\"results\":1") > 0) {
                        logger.info((Object)("Group was found on " + port));
                        try {
                            JSONArray jsonArray = new JSONObject(groupList).getJSONArray("hits");
                            if (jsonArray.length() == 1) {
                                JSONObject jsonObject = jsonArray.getJSONObject(0);
                                String groupPath = jsonObject.getString("path");
                                logger.info((Object)("Group path is " + groupPath));
                                MultipartEntityBuilder builder4 = MultipartEntityBuilder.create();
                                builder4.setCharset(MIME.UTF8_CHARSET);
                                builder4.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                                List<NameValuePair> groupNameValuePairs = Loader.buildNVP(hostname, port, adminPassword, null, record, 2, isCommunities64orlater);
                                for (NameValuePair nameValuePair : groupNameValuePairs) {
                                    builder4.addTextBody(nameValuePair.getName(), nameValuePair.getValue(), ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                                }
                                Loader.doPost(hostname, port, groupPath + ".rw.userprops.html", "admin", adminPassword, builder4.build(), null);
                                continue;
                            }
                            logger.info((Object)"We have more than one match for a group with this name!");
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                        }
                        continue;
                    }
                    logger.warn((Object)("Group " + groupName + " cannot be updated as expected"));
                    continue;
                }
                if (action.equals(USERS)) {
                    String json = Loader.doGet(hostname, port, "/libs/granite/security/currentuser.json", Loader.getUserName(record.get(1)), Loader.getPassword(record.get(1), adminPassword), null);
                    if (json == null) continue;
                    try {
                        String home = new JSONObject(json).getString("home");
                        home = record.get(2).equals(PREFERENCES) ? home + "/preferences" : home + "/profile";
                        nameValuePairs = Loader.buildNVP(hostname, port, adminPassword, null, record, 3, isCommunities64orlater);
                        Loader.doPost(hostname, port, home, "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity((List)nameValuePairs), null);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                    continue;
                }
                if (action.equals(ASSETINSIGHTS) && record.size() > 1 && analytics != null) {
                    logger.info((Object)("Generating Assets Analytics for reportsuite " + analytics));
                    int impressions = new Random().nextInt(21) + 5;
                    for (int i = 0; i < impressions; ++i) {
                        Loader.doAssetsAnalytics(analytics, "event1", "list1", record.get(1).replace('|', ','), "o", "Asset Impression Event");
                    }
                    List<String> assetIds = Arrays.asList(record.get(1).split("\\|", -1));
                    for (String assetId : assetIds) {
                        int clicks = new Random().nextInt(5) + 2;
                        for (int i = 0; i < clicks; ++i) {
                            Loader.doAssetsAnalytics(analytics, "event2", "eVar4", assetId, "e", "Asset Click Event");
                        }
                    }
                    continue;
                }
                if (action.equals(CALENDAR) || action.equals(SLINGPOST) || action.equals(RATINGS) || action.equals(IDEATION) || action.equals(BLOG) || action.equals(JOURNAL) || action.equals(COMMENTS) || action.equals(REVIEWS) || action.equals(FILES) || action.equals(SUMMARY) || action.equals(ACTIVITIES) || action.equals(JOIN) || action.equals(FOLLOW) || action.equals(NOTIFICATION) || action.equals(NOTIFICATIONPREFERENCE) || action.equals(MESSAGE) || action.equals(ASSET) || action.equals(AVATAR) || action.equals(FOLDER) || action.equals(BADGEIMAGE) || action.equals(BADGEASSIGN) || action.equals(FRAGMENT) || action.equals(RESOURCE) || action.equals(LEARNING) || action.equals(QNA) || action.equals(FORUM)) {
                    int pos;
                    componentType = action;
                    url[0] = record.get(1);
                    urlLevel = 0;
                    if (!action.equals(SLINGPOST) && record.get(1) != null && !Loader.isResourceAvailable(hostname, port, adminPassword, Loader.getRootPath(record.get(1)))) {
                        ignoreUntilNextComponent = true;
                        continue;
                    }
                    ignoreUntilNextComponent = false;
                    if (!componentType.equals(SLINGPOST) && reset && (pos = record.get(1).indexOf("/jcr:content")) > 0) {
                        Loader.doDelete(hostname, port, "/content/usergenerated" + record.get(1).substring(0, pos), "admin", adminPassword);
                    }
                    if (!componentType.equals(SLINGPOST) && !configure) continue;
                    String postPath = record.get(1);
                    if (isCommunities64orlater) {
                        postPath = postPath.replaceAll("/etc/cloudservices/(.*connect)/", "/conf/global/settings/cloudconfigs/");
                    }
                    String configurePath = Loader.getConfigurePath(postPath);
                    logger.debug((Object)("Configuration path:" + configurePath));
                    nameValuePairs = Loader.buildNVP(hostname, port, adminPassword, record.get(1), record, 2, isCommunities64orlater);
                    if (nameValuePairs.size() > 2) {
                        int pos2;
                        int pos1 = configurePath.indexOf("/jcr:content");
                        if (pos1 > 0 && !Loader.isResourceAvailable(hostname, port, adminPassword, configurePath.substring(0, pos1))) continue;
                        if (postPath.equals("/bin/wcmcommand")) {
                            for (NameValuePair nvp : nameValuePairs) {
                                if (!nvp.getName().equals("template") || Loader.isResourceAvailable(hostname, port, adminPassword, nvp.getValue())) continue;
                                logger.warn((Object)"Requested template not found for page creation request");
                                continue block24;
                            }
                        }
                        if ((pos2 = configurePath.indexOf("configuration")) > 0 && !Loader.isResourceAvailable(hostname, port, adminPassword, configurePath)) continue;
                        int pos3 = configurePath.indexOf("analyticsCommunities");
                        if (pos3 > 0 && !Hostname.isReachable("www.adobe.com", "80")) {
                            logger.warn((Object)"Analytics cannot be imported since you appear to be offline");
                            continue;
                        }
                        Loader.doPost(hostname, port, componentType.equals(SLINGPOST) ? postPath : configurePath, "admin", adminPassword, (HttpEntity)new UrlEncodedFormEntity(nameValuePairs), null);
                    }
                    if (record.get(1).indexOf("system/console") <= 0) continue;
                    Loader.doSleep(10000L, "Waiting after a bundle change/restart");
                    Loader.doWait(hostname, port, "admin", adminPassword, "administrators", maxretries);
                    continue;
                }
                if (ignoreUntilNextComponent) {
                    logger.info((Object)"Ignoring this record because of unavailable component configuration");
                    continue;
                }
                if (record.get(1) == null || record.get(1).length() != 1) continue;
                if (Integer.parseInt(record.get(1)) > urlLevel) {
                    url[++urlLevel] = location;
                    logger.debug((Object)("Incrementing urlLevel to: " + urlLevel + ", with a new location:" + location));
                } else if (Integer.parseInt(record.get(1)) < urlLevel) {
                    urlLevel = Integer.parseInt(record.get(1));
                    logger.debug((Object)("Decrementing urlLevel to: " + urlLevel));
                }
                if (vBundleCommunitiesEnablement == null && !componentType.equals(FORUM) && !componentType.equals(FILES) && !componentType.equals(JOIN)) continue;
                String password = Loader.getPassword(record.get(0), adminPassword);
                String userName = Loader.getUserName(record.get(0));
                builder = MultipartEntityBuilder.create();
                builder.setCharset(MIME.UTF8_CHARSET);
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                List<NameValuePair> nameValuePairs6 = new ArrayList<NameValuePair>();
                if (!componentType.equals(RESOURCE) && !componentType.equals(LEARNING)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("id", "nobot"));
                }
                nameValuePairs6.add((NameValuePair)new BasicNameValuePair("_charset_", "UTF-8"));
                if (urlLevel == 0 && (componentType.equals(FORUM) || componentType.equals(FILES) || componentType.equals(QNA) || componentType.equals(IDEATION) || componentType.equals(BLOG) || componentType.equals(CALENDAR))) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("ugcUrl", Loader.slugify(record.get(2))));
                }
                if (componentType.equals(COMMENTS)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createComment"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(2)));
                }
                if (componentType.equals(FOLLOW)) {
                    if (vBundleCommunitiesNotifications != null && vBundleCommunitiesNotifications.compareTo(new Version("1.0.12")) < 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:follow"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("userId", "/social/authors/" + userName));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("followedId", "/social/authors/" + record.get(2)));
                    } else {
                        logger.info((Object)"Ignoring FOLLOW with this version of AEM Communities");
                        continue;
                    }
                }
                if (componentType.equals(NOTIFICATION)) {
                    if (vBundleCommunitiesNotifications != null && vBundleCommunitiesNotifications.compareTo(new Version("1.0.11")) > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:updatesubscriptions"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("types", "following"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("types", "notification"));
                        if (vBundleCommunitiesNotifications.compareTo(new Version(ENABLEMENT62)) > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("types", "subscription"));
                        }
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("states", record.get(2).toLowerCase()));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("states", record.get(3).toLowerCase()));
                        if (vBundleCommunitiesNotifications.compareTo(new Version(ENABLEMENT62)) > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("states", record.get(4).toLowerCase()));
                        }
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subscribedId", record.get(5)));
                    } else {
                        logger.info((Object)"Ignoring NOTIFICATION with this version of AEM Communities");
                        continue;
                    }
                }
                if (componentType.equals(NOTIFICATIONPREFERENCE) && vBundleCommunitiesNotifications != null && vBundleCommunitiesNotifications.compareTo(new Version("1.0.11")) > 0) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:updateUserPreference"));
                    List<NameValuePair> otherNameValuePairs = Loader.buildNVP(hostname, port, adminPassword, null, record, 2, isCommunities64orlater);
                    nameValuePairs6.addAll(otherNameValuePairs);
                }
                if (componentType.equals(AVATAR)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:changeAvatar"));
                    String userJson = Loader.doGet(hostname, port, "/libs/granite/security/currentuser.json", Loader.getUserName(record.get(0)), Loader.getPassword(record.get(0), adminPassword), null);
                    userHome = "";
                    if (userJson != null) {
                        try {
                            userHome = new JSONObject(userJson).getString("home");
                        }
                        catch (Exception e) {
                            logger.error((Object)("Couldn't figure out home folder for user " + record.get(0)));
                        }
                    }
                }
                if (componentType.equals(BADGEASSIGN)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:assignBadge"));
                    String value = record.get(3);
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP4)) == 0 || vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62)) > 0) {
                        value = value.replaceAll("/jcr:content", "");
                    }
                    if (isCommunities64orlater) {
                        value = value.replaceAll("/etc/community", "/libs/community");
                    }
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("badgeContentPath", value));
                    String userJson = Loader.doGet(hostname, altport, "/libs/granite/security/currentuser.json", Loader.getUserName(record.get(2)), Loader.getPassword(record.get(2), adminPassword), null);
                    userHome = "";
                    if (userJson != null) {
                        try {
                            userHome = new JSONObject(userJson).getString("home");
                        }
                        catch (Exception e) {
                            logger.error((Object)("Couldn't figure out home folder for user " + record.get(2)));
                        }
                    }
                }
                if (componentType.equals(BADGEIMAGE)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createBadge"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("jcr:title", record.get(2)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("badgeDisplayName", record.get(3)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("badgeDescription", record.get(5)));
                    Loader.addBinaryBody(builder, lIs, rr, "badgeImage", csvfile, record.get(4));
                }
                if (componentType.equals(JOIN)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:joinCommunityGroup"));
                    int pos = url[0].indexOf("/configuration.social.json");
                    if (pos <= 0) continue;
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("path", url[0].substring(0, pos) + ".html"));
                }
                if (componentType.equals(MESSAGE)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("to", "/social/authors/" + record.get(2)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("userId", "/social/authors/" + record.get(2)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("toId", ""));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("serviceSelector", "/bin/community"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("redirectUrl", "../messaging.html"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("attachmentPaths", ""));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createMessage"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", record.get(3)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("content", record.get(4)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("sendMail", "Sending..."));
                }
                if (componentType.equals(FORUM)) {
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createForumPost"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", subComponentType));
                    } else if (subComponentType.equals(UGCREPLY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createForumPost"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", ""));
                    }
                }
                if (componentType.equals(FILES)) {
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createFileLibraryFolder"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("name", subComponentType));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                    } else if (subComponentType.equals(UGCREPLY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createComment"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                    }
                }
                if (componentType.equals(QNA)) {
                    if (vBundleCommunitiesEnablement == null) {
                        logger.info((Object)"QnAs are not compatible with this version of AEM");
                        continue;
                    }
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createQnaPost"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", subComponentType));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                    } else if (subComponentType.equals(UGCREPLY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createQnaPost"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", ""));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                    }
                }
                if (componentType.equals(JOURNAL) || componentType.equals(BLOG)) {
                    if (vBundleCommunitiesEnablement == null) {
                        logger.info((Object)"Blogs are not compatible with this version of AEM");
                        continue;
                    }
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createJournalComment"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", subComponentType));
                        StringBuffer message = new StringBuffer("<p>" + record.get(3) + "</p>");
                        for (int i = 6; i < record.size(); ++i) {
                            if (record.get(i).length() <= 0) continue;
                            if (record.get(i).startsWith("isDraft")) {
                                nameValuePairs6.add((NameValuePair)new BasicNameValuePair("isDraft", "true"));
                                continue;
                            }
                            message.append("<p>" + record.get(i) + "</p>");
                        }
                        if (record.get(5).length() > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags", record.get(5)));
                        }
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", message.toString()));
                    } else if (subComponentType.equals(UGCREPLY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createJournalComment"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", ""));
                    }
                }
                if (componentType.equals(IDEATION)) {
                    if (!isCommunities61FP6orlater) {
                        logger.info((Object)"Ideas are not compatible with this version of AEM");
                        continue;
                    }
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createIdeationComment"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", subComponentType));
                        StringBuffer message = new StringBuffer("");
                        for (int i = 6; i < record.size(); ++i) {
                            if (record.get(i).length() <= 0) continue;
                            message.append("<p>" + record.get(i) + "</p>");
                        }
                        if (record.get(5).equals("TRUE")) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("isDraft", "true"));
                        } else {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("isDraft", "false"));
                        }
                        if (record.get(3).length() > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags", record.get(5)));
                        }
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", message.toString()));
                    } else if (subComponentType.equals(UGCREPLY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createIdeationComment"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", ""));
                    }
                }
                if (urlLevel >= 1 && !subComponentType.equals(UGCREPLY)) {
                    if (subComponentType.equals(UGCPIN) && !isCommunities61FP5orlater) {
                        logger.warn((Object)"This feature is not supported by this version of AEM");
                        continue;
                    }
                    if ((subComponentType.equals(UGCFEATURE) || subComponentType.equals(UGCLIKE)) && !isCommunities61FP6orlater) {
                        logger.warn((Object)"This feature is not supported by this version of AEM");
                        continue;
                    }
                    if (subComponentType.equals(UGCANSWER)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:selectAnswer"));
                    }
                    if (subComponentType.equals(UGCDENY)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:deny"));
                    }
                    if (subComponentType.equals(UGCFLAG)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:flag"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("social:flagformtext", "Marked as spam"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("social:doFlag", "true"));
                    }
                    if (subComponentType.equals(UGCFEATURE)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:featured"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("social:markFeatured", "true"));
                    }
                    if (subComponentType.equals(UGCPIN)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:pin"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("social:doPin", "true"));
                    }
                    if (subComponentType.equals(UGCUPVOTE)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:postTallyResponse"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("response", "1"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tallyType", "Voting"));
                    }
                    if (subComponentType.equals(UGCDOWNVOTE)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:postTallyResponse"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("response", "-1"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tallyType", "Voting"));
                    }
                    if (subComponentType.equals(UGCLIKE)) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:postTallyResponse"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("response", "1"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tallyType", "Liking"));
                    }
                }
                if (componentType.equals(REVIEWS)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(2)));
                    if (urlLevel == 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createReview"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("ratings", record.get(3)));
                        if (record.size() > 4 && record.get(4).length() > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("scf:included", record.get(4)));
                            if (record.size() > 5 && record.get(5).length() > 0) {
                                nameValuePairs6.add((NameValuePair)new BasicNameValuePair("scf:resourceType", record.get(5)));
                            } else {
                                nameValuePairs6.add((NameValuePair)new BasicNameValuePair("scf:resourceType", "social/reviews/components/hbs/reviews"));
                            }
                        }
                    } else {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createComment"));
                    }
                }
                if (componentType.equals(RATINGS)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:postTallyResponse"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tallyType", "Rating"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("response", subComponentType));
                }
                if (componentType.equals(ASSET) && record.get(4).length() > 0) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("fileName", record.get(4)));
                }
                if (componentType.equals(FOLDER)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("./jcr:content/jcr:title", record.get(2)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":name", record.get(3)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("./jcr:primaryType", "sling:Folder"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("./jcr:content/jcr:primaryType", "nt:unstructured"));
                }
                if (componentType.equals(FRAGMENT)) {
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("template", "/libs/settings/dam/cfm/templates/simple/jcr:content"));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("name", record.get(2)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("parentPath", record.get(3)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("./jcr:title", record.get(4)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("description", record.get(5)));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("author", record.get(0)));
                    if (record.get(5).length() > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags", record.get(6)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags@TypeHint", "String[]"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags@Delete", ""));
                    }
                }
                if (componentType.equals(RESOURCE)) {
                    if (rr == null) {
                        File attachment = new File(csvfile.substring(0, csvfile.indexOf(".csv")) + File.separator + record.get(2));
                        if (!attachment.exists()) {
                            logger.error((Object)"Resource cannot be created as the referenced file is missing on the file system");
                            continue;
                        }
                    } else {
                        Resource res = rr.getResource(csvfile + "/attachments/" + record.get(2) + "/jcr:content");
                        if (res == null) {
                            logger.error((Object)("A non existent resource named " + record.get(2) + "was referenced"));
                            continue;
                        }
                    }
                    String createResourceOpName = "se:createResource";
                    String enablementType = "social/enablement/components/hbs/resource";
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP2)) > 0) {
                        createResourceOpName = "social:createResource";
                    }
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        createResourceOpName = "social:createEnablementResourceModel";
                    }
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", createResourceOpName));
                    List<NameValuePair> otherNameValuePairs = Loader.buildNVP(hostname, port, adminPassword, null, record, 10, isCommunities64orlater);
                    nameValuePairs6.addAll(otherNameValuePairs);
                    if (vBundleCommunitiesSCORM == null) {
                        nameValuePairs6.remove("add-learners");
                        nameValuePairs6.remove("deltaList");
                        logger.warn((Object)"SCORM not configured on this instance, not assigning a resource");
                    }
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP2)) > 0) {
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "add-learners");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-author");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-contact");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-expert");
                    }
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("sling:resourceType", "social/enablement/components/hbs/resource/model"));
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "add-learners", "resource-assignees");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "jcr:title", "resource-name");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "resourceTags", "resource-tags");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "id", "resource-uid");
                        enablementType = "resource";
                    }
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("enablement-type", enablementType));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("site", url[0]));
                    if (record.get(3).length() > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("cover-image", Loader.doThumbnail(rr, lIs, hostname, port, adminPassword, csvfile, record.get(3), record.get(7), maxretries)));
                    } else {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("cover-image", ""));
                    }
                    String assetFileName = record.get(2);
                    int assetFileNamePos = assetFileName.indexOf(".mp4");
                    if (assetFileNamePos > 0 && minimize) {
                        assetFileName = assetFileName.substring(0, assetFileNamePos) + ".jpg";
                    }
                    if (assetFileName.endsWith(".zip") && noenablement) {
                        logger.info((Object)"Not processing a SCORM resource for this scenario");
                        continue;
                    }
                    String coverPath = "/content/dam/resources/" + record.get(7) + "/" + record.get(2) + "/jcr:content/renditions/cq5dam.thumbnail.319.319.png";
                    String coverSource = "dam";
                    String assets = "[{\"cover-img-path\":\"" + coverPath + "\",\"thumbnail-source\":\"" + coverSource + "\",\"asset-category\":\"enablementAsset:dam\",\"resource-asset-name\":null,\"state\":\"A\",\"asset-path\":\"/content/dam/resources/" + record.get(7) + "/" + assetFileName + "\"}]";
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("assets", assets));
                    if (assetFileName.endsWith(".zip")) {
                        Loader.doWaitPath(hostname, port, adminPassword, "/content/dam/resources/" + record.get(7) + "/" + record.get(2) + "/output", maxretries);
                    }
                }
                if (componentType.equals(LEARNING)) {
                    if (vBundleCommunitiesSCORM == null || noenablement) {
                        logger.info((Object)"Ignoring a learning path");
                        continue;
                    }
                    String createResourceOpName = "se:editLearningPath";
                    String enablementType = "social/enablement/components/hbs/learningpath";
                    String resourceList = "learningpath-items";
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP3)) > 0) {
                        createResourceOpName = "social:editLearningPath";
                    }
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        createResourceOpName = "social:createEnablementLearningPathModel";
                    }
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", createResourceOpName));
                    List<NameValuePair> otherNameValuePairs = Loader.buildNVP(hostname, port, adminPassword, null, record, 10, isCommunities64orlater);
                    nameValuePairs6.addAll(otherNameValuePairs);
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP3)) > 0) {
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "add-learners");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-author");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-contact");
                        nameValuePairs6 = Loader.convertArrays(nameValuePairs6, "resource-expert");
                    }
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("sling:resourceType", "social/enablement/components/hbs/model/learningpath"));
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "add-learners", "resource-assignees");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "jcr:title", "resource-name");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "resourceTags", "resource-tags");
                        nameValuePairs6 = Loader.convertKeyName(nameValuePairs6, "id", "resource-uid");
                        enablementType = "learningpath";
                        resourceList = "resourcelist";
                    }
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("enablement-type", enablementType));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair("site", url[0]));
                    if (record.get(3).length() > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair(vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP3)) > 0 ? "cover-image" : "card-image", Loader.doThumbnail(rr, lIs, hostname, port, adminPassword, csvfile, record.get(3), record.get(7), maxretries)));
                    }
                    StringBuffer assets = new StringBuffer("[");
                    if (learningpaths.get(record.get(2)) != null) {
                        assets.append("\"");
                        ArrayList paths = (ArrayList)learningpaths.get(record.get(2));
                        int i = 0;
                        for (String path : paths) {
                            assets.append("{\\\"type\\\":\\\"linked-resource\\\",\\\"path\\\":\\\"");
                            assets.append(path);
                            assets.append("\\\"}");
                            if (i++ >= paths.size() - 1) continue;
                            assets.append("\",\"");
                        }
                        assets.append("\"");
                    } else {
                        logger.warn((Object)"No asset for this learning path");
                    }
                    assets.append("]");
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(resourceList, assets.toString()));
                }
                if (componentType.equals(CALENDAR)) {
                    if (vBundleCommunitiesEnablement == null) {
                        logger.info((Object)"Calendars are not compatible with this version of AEM");
                        continue;
                    }
                    String startDate = Loader.computeDate(record.get(5), record.get(7));
                    String endDate = Loader.computeDate(record.get(6), record.get(7));
                    nameValuePairs6.add((NameValuePair)new BasicNameValuePair(":operation", "social:createEvent"));
                    if (vBundleCommunitiesCalendar != null && vBundleCommunitiesCalendar.compareTo(new Version("1.2.29")) > 0) {
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("subject", record.get(2)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("message", record.get(3)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("location", record.get(4)));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags", ""));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("address", ""));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("isDate", "false"));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("start", startDate));
                        nameValuePairs6.add((NameValuePair)new BasicNameValuePair("end", endDate));
                        if (record.size() > 9 && record.get(9).length() > 0) {
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("tags", record.get(9)));
                        }
                        if (record.size() > 8 && record.get(8).length() > 0) {
                            Loader.addBinaryBody(builder, lIs, rr, "coverimage", csvfile, record.get(8));
                        }
                    } else {
                        try {
                            JSONObject event = new JSONObject();
                            event.accumulate("subject", (Object)record.get(2));
                            event.accumulate("message", (Object)record.get(3));
                            event.accumulate("location", (Object)record.get(4));
                            event.accumulate("tags", (Object)"");
                            event.accumulate("undefined", (Object)"update");
                            event.accumulate("start", (Object)startDate);
                            event.accumulate("end", (Object)endDate);
                            nameValuePairs6.add((NameValuePair)new BasicNameValuePair("event", event.toString()));
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage());
                        }
                    }
                }
                for (NameValuePair nameValuePair : nameValuePairs6) {
                    builder.addTextBody(nameValuePair.getName(), nameValuePair.getValue(), ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
                }
                if ((componentType.equals(ASSET) || componentType.equals(AVATAR) || componentType.equals(FORUM) || componentType.equals(IDEATION) || componentType.equals(QNA) || componentType.equals(JOURNAL) || componentType.equals(BLOG)) && record.size() > 4 && record.get(4).length() > 0) {
                    Loader.addBinaryBody(builder, lIs, rr, IMAGE, csvfile, record.get(4));
                }
                HashMap<String, String> elements = new HashMap<String, String>();
                String jsonElement = "location";
                String referrer = null;
                if (componentType.equals(RESOURCE) && vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP2)) <= 0) {
                    jsonElement = "changes/argument";
                }
                if (componentType.equals(LEARNING) && vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT61FP3)) <= 0) {
                    jsonElement = "path";
                }
                if (componentType.equals(RESOURCE) || componentType.equals(LEARNING)) {
                    Loader.printPOST(builder.build());
                }
                if (!(componentType.equals(ASSET) || componentType.equals(BADGEASSIGN) || componentType.equals(MESSAGE) || componentType.equals(AVATAR))) {
                    elements.put(jsonElement, "");
                    elements.put("response/resourceType", "");
                    elements.put("response/id", "");
                }
                if (componentType.equals(ASSET)) {
                    elements.put("location", "");
                }
                int returnCode = Loader.doPost(hostname, port, Loader.getPostURL(componentType, subComponentType, url[urlLevel], userHome), userName, password, builder.build(), elements, null);
                if (!componentType.equals(ASSET) && !componentType.equals(AVATAR)) {
                    location = (String)elements.get(jsonElement);
                    referrer = (String)elements.get("response/id");
                    if (Integer.parseInt(record.get(1)) == 0) {
                        analyticsPagePath = location;
                        resourceType = (String)elements.get("response/resourceType");
                    }
                }
                if (componentType.equals(ASSET) && returnCode < 400) {
                    Loader.doWaitAssetCompleted(hostname, port, adminPassword, (String)elements.get("location"), maxretries);
                    Loader.doWaitWorkflowsCompleted(hostname, port, adminPassword, "asset", maxretries);
                }
                if (componentType.equals(FRAGMENT)) {
                    ArrayList<BasicNameValuePair> fragmentNameValuePairs = new ArrayList<BasicNameValuePair>();
                    fragmentNameValuePairs.add(new BasicNameValuePair("contentType", "text/html"));
                    StringBuffer message = new StringBuffer("<p>" + record.get(7) + "</p>");
                    if (record.size() > 8) {
                        for (int i = 8; i < record.size(); ++i) {
                            if (record.get(i).length() <= 0) continue;
                            message.append("<p>" + record.get(i) + "</p>");
                        }
                    }
                    fragmentNameValuePairs.add(new BasicNameValuePair("content", message.toString()));
                    Loader.doPost(hostname, port, record.get(3) + "/" + record.get(2) + ".cfm.content.json", userName, password, (HttpEntity)new UrlEncodedFormEntity(fragmentNameValuePairs), null);
                }
                if (componentType.equals(RESOURCE) && record.get(5).length() > 0 && location != null) {
                    if (learningpaths.get(record.get(5)) == null) {
                        learningpaths.put(record.get(5), new ArrayList());
                    }
                    logger.info((Object)("Adding resource to Learning path: " + record.get(5)));
                    ArrayList locations = (ArrayList)learningpaths.get(record.get(5));
                    locations.add(location);
                    learningpaths.put(record.get(5), locations);
                }
                if (componentType.equals(LEARNING) && !port.equals(altport) && location != null && vBundleCommunitiesSCORM != null) {
                    ArrayList<BasicNameValuePair> publishNameValuePairs = new ArrayList<BasicNameValuePair>();
                    String publishOpName = "se:publishEnablementContent";
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        publishOpName = "social:publishEnablementLearningPathModel";
                    }
                    publishNameValuePairs.add(new BasicNameValuePair(":operation", publishOpName));
                    publishNameValuePairs.add(new BasicNameValuePair("replication-action", "activate"));
                    logger.info((Object)("Publishing a learning path from: " + location));
                    Loader.doPost(hostname, port, location, userName, password, (HttpEntity)new UrlEncodedFormEntity(publishNameValuePairs), null);
                    Loader.doWaitPath(hostname, altport, adminPassword, location, maxretries);
                    ArrayList paths = (ArrayList)learningpaths.get(record.get(2));
                    for (String path : paths) {
                        Loader.doDecorate(hostname, altport, adminPassword, path, record, analytics, sitePagePath, vBundleCommunitiesEnablement);
                    }
                }
                if (componentType.equals(RESOURCE) && !port.equals(altport) && location != null && !location.equals("")) {
                    Loader.doWaitWorkflowsCompleted(hostname, port, adminPassword, "resource", maxretries);
                    String resourcePath = "/assets/asset";
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        resourcePath = "/se_assets/se_primary";
                    }
                    Loader.doWaitPath(hostname, port, adminPassword, location + resourcePath, maxretries);
                    if (record.get(2).indexOf(".zip") > 0) {
                        Loader.doWaitPath(hostname, port, adminPassword, location + resourcePath + "/" + record.get(2) + "/output", maxretries);
                        Loader.doSleep(10000L, "Processing a SCORM resource");
                    }
                    Loader.doWaitWorkflowsCompleted(hostname, port, adminPassword, "resource", maxretries);
                    ArrayList<BasicNameValuePair> publishNameValuePairs = new ArrayList<BasicNameValuePair>();
                    String publishOpName = "se:publishEnablementContent";
                    if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) > 0) {
                        publishOpName = "social:publishEnablementResourceModel";
                    }
                    publishNameValuePairs.add(new BasicNameValuePair(":operation", publishOpName));
                    publishNameValuePairs.add(new BasicNameValuePair("replication-action", "activate"));
                    logger.info((Object)("Publishing a Resource from: " + location));
                    Loader.doPost(hostname, port, location, userName, password, (HttpEntity)new UrlEncodedFormEntity(publishNameValuePairs), null);
                    Loader.doWaitPath(hostname, altport, adminPassword, location, maxretries);
                    logger.info((Object)"Decorating the resource with comments and ratings");
                    Loader.doDecorate(hostname, altport, adminPassword, location, record, analytics, sitePagePath, vBundleCommunitiesEnablement);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -21);
                    ArrayList<BasicNameValuePair> publishDateNameValuePairs = new ArrayList<BasicNameValuePair>();
                    publishDateNameValuePairs.add(new BasicNameValuePair("se_date-published", dateFormat.format(cal.getTime())));
                    logger.info((Object)("Setting the publish date for a resource at: " + location));
                    Loader.doPost(hostname, port, location, userName, password, (HttpEntity)new UrlEncodedFormEntity(publishDateNameValuePairs), null);
                }
                if (analytics != null && referrer != null) {
                    logger.info((Object)("Component type: " + componentType + ", Analytics page path: " + analyticsPagePath + ", referrer: " + referrer));
                    logger.info((Object)("Analytics: " + analytics + ", resourceType: " + resourceType + ", sitePagePath: " + sitePagePath + ", userName: " + userName));
                    if (analyticsPagePath != null && (componentType.equals(FORUM) || componentType.equals(FILES) || componentType.equals(QNA) || componentType.equals(BLOG) || componentType.equals(IDEATION) || componentType.equals(CALENDAR))) {
                        logger.debug((Object)("level: " + Integer.parseInt(record.get(1))));
                        if (Integer.parseInt(record.get(1)) == 0) {
                            int views = new Random().nextInt(21) + 10;
                            for (int i = 0; i < views; ++i) {
                                Loader.doUGCAnalytics(analytics, "event11", analyticsPagePath, resourceType, sitePagePath, userName, referrer);
                            }
                        } else {
                            Loader.doUGCAnalytics(analytics, "event13", analyticsPagePath, resourceType, sitePagePath, userName, referrer);
                        }
                    }
                }
                for (InputStream is : lIs) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static void addBinaryBody(MultipartEntityBuilder builder, LinkedList<InputStream> lIs, ResourceResolver rr, String field, String csvfile, String value) {
        if (rr == null) {
            File attachment = new File(csvfile.substring(0, csvfile.indexOf(".csv")) + File.separator + value);
            if (attachment.exists()) {
                logger.info((Object)("Adding file named " + value + " to POST"));
                builder.addBinaryBody(field, attachment, Loader.getContentType(value), attachment.getName());
            } else {
                attachment = new File(csvfile.substring(0, csvfile.lastIndexOf("/")) + File.separator + "attachments" + File.separator + value);
                if (attachment.exists()) {
                    builder.addBinaryBody(field, attachment, Loader.getContentType(value), attachment.getName());
                } else {
                    logger.error((Object)("A non existent resource named " + value + " was referenced"));
                }
            }
        } else {
            Resource res = rr.getResource(csvfile + "/attachments/" + value + "/jcr:content");
            if (res != null) {
                logger.info((Object)("Adding resource named " + value + " to POST"));
                InputStream is = (InputStream)res.adaptTo(InputStream.class);
                lIs.add(is);
                builder.addBinaryBody(field, is, Loader.getContentType(value), value);
            } else {
                logger.error((Object)("A non existent resource named " + value + " was referenced"));
            }
        }
    }

    private static String getPostURL(String componentType, String subComponentType, String urlLevel, String userHome) {
        String postURL = urlLevel;
        if (componentType.equals(AVATAR)) {
            postURL = urlLevel + userHome + "/profile";
        }
        if (componentType.equals(BADGEASSIGN)) {
            postURL = userHome + "/profile.social.json";
        }
        if (subComponentType.equals(UGCLIKE) || subComponentType.equals(UGCUPVOTE) || subComponentType.equals(UGCDOWNVOTE)) {
            int pos = postURL.indexOf(".social.json");
            postURL = pos > 0 ? postURL.substring(0, pos) + "/voting.social.json" : postURL + "/voting.social.json";
        }
        return postURL;
    }

    private static String getUserName(String record) {
        String userName = record;
        int pass = userName.indexOf("/");
        if (pass > 0) {
            userName = userName.substring(0, pass);
        }
        return userName;
    }

    private static String getPassword(String record, String adminPassword) {
        String defaultPassword = PASSWORD;
        if (Loader.getUserName(record).equals("admin")) {
            return adminPassword;
        }
        int pass = record.indexOf("/");
        if (pass > 0) {
            return record.substring(pass + 1);
        }
        return defaultPassword;
    }

    private static String getRootPath(String record) {
        String rootPath = Loader.getConfigurePath(record);
        int jcr = rootPath.indexOf("/jcr:content");
        if (jcr > 0) {
            rootPath = rootPath.substring(0, jcr);
        }
        if ((jcr = rootPath.indexOf("_jcr_content")) > 0) {
            rootPath = rootPath.substring(0, jcr);
        }
        return rootPath;
    }

    private static String getConfigurePath(String record) {
        String configurePath = record;
        int json = configurePath.indexOf(".social.json");
        if (json > 0) {
            configurePath = configurePath.substring(0, json);
        }
        return configurePath;
    }

    private static void doSleep(long ms, String message) {
        try {
            logger.info((Object)("Waiting " + ms + " milliseconds: " + message));
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static String doThumbnail(ResourceResolver rr, LinkedList<InputStream> lIs, String hostname, String port, String adminPassword, String csvfile, String filename, String sitename, int maxretries) {
        if (filename == null || filename.equals("")) {
            return null;
        }
        String pathToFile = "/content/dam/resources/resource-thumbnails/" + sitename + "/" + filename;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(MIME.UTF8_CHARSET);
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        Loader.addBinaryBody(builder, lIs, rr, IMAGE, csvfile, filename);
        builder.addTextBody("fileName", filename, ContentType.create((String)"text/plain", (Charset)MIME.UTF8_CHARSET));
        logger.info((Object)("Posting file for thumbnails with name: " + filename));
        Loader.doPost(hostname, port, pathToFile, "admin", adminPassword, builder.build(), null);
        Loader.doWaitWorkflowsCompleted(hostname, port, adminPassword, "thumbnail", maxretries);
        return pathToFile + "/file";
    }

    private static String computeDate(String date, String padding) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, Integer.parseInt(padding));
        date = date.replaceAll("YYYY", Integer.toString(calendar.get(1)));
        date = date.replaceAll("MM", Integer.toString(1 + calendar.get(2)));
        if (date.indexOf("DD") > 0 && padding != null) {
            date = date.replaceAll("DD", Integer.toString(calendar.get(5)));
        }
        logger.debug((Object)("Computed date and time is " + date));
        return date;
    }

    private static ContentType getContentType(String fileName) {
        ContentType ct = ContentType.MULTIPART_FORM_DATA;
        if (fileName.indexOf(".mp4") > 0) {
            ct = ContentType.create((String)"video/mp4", (Charset)MIME.UTF8_CHARSET);
        } else if (fileName.indexOf(".jpg") > 0 || fileName.indexOf(".jpeg") > 0) {
            ct = ContentType.create((String)"image/jpeg", (Charset)MIME.UTF8_CHARSET);
        } else if (fileName.indexOf(".png") > 0) {
            ct = ContentType.create((String)"image/png", (Charset)MIME.UTF8_CHARSET);
        } else if (fileName.indexOf(".pdf") > 0) {
            ct = ContentType.create((String)"application/pdf", (Charset)MIME.UTF8_CHARSET);
        } else if (fileName.indexOf(".css") > 0) {
            ct = ContentType.create((String)"text/css", (Charset)MIME.UTF8_CHARSET);
        } else if (fileName.indexOf(".zip") > 0) {
            ct = ContentType.create((String)"application/zip", (Charset)MIME.UTF8_CHARSET);
        }
        return ct;
    }

    private static void doDecorate(String hostname, String altport, String adminPassword, String location, CSVRecord record, String analytics, String rootPath, Version vBundleCommunitiesEnablement) {
        String resourceJson = Loader.doGet(hostname, altport, location + ".social.json", "admin", adminPassword, null);
        try {
            JSONObject resourceJsonObject = new JSONObject(resourceJson);
            String resourceRatingsEndpoint = location + "/se_social/se_ratings.social.json";
            String resourceCommentsEndpoint = location + "/se_social/se_discussion.social.json";
            String assetPath = "assetProperties";
            if (vBundleCommunitiesEnablement.compareTo(new Version(ENABLEMENT62FP1)) <= 0) {
                resourceRatingsEndpoint = resourceJsonObject.getString("ratingsEndPoint") + ".social.json";
                resourceCommentsEndpoint = resourceJsonObject.getString("commentsEndPoint") + ".social.json";
            } else {
                assetPath = "primaryAsset";
            }
            String resourceID = resourceJsonObject.getString("id");
            String resourceType = resourceJsonObject.getJSONObject(assetPath).getString("type");
            String referer = "http://" + hostname + ":" + altport + rootPath + "/" + record.get(7) + "/en" + (record.get(9).length() > 0 ? "/" + record.get(9) : "") + ".resource.html" + resourceID;
            for (int i = 0; i < record.size() - 1; ++i) {
                if (record.get(i) == null || record.get(i + 1) == null || !record.get(i).equals("deltaList")) continue;
                JSONObject enrolledJsonObject = new JSONObject(record.get(i + 1));
                Iterator iter = enrolledJsonObject.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    logger.info((Object)("New Resource Enrollee: " + key));
                    String isGroup = Loader.doWait(hostname, altport, "admin", adminPassword, key, 1);
                    if (isGroup == null) {
                        if (Math.random() < 0.9) {
                            Loader.doAnalytics(analytics, "event11", referer, resourceID, resourceType);
                        }
                        if (Math.random() < 0.75 && resourceType.equals("video/mp4")) {
                            Loader.doAnalytics(analytics, "event2", referer, resourceID, resourceType);
                        }
                        if (Math.random() < 0.5) {
                            Loader.doRatings(hostname, altport, adminPassword, key, resourceRatingsEndpoint, referer, resourceID, resourceType, analytics);
                        }
                        if (!(Math.random() < 0.35)) continue;
                        Loader.doComments(hostname, altport, adminPassword, key, resourceCommentsEndpoint, referer, resourceID, resourceType, analytics);
                        continue;
                    }
                    ArrayList<NameValuePair> groupNameValuePairs = new ArrayList<NameValuePair>();
                    groupNameValuePairs.add((NameValuePair)new BasicNameValuePair("groupId", key));
                    groupNameValuePairs.add((NameValuePair)new BasicNameValuePair("includeSubGroups", "true"));
                    String memberList = Loader.doGet(hostname, altport, "/content/community-components/en/communitygroupmemberlist/jcr:content/content/communitygroupmember.social.0.100.json", "admin", adminPassword, groupNameValuePairs);
                    JSONArray memberJsonArray = new JSONObject(memberList).getJSONArray("items");
                    for (int j = 0; j < memberJsonArray.length(); ++j) {
                        JSONObject memberJsonObject = memberJsonArray.getJSONObject(j);
                        String email = memberJsonObject.getString("authorizableId");
                        if (email == null) continue;
                        if (Math.random() < 0.9) {
                            Loader.doAnalytics(analytics, "event11", referer, resourceID, "video/mp4");
                        }
                        if (Math.random() < 0.75 && resourceType.equals("video/mp4")) {
                            Loader.doAnalytics(analytics, "event2", referer, resourceID, resourceType);
                        }
                        if (Math.random() < 0.5) {
                            Loader.doRatings(hostname, altport, adminPassword, email, resourceRatingsEndpoint, referer, resourceID, resourceType, analytics);
                        }
                        if (!(Math.random() < 0.35)) continue;
                        Loader.doComments(hostname, altport, adminPassword, email, resourceCommentsEndpoint, referer, resourceID, resourceType, analytics);
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static void doAssetsAnalytics(String analytics, String event, String evar, String assetID, String linkType, String linkName) {
        if (analytics != null && event != null && evar != null) {
            StringBuffer sb = new StringBuffer("<?xml version=1.0 encoding=UTF-8?><request><sc_xml_ver>1.0</sc_xml_ver>");
            sb.append("<events>" + event + "</events>");
            sb.append("<pageURL>http://communities.geometrixx.com</pageURL>");
            sb.append("<" + evar + ">" + assetID + "</" + evar + ">");
            sb.append("<linkType>" + linkType + "</linkType>");
            sb.append("<linkName>" + linkName + "</linkName>");
            sb.append("<visitorID>demomachine</visitorID>");
            sb.append("<reportSuiteID>" + analytics.substring(0, analytics.indexOf(".")) + "</reportSuiteID>");
            sb.append("</request>");
            Loader.postAnalytics(analytics, sb.toString());
        }
    }

    private static void doUGCAnalytics(String analytics, String event, String path, String type, String sitePath, String user, String referrer) {
        if (analytics != null && path != null && type != null && sitePath != null && user != null && event != null && referrer != null) {
            StringBuffer sb = new StringBuffer("<?xml version=1.0 encoding=UTF-8?><request><sc_xml_ver>1.0</sc_xml_ver>");
            sb.append("<events>" + event + "</events>");
            sb.append("<pageURL>" + referrer + "</pageURL>");
            sb.append("<pageName>" + referrer.replaceAll("/", ":") + "</pageName>");
            sb.append("<evar10>" + path + "</evar10>");
            sb.append("<evar7>" + type + "</evar7>");
            sb.append("<evar13>" + sitePath + "</evar13>");
            sb.append("<evar9>" + user + "</evar9>");
            sb.append("<visitorID>demomachine</visitorID>");
            sb.append("<reportSuiteID>" + analytics.substring(0, analytics.indexOf(".")) + "</reportSuiteID>");
            sb.append("</request>");
            Loader.postAnalytics(analytics, sb.toString());
        }
    }

    private static void doAnalytics(String analytics, String event, String pageURL, String resourcePath, String resourceType) {
        if (analytics != null && pageURL != null && resourcePath != null && resourceType != null && event != null) {
            try {
                URL pageurl = new URL(pageURL);
                StringBuffer sb = new StringBuffer("<?xml version=1.0 encoding=UTF-8?><request><sc_xml_ver>1.0</sc_xml_ver>");
                sb.append("<events>" + event + "</events>");
                sb.append("<pageURL>" + pageURL + "</pageURL>");
                sb.append("<pageName>" + pageurl.getPath().substring(1, pageurl.getPath().indexOf(".")).replaceAll("/", ":") + "</pageName>");
                sb.append("<evar10>" + resourcePath + "</evar10>");
                sb.append("<evar2>" + resourceType + "</evar2>");
                sb.append("<visitorID>demomachine</visitorID>");
                sb.append("<reportSuiteID>" + analytics.substring(0, analytics.indexOf(".")) + "</reportSuiteID>");
                sb.append("</request>");
                Loader.postAnalytics(analytics, sb.toString());
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postAnalytics(String analytics, String body) {
        if (analytics != null && body != null) {
            URLConnection urlConn = null;
            FilterOutputStream printout = null;
            BufferedReader input = null;
            String tmp = null;
            try {
                logger.debug((Object)("New Analytics Event: " + body));
                URL sitecaturl = new URL("http://" + analytics);
                urlConn = sitecaturl.openConnection();
                urlConn.setDoInput(true);
                urlConn.setDoOutput(true);
                urlConn.setUseCaches(false);
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                printout = new DataOutputStream(urlConn.getOutputStream());
                ((DataOutputStream)printout).writeBytes(body);
                ((DataOutputStream)printout).flush();
                printout.close();
                input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                while (null != (tmp = input.readLine())) {
                    logger.debug((Object)tmp);
                }
                printout.close();
                input.close();
            }
            catch (Exception ex) {
                logger.warn((Object)("Connectivity error: " + ex.getMessage()));
            }
            finally {
                try {
                    input.close();
                    printout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void doRatings(String hostname, String altport, String adminPassword, String key, String resourceRatingsEndpoint, String referer, String resourceID, String resourceType, String analytics) {
        try {
            ArrayList<BasicNameValuePair> ratingNameValuePairs = new ArrayList<BasicNameValuePair>();
            ratingNameValuePairs.add(new BasicNameValuePair(":operation", "social:postTallyResponse"));
            ratingNameValuePairs.add(new BasicNameValuePair("tallyType", "Rating"));
            int randomRating = (int)Math.ceil(Math.random() * 5.0);
            logger.info((Object)("Randomly Generated Rating: " + randomRating));
            ratingNameValuePairs.add(new BasicNameValuePair("referer", referer));
            ratingNameValuePairs.add(new BasicNameValuePair("response", String.valueOf(randomRating)));
            Loader.doPost(hostname, altport, resourceRatingsEndpoint + (resourceRatingsEndpoint.indexOf(".social.json") > 0 ? "" : ".social.json"), key, Loader.getPassword(key, adminPassword), (HttpEntity)new UrlEncodedFormEntity(ratingNameValuePairs), null, referer);
            Loader.doAnalytics(analytics, "event4", referer, resourceID, resourceType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static void doComments(String hostname, String altport, String adminPassword, String key, String resourceCommentsEndpoint, String referer, String resourceID, String resourceType, String analytics) {
        try {
            int randomComment = (int)Math.ceil(Math.random() * 5.0);
            logger.info((Object)("Randomly Posting a Comment " + resourceCommentsEndpoint));
            ArrayList<BasicNameValuePair> commentNameValuePairs = new ArrayList<BasicNameValuePair>();
            commentNameValuePairs.add(new BasicNameValuePair(":operation", "social:createComment"));
            commentNameValuePairs.add(new BasicNameValuePair("message", comments[randomComment - 1]));
            commentNameValuePairs.add(new BasicNameValuePair("id", "nobot"));
            Loader.doPost(hostname, altport, resourceCommentsEndpoint, key, Loader.getPassword(key, adminPassword), (HttpEntity)new UrlEncodedFormEntity(commentNameValuePairs), null, referer);
            Loader.doAnalytics(analytics, "event13", referer, resourceID, resourceType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static String doPost(String hostname, String port, String url, String user, String password, HttpEntity entity, String lookup) {
        String returnedString = null;
        HashMap<String, String> elements = new HashMap<String, String>();
        if (lookup != null) {
            elements.put(lookup, "");
        }
        Loader.doPost(hostname, port, url, user, password, entity, elements, null);
        if (lookup != null) {
            return (String)elements.get(lookup);
        }
        return returnedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int doPost(String hostname, String port, String url, String user, String password, HttpEntity entity, Map<String, String> elements, String referer) {
        String jsonElement = null;
        if (hostname == null || port == null || url == null || user == null || password == null) {
            logger.error((Object)"Can't POST with requested parameters, one is null");
            return 500;
        }
        int returnCode = 404;
        try {
            HttpHost target = new HttpHost(hostname, Integer.parseInt(port), "http");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            try {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authCache);
                String postUrl = "http://" + hostname + ":" + port + url;
                logger.info((Object)("Posting request as " + user + " to " + postUrl));
                HttpPost request = new HttpPost(postUrl);
                request.setEntity(entity);
                if (!entity.getContentType().toString().contains("multipart")) {
                    request.addHeader("content-type", "application/x-www-form-urlencoded");
                }
                request.addHeader("Accept", "application/json, text/javascript, */*; q=0.01");
                request.addHeader("Origin", postUrl);
                if (referer != null) {
                    request.addHeader("Referer", referer);
                }
                CloseableHttpResponse response = httpClient.execute(target, (HttpRequest)request, (HttpContext)localContext);
                try {
                    returnCode = response.getStatusLine().getStatusCode();
                    String responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    if (returnCode >= 500) {
                        logger.error((Object)("POST return code: " + returnCode));
                        int n = returnCode;
                        return n;
                    }
                    if (returnCode >= 400) {
                        logger.warn((Object)("POST return code: " + returnCode));
                        int n = returnCode;
                        return n;
                    }
                    logger.debug((Object)responseString);
                    if (elements == null) {
                        int n = returnCode;
                        return n;
                    }
                    Set<String> keys = elements.keySet();
                    if (!Loader.isJSONValid(responseString) && keys.size() > 0) {
                        logger.debug((Object)"POST operation didn't return a JSON string, trying to extract the location from HTML results");
                        Matcher m = Pattern.compile("<a href=\"(.*)\" id=\"Location\">.*</a>").matcher(responseString);
                        if (m.find()) {
                            logger.info((Object)("Location is:" + m.group(1)));
                            elements.put("location", m.group(1));
                        }
                        int n = returnCode;
                        return n;
                    }
                    Iterator<String> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String lookup;
                        block34: {
                            block35: {
                                lookup = iterator.next();
                                if (lookup == null) break block34;
                                int separatorIndex = lookup.indexOf("/");
                                if (separatorIndex <= 0) break block35;
                                Object object = new JSONObject(responseString).get(lookup.substring(0, separatorIndex));
                                if (object != null) {
                                    if (object instanceof JSONArray) {
                                        JSONArray jsonArray = (JSONArray)object;
                                        if (jsonArray.length() == 1) {
                                            JSONObject jsonObject = jsonArray.getJSONObject(0);
                                            jsonElement = jsonObject.getString(lookup.substring(1 + separatorIndex));
                                            logger.debug((Object)("JSON value (jsonArray) returned is " + jsonElement));
                                        }
                                        break block34;
                                    } else if (object instanceof JSONObject) {
                                        JSONObject jsonobject = (JSONObject)object;
                                        jsonElement = jsonobject.getString(lookup.substring(1 + separatorIndex));
                                        logger.debug((Object)("JSON value (jsonObject) returned is " + jsonElement));
                                    }
                                }
                                break block34;
                            }
                            jsonElement = new JSONObject(responseString).getString(lookup);
                            logger.debug((Object)("JSON (top) value returned is " + jsonElement));
                        }
                        elements.put(lookup, jsonElement);
                    }
                    return returnCode;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                    return returnCode;
                }
                finally {
                    response.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                return returnCode;
            }
            finally {
                httpClient.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String hostname, String port, String url, String user, String password) {
        String responseString = null;
        if (hostname == null || port == null || url == null || user == null || password == null) {
            logger.error((Object)"Can't POST with requested parameters, one is null");
            return responseString;
        }
        try {
            HttpHost target = new HttpHost(hostname, Integer.parseInt(port), "http");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            try {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authCache);
                String postUrl = "http://" + hostname + ":" + port + url;
                HttpPost request = new HttpPost(postUrl);
                CloseableHttpResponse response = httpClient.execute(target, (HttpRequest)request, (HttpContext)localContext);
                try {
                    int returnCode = response.getStatusLine().getStatusCode();
                    responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    if (returnCode >= 500) {
                        logger.fatal((Object)("Server error" + responseString));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
                finally {
                    response.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            finally {
                httpClient.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return responseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDelete(String hostname, String port, String url, String user, String password) {
        try {
            HttpHost target = new HttpHost(hostname, Integer.parseInt(port), "http");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
            try {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(target, (AuthScheme)basicAuth);
                HttpClientContext localContext = HttpClientContext.create();
                localContext.setAuthCache((AuthCache)authCache);
                String postUrl = "http://" + hostname + ":" + port + url;
                logger.info((Object)("Deleting path as " + user + " to " + postUrl));
                HttpDelete request = new HttpDelete(postUrl);
                httpClient.execute(target, (HttpRequest)request, (HttpContext)localContext);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            finally {
                httpClient.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private static String doWait(String hostname, String port, String user, String password, String group, int max) {
        String groupList = null;
        if (group == null || group.length() == 0) {
            logger.warn((Object)"Group name was not provided");
            return null;
        }
        if (hostname != null && port != null && password != null && user != null && group != null && group.length() > 0) {
            int retries = 0;
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("type", "rep:Group"));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("property", "rep:authorizableId"));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("property.value", group));
            while (retries < max) {
                groupList = Loader.doGet(hostname, port, "/bin/querybuilder.json", user, password, nameValuePairs);
                if (groupList.indexOf("\"results\":1") > 0) {
                    logger.info((Object)("Group " + group + " was found on " + port));
                    return groupList;
                }
                if (++retries >= max) continue;
                Loader.doSleep(1000L, "Group " + group + " not found yet, pausing");
            }
            if (retries == max && max > 1) {
                logger.warn((Object)("Group " + group + " was not found as expected"));
            }
        }
        return null;
    }

    private static String doQuery(String hostname, String port, String adminPassword, String path, String type) {
        String query = null;
        if (port != null && hostname != null && path != null && type != null) {
            String nodeList;
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("path", path));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("type", type));
            query = nodeList = Loader.doGet(hostname, port, "/bin/querybuilder.json", "admin", adminPassword, nameValuePairs);
        }
        return query;
    }

    private static void doWaitAssetCompleted(String hostname, String port, String adminPassword, String location, int maxretries) {
        if (location == null) {
            return;
        }
        int retries = 0;
        while (retries++ < maxretries) {
            String assetJson = Loader.doGet(hostname, port, location + "/jcr:content.json", "admin", adminPassword, null);
            if (assetJson != null) {
                try {
                    JSONObject assetJsonObject = new JSONObject(assetJson);
                    String assetStatus = assetJsonObject.getString("dam:assetState");
                    if (assetStatus == null || assetStatus.equals("") || assetStatus.equals("processed")) break;
                    Loader.doSleep(2000L, "Asset not processed yet, attempt: " + retries);
                    continue;
                }
                catch (Exception ex) {
                    logger.debug((Object)"Asset state not available");
                    break;
                }
            }
            logger.debug((Object)"Asset state call not successful");
            break;
        }
    }

    private static void doWaitWorkflowsCompleted(String hostname, String port, String adminPassword, String context, int maxretries) {
        int retries = 0;
        while (retries++ < maxretries) {
            String runningWorkflows = Loader.doPost(hostname, port, "/system/console/jmx/com.adobe.granite.workflow%3Atype%3DMaintenance/op/listRunningWorkflowsPerModel/", "admin", adminPassword);
            if (runningWorkflows != null) {
                Matcher m = Pattern.compile("<td>([0-9]+)</td>").matcher(runningWorkflows);
                if (!m.find()) break;
                Loader.doSleep(2000L, m.group(1) + " running workflows for " + context + " were found, waiting for completion, attempt " + retries);
                logger.info((Object)runningWorkflows);
                continue;
            }
            Loader.doSleep(2000L, "Cannot get the list of running workflows for " + context + ", attempt " + retries);
        }
    }

    private static void doWaitPath(String hostname, String port, String adminPassword, String path, int maxretries) {
        int retries = 0;
        while (retries++ < maxretries) {
            if (Loader.isResourceAvailable(hostname, port, adminPassword, path)) {
                logger.info((Object)("Node is found for: " + path + " on port: " + port));
                return;
            }
            Loader.doSleep(1000L, "Node not found for: " + path + " on port: " + port + " attempt " + retries);
        }
        logger.error((Object)"Node was never found - something is wrong!");
    }

    private static boolean isResourceAvailable(String hostname, String port, String password, String path) {
        String json;
        boolean isAvailable = false;
        if (path == null || hostname == null || port == null || password == null) {
            return false;
        }
        int pos = path.lastIndexOf("/");
        int pos2 = path.indexOf(".", pos);
        if (pos2 > 0) {
            path = path.substring(0, pos2);
        }
        if (path.endsWith(".json")) {
            path = path.replaceAll("\\.json", "");
        }
        if ((json = Loader.doGet(hostname, port, path = path + ".json", "admin", password, null)) != null) {
            isAvailable = true;
        }
        return isAvailable;
    }

    private static String doGet(String hostname, String port, String url, String user, String password, List<NameValuePair> params) {
        return Loader.doGet(hostname, port, url, user, password, params, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doGet(String hostname, String port, String url, String user, String password, List<NameValuePair> params, boolean debug) {
        String rawResponse;
        block16: {
            rawResponse = null;
            try {
                HttpHost target = new HttpHost(hostname, Integer.parseInt(port), "http");
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
                CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                try {
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    authCache.put(target, (AuthScheme)basicAuth);
                    HttpClientContext localContext = HttpClientContext.create();
                    localContext.setAuthCache((AuthCache)authCache);
                    URIBuilder uribuilder = new URIBuilder();
                    uribuilder.setScheme("http").setHost(hostname).setPort(Integer.parseInt(port)).setPath(url);
                    if (params != null) {
                        for (NameValuePair nvp : params) {
                            uribuilder.setParameter(nvp.getName(), nvp.getValue());
                        }
                    }
                    URI uri = uribuilder.build();
                    logger.info((Object)("Getting request at " + uri.toString()));
                    HttpGet httpget = new HttpGet(uri);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget, (HttpContext)localContext);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        try {
                            rawResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                            break block16;
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage());
                            break block16;
                        }
                        finally {
                            response.close();
                        }
                    }
                    logger.debug((Object)("GET return code: " + response.getStatusLine().getStatusCode()));
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage());
                }
                finally {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (debug) {
            logger.debug(rawResponse);
        }
        return rawResponse;
    }

    private static void dumpNVP(List<NameValuePair> nameValuePairs) {
        for (NameValuePair nvp : nameValuePairs) {
            logger.debug((Object)(nvp.getName() + ":" + nvp.getValue()));
        }
    }

    private static List<NameValuePair> convertArrays(List<NameValuePair> nameValuePairs, String key) {
        ArrayList<NameValuePair> newNameValuePairs = new ArrayList<NameValuePair>();
        for (NameValuePair nvp : nameValuePairs) {
            if (nvp.getName().equals(key)) {
                try {
                    JSONArray jsonArray = new JSONArray(nvp.getValue());
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        String value = (String)jsonArray.get(i);
                        value = URLEncoder.encode(value.replaceAll("'", "\""), StandardCharsets.UTF_8.toString());
                        newNameValuePairs.add((NameValuePair)new BasicNameValuePair(key, value));
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Can't process JSON array for key: " + key));
                    continue;
                }
            }
            newNameValuePairs.add(nvp);
        }
        return newNameValuePairs;
    }

    private static List<NameValuePair> convertKeyName(List<NameValuePair> nameValuePairs, String oldkey, String newkey) {
        ArrayList<NameValuePair> newNameValuePairs = new ArrayList<NameValuePair>();
        for (NameValuePair nvp : nameValuePairs) {
            if (nvp.getName().equals(oldkey)) {
                newNameValuePairs.add((NameValuePair)new BasicNameValuePair(newkey, nvp.getValue()));
                continue;
            }
            newNameValuePairs.add(nvp);
        }
        return newNameValuePairs;
    }

    private static List<NameValuePair> buildNVP(String hostname, String port, String adminPassword, String path, CSVRecord record, int start, boolean isCommunities64orlater) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        ArrayList<String> alreadyLoaded = new ArrayList<String>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("_charset_", "UTF-8"));
        for (int i = start; i < record.size() - 1; i += 2) {
            if (record.get(i) == null || record.get(i + 1) == null || record.get(i).length() <= 0) continue;
            String name = record.get(i);
            String value = record.get(i + 1);
            if (value.equals("TRUE")) {
                value = "true";
            }
            if (value.equals("FALSE")) {
                value = "false";
            }
            if (isCommunities64orlater) {
                if (name.equals("parentPath") && value.contains("/etc/cloudservices")) {
                    value = "/conf/global/settings/cloudconfigs";
                } else if (value.contains("/etc/cloudservices")) {
                    value = value.replaceAll("/etc/cloudservices/(.*connect)/", "/conf/global/settings/cloudconfigs/");
                }
            }
            if (name.startsWith("cq:cloudserviceconfigs") && !Loader.isResourceAvailable(hostname, port, adminPassword, value)) {
                logger.warn((Object)("Resource " + value + " is not available"));
                continue;
            }
            int addition = name.indexOf("+");
            if (addition > 0 && path != null) {
                BasicNameValuePair bvOption;
                BasicNameValuePair bvHint;
                if (!alreadyLoaded.contains(name = name.substring(0, addition))) {
                    alreadyLoaded.add(name);
                    String existingValues = Loader.doGet(hostname, port, path + ".json", "admin", adminPassword, null);
                    try {
                        JSONObject propertyJson = new JSONObject(existingValues.trim());
                        Iterator keys = propertyJson.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            if (!name.startsWith(key)) continue;
                            JSONArray propertyList = (JSONArray)propertyJson.get(key);
                            for (int j = 0; j < propertyList.length(); ++j) {
                                String propertyValue = (String)propertyList.get(j);
                                nameValuePairs.add((NameValuePair)new BasicNameValuePair(name, propertyValue));
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                    }
                }
                if (!nameValuePairs.contains(bvHint = new BasicNameValuePair(name + "@TypeHint", "String[]"))) {
                    nameValuePairs.add((NameValuePair)bvHint);
                }
                if (nameValuePairs.contains(bvOption = new BasicNameValuePair(name, value))) continue;
                nameValuePairs.add((NameValuePair)bvOption);
                continue;
            }
            int hint = name.indexOf("@");
            if (hint > 0) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(name.substring(0, hint) + "@TypeHint", name.substring(1 + hint)));
                name = name.substring(0, hint);
            } else if (path == null || path.indexOf(".json") < 0) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(name + "@TypeHint", "String"));
            }
            int multiple = value.indexOf("|");
            if (multiple > 0) {
                List<String> values = null;
                values = value.indexOf("~") > 0 ? Arrays.asList(value.split("~", -1)) : Arrays.asList(value.split("\\|", -1));
                for (String currentValue : values) {
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair(name, currentValue));
                }
                continue;
            }
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return nameValuePairs;
    }

    public static Version getVersion(String jsonList, String symbolicName) {
        if (jsonList == null || symbolicName == null) {
            return null;
        }
        try {
            JSONObject bundleJson = new JSONObject(jsonList.trim());
            Iterator keys = bundleJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.equals("data")) continue;
                JSONArray bundleList = (JSONArray)bundleJson.get(key);
                for (int i = 0; i < bundleList.length(); ++i) {
                    JSONObject bundle = (JSONObject)bundleList.get(i);
                    if (!bundle.get("symbolicName").equals(symbolicName)) continue;
                    String version = (String)bundle.get("version");
                    version = version.replace(".SNAPSHOT", "").trim();
                    logger.info((Object)(symbolicName + " : " + version));
                    return new Version(version);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static String slugify(String input) {
        return Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replaceAll("[^ \\w]", "").trim().replaceAll("\\s+", "-").toLowerCase(Locale.ENGLISH);
    }

    public static boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static String title2name(String title) {
        return title.replaceAll(" ", "_").replaceAll("\\.", "_").toLowerCase();
    }

    public static void printPOST(HttpEntity entity) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            entity.writeTo((OutputStream)out);
            String string = out.toString();
            logger.debug((Object)string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

